<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com
 */
 
!defined('XERCMS') && exit('Access Denied');

class XerCMS_MODULE_forms
{ 
     var $fid    = 0;
     var $model  = array();
     var $access = array();
     
     function __construct() {
          $this->fid = (int)g('fid');
          $this->model = ini('forms/struct/'.$this->fid);
          if(!$this->model) $this->msg('表单不存在，请与管理员联系。');
          $this->access = ini('forms/access/'.$this->fid);
          if(!in_array(X::$G['uid'],X::$G['superadmin']) && !in_array(X::$G['group'],$this->access)) {
               $this->msg('所在群组无法提交表单。');
          }
          
          if($this->model['limit'] > 0) {
               $count = DB::result_first('SELECT `number` FROM xercms_form_count WHERE fid = \''.$this->fid.'\'');
               if($count >= $this->model['limit']) {
                    $this->msg('提交数量已达到最大限制，无法再提交。');
               }
          }
          if($this->model['stime'] > 100 && $this->model['stime'] > X::$G['time']) {
               $this->msg('投递时间于 '.date('Y-m-d H:i:s',$this->model['stime']).' 开始！');
          }
          if($this->model['etime'] > 100 && $this->model['etime'] < X::$G['time']) {
               $this->msg('投递时间已于 '.date('Y-m-d H:i:s',$this->model['etime']).' 结束');
          }
          
          if(X::$G['uid']) {
               $count = DB::result_first('SELECT count(*) FROM xercms_form_count WHERE uid = \''.X::$G['uid'].'\' AND fid = \''.$this->fid.'\'');
               if($count > 0) {
                    $this->msg('已投递过拉。');
               }
          }    
     }      
     
     function show() {
          $submitUrl = '?m=extends&e=forms&a=submit&fid='.$this->fid;
          include_once(atpl('XerCMS/Data/forms/template/',$this->model['sname'].'.htm'));
     }
     
     function msg($str) {
          exit(X::$G['format'] == 'json' ? json_encode(array('msg'=>$str)) : $str);
     }         

     function submit() {
          $data = p('model');$sdata = array();
      	foreach($this->model['struct'] as $k=>$v) {
			if(!isset($data[$k])) {
                    if($v['required'] == '1') {
                         $this->msg($v['comments']);
                    } else $data[$k] = $v['default'];
               } else {
		        	if($v['type'] == 'int') {
			       	$data[$k] = (int)$data[$k];
                      	if($data[$k] < $v['range'][0]) {
                           	$data[$k] = $v['range'][0];
                     	} else if (isset($v['range'][1]) && $data[$k] > $v['range'][1]) {
                           	$data[$k] = $v['range'][1];
                      	}
			   	} else if ($v['type'] == 'float') {
			       	$data[$k] = (float)$data[$k];
                      	if($data[$k] < $v['range'][0]) {
                           	$data[$k] = $v['range'][0];
                      	} else if (isset($v['range'][1]) && $data[$k] > $v['range'][1]) {
                           	$data[$k] = $v['range'][1];
                      	}
			   	} else {
                    	$max = isset($v['range'][1]) ? $v['range'][1] : $v['range'][0];
                    	if(strlen($data[$k]) > $max) {
                         	$data[$k] = mb_substr($data[$k],0,(int)$max);
                    	}     
			      	$data[$k] = htmlchars($data[$k]);
			   	}
			}
               $sdata[$k] = $data[$k];
		}
          $sid = DB::insert('xercms_form_submit',array('uid'=>X::$G['uid'],'time'=>X::$G['time'],'ip'=>X::$G['ip'],'fid'=>$this->fid));
          DB::insert('xercms_form_data',array('sid'=>$sid,'txt'=>jsonSql($sdata)));
          DB::query('UPDATE xercms_form_count SET number = number + 1,time = \''.X::$G['time'].'\',uid = \''.X::$G['uid'].'\' WHERE fid = \''.$this->fid.'\'');
          $this->msg('提交成功，感谢您的参与。');
     }
}
?>