<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com
 */

!defined('XERCMS') && exit('Access Denied');

class TABLE_config extends resource
{
     private $data = NULL;
     private $defaultTable = 'xercms_config';
     private $file = '';
     private $developer = 0;
	 
	function __construct() {
		$this->table = $this->defaultTable;
		$this->limit = ' LIMIT 100';
	}
	 
	function developer($str) {
	 	$this->developer = $str;
          return $this;		 
	}
	 
	function file($str) {
	     $this->file = $str;
          return $this;		 
	}	 

	function get($id) {
	     $data = $this->where(array('id'=>$id))->select(1);
		$data['content'] = $data['format'] == 1 ? json_decode($data['content'],true) : $data['content'];
	     return $data;
	}
	 
	function search($where) {
	     $data = $this->where($where)->select(1);
		$data['content'] = $data['format'] == 1 ? json_decode($data['content'],true) : $data['content'];
	     return $data;
	}
      
	function configs($file) {
          if($file == 'globals') {
               $data = $this->where(array('file'=>$file,'developer'=>0))->select(0);
          } else $data = $this->where(array('file'=>$file))->select(0);
	     
		if(empty($data))
	 	 	return array();
		foreach($data as $v) {
			$v['content'] = $v['format'] == 1 ? json_decode($v['content'],true) : $v['content'];
			$configs[$v['file']][$v['tag']] = $v;
		}
		//print_r($configs);exit;
		return $configs;
	}
	 
     function del($id) {
	     $config = $this->get($id);
		if($config['developer'] > 0)
		     return -1;
		$this->delete(array('id'=>$id));
	}

     function set($arr) {
	     if(!isset($arr['name']) || empty($arr['name']))
	 	 	return -2;
		$data = $this->where(array('file'=>$arr['file'],'tag'=>$arr['tag']))->select(1);	
		 
		if(isset($data['developer']) && $data['developer'] > 0) {
               if($data['developer'] > 1) {
                    return -1;
               } else {
                    //print_r($arr['developer']);exit;
                    if(!isset($arr['developer']) || $arr['developer'] != 1) {
                         return -1;
                    }
               }
                
          }
         //$arr['content'] = stripcslashes($arr['content']);			   
		$arr['content'] = isset($arr['format']) && $arr['format'] == 1 ? jsonSql($arr['content']) : $arr['content'];		 
		if(!isset($data['id'])) {
		     unset($arr['uid']);
			$this->insert($arr);
		} else {
		     $id = $data['id'];
	 	 	$this->where(array('id'=>$id))->update($arr);
		}
	}
	 
     function add($arr) {
	     if(!isset($arr['name']) || empty($arr['name']))
	 	 	return -2;
		$arr['content'] = isset($arr['format']) && $arr['format'] == 1 ? jsonSql($arr['content']) : $arr['content'];
		$this->insert($arr);
	}
}
?>