<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com　
 */

!defined('XERCMS') && exit('Access Denied');

class Valid_column extends Valid
{	 
     var $data  = '';
     
     public function checkBasic($data) {
          $this->data = $data;
          $result = ($this->checkTemplet() 
               && $this->checkSort() 
                    && $this->checkNumber()
                         && $this->checkIcon()
                              && $this->checkKeyword()
                                   && $this->checkName()
                    ) ? true : false;
          return $result;
	}

     private function checkIcon() {
          if(empty($this->data['icon'])) {
               //$this->setError('频道图标未设置！'); 
               //return false;            
          }
          return true;
     }
     
     private function checkKeyword() {
          if(empty($this->data['keyword'])) {
               //$this->setError('关键词未设置！'); 
               //return false;            
          }
          return true;
     }
     
     private function checkName() {
          if(empty($this->data['name'])) {
               $this->setError('频道名称未设置！'); 
               return false;            
          }
          return true;
     }
     
     private function checkSort() {
          if(!in_array($this->data['by'],array('ctime','mtime','hits','flower','egg','score'))) {
               $this->setError('排序类型不正确！'); 
               return false;            
          }
          if(!in_array($this->data['order'],array('DESC','ASC'))) {
               $this->setError('排序方式不正确！'); 
               return false;            
          }
          return true;
     }
     
     private function checkNumber() {
          if(!$this->isNumber($this->data['number'])) {
               $this->setError('每页显示数量须为整数！'); 
               return false;            
          }
          return true;
     }
     
     private function checkTemplet() {
          if(!isset($this->data['mode']) || !$this->isNumber($this->data['mode']) || $this->data['mode'] > 5 || $this->data['mode'] < 0) {
               $this->setError('频道模式错误！'); 
               return false;
          }
          if(isset($this->data['template'])) {
               if($this->data['mode'] == 4) {
                    $Ts = array('index'=>'封面模板','list'=>'列表模板','detail'=>'内容模板','show'=>'展示模板');                
               } else if ($this->data['mode'] == 1) {
                    $Ts = array('list'=>'列表模板','detail'=>'内容模板');
               } else if ($this->data['mode'] == 5) {
                    $Ts = array('list'=>'列表模板','detail'=>'内容模板','show'=>'展示模板');
               } else if ($this->data['mode'] == 0) {
                    $Ts = array('index'=>'封面模板','list'=>'列表模板','detail'=>'内容模板'); 
               } else if ($this->data['mode'] == 2) {
                    $Ts = array('index'=>'封面模板'); 
               } else {
                    if(empty($this->data['url'])) {
                         $this->setError('<font style="color:red">外部链接未设置！'); 
                         return false;                        
                    }
               }
               foreach($Ts as $k=>$v) {
                    if(empty($this->data['template'][$k])) {
                         $this->setError('<font style="color:red">[&nbsp;'.$v.'&nbsp;]</font>不能为空！'); 
                         return false;     
                    }
                    
                    if(!file_exists(XERCMS.'Template/XerCMS/6feb39028f7bfe1640b0b269671abb7d/'.$this->data['template'][$k]) 
                         && !file_exists(XERCMS.'Template/'.X::$CONFIG['tplname'].'/'.X::$CONFIG['tpldir'].'/'.$this->data['template'][$k])) {
                              //exit(XERCMS.'Template/'.X::$CONFIG['tplname'].'/'.X::$CONFIG['tpldir'].'/'.$this->data['template'][$k]);
                         $this->setError('<font style="color:red">[&nbsp;'.$v.'&nbsp;]</font>找不到！'); 
                         return false;                      
                    }
               }
               
          } else {
               $this->setError('频道模板未设置！'); 
               return false;
          }
          return true;
     }
 
}
?>