<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com
 */

!defined('XERCMS') && exit('Access Denied');

class Valid_config extends Valid
{	 
     var $data  = '';

     public function check($data) {
          $this->data = $data;
          switch($data['file']) {
               case 'kernel':
                    return $this->kernel();
               break;
               case 'globals': 
                    if(in_array($this->data['tag'],array('CYK','area','uid','nick','group','member'))) {
                         $this->setError('无法创建，请修改标签！');
                         return false;
                    }               
                    return ($this->checkfile($data['file']) && $this->checkTag($this->data['tag'])) ? true : false;              
               break;             
               default:
                    return ($this->checkfile($data['file']) && $this->checkTag($this->data['tag'])) ? true : false;
               break;
          }
     }
     
     public function checkfile($name) {
		if(preg_match('/([^0-9a-z\_\:]+)/i',$name)) {
			$this->setError('配置文件不正确！');  
               return false;
          }
          return true;
     }
     
     public function kernel() {
          
          if(!$this->checkTag($this->data['tag'])) {
               return false;               
          }
		switch($this->data['tag']) {
               case 'urlmode':
                    if(!in_array($this->data['content'],array('dynamic','static'))) {
                         $this->setError('链接模式错误！');  
                         return false;
                    }
               break;
               case 'expire':
                    if(!$this->isNumber($this->data['content']) || $this->data['content'] < 0) {
                         $this->setError('缓存时间须为正确的整数型时间！');  
                         return false;
                    }
               break; 
               case 'commentaudit':
                    if(!in_array($this->data['content'],array('0','1'))) {
                         $this->setError('请正确设置是否允许匿名评论！');  
                         return false;
                    }
               break; 
               case 'gzip':
                    if(!in_array($this->data['content'],array('0','1'))) {
                         $this->setError('请正确设置是否开启Gzip传输！');  
                         return false;
                    }
               break; 
               case 'state':
                    if(!in_array($this->data['content'],array('normal','close'))) {
                         $this->setError('请正确设置网站状态！');  
                         return false;
                    }
               break;                
               
          }
          return true;
     }
     
     public function checkTag($tag) {
		if(preg_match('/([^0-9a-z\_]+)/i',$tag)) {
			$this->setError('标签命名不正确！');  
               return false;
          }
          return true;
     }
}
?>