<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com
 */

!defined('XERCMS') && exit('Access Denied');

class Valid_safe extends Valid
{	 
     var $data  = '';
     
     private function checkadmins() {
          if(empty($this->data['admins'])) {
               $this->setError('用户编号不能为空！');
               return false;
          }
               
	 	foreach($this->data['admins'] as $v) {
               if(!is_numeric($v)) {
                    $this->setError('用户编号不存在！');
                    return false;
               }    
          }
          $members =  DB::fetch_all('SELECT uid FROM xercms_member WHERE uid in ('.implode(',',$this->data['admins']).')');
          $error_admin = array();
          if(count($this->data['admins']) != count($members)) {
               $normal_admin = array();
               foreach($members as $v) {
                    $normal_admin[] = $v['uid'];
               }   
               if(empty($normal_admin)) {
                    $error_admin = $this->data['admins'];
               } else {
                    foreach($this->data['admins'] as $v) {
                         if(!in_array($v,$normal_admin)) {
                              $error_admin[] = $v;
                         }
                    }  
               }               
          }

          if(!empty($error_admin)) {
               $this->setError('ID: '.implode(',',$error_admin).' 用户不存在！');
               return false;
          }
          return true;         
          
     }
     
     public function check($data) {
          $this->data = $data;
          $result = ($this->checkadmins() && $this->checktime() && $this->checkips()) ? true : false;
          return $result;
	}
 
     private function checkips() {
          if(empty($this->data['allowip'])) {
               return true; 
          }  
          $this->data['allowip'] = explode(',',strtr($this->data['allowip'],array('*'=>'0')));
          foreach($this->data['allowip'] as $v) {
               if(!$this->isIp($v)) {
                    $this->setError('IP地址不正确！');
                    return false;
               }
          }
          return true;
     }
     
     private function checktime() {
          if(empty($this->data['worktime'])) {
               $this->setError('访问时间不能为空！');
               return false; 
          }  
          $this->data['worktime'] = explode(',',$this->data['worktime']);
          foreach($this->data['worktime'] as $v) {
               if(!$this->isNumber($v) || $v > 24 || $v < 0) {
                    $this->setError('访问时间须在24小时内！');
                    return false;
               }
          }
          return true;
     }
}
?>