<?php
function get_pagerank($url) {
	require(ROOT_PATH.'include/pagerank.php');
	
	$pr = new PageRank();
	return $pr->getGPR($url);
}

function get_sogourank($url) {
	$data = get_url_content("http://pr.cnzzla.com/?url=$url");
	if (preg_match('/class=\"sre\">(\d+)<\/span>/i', $data, $matches)) {
		$rank = intval($matches[1]);
	} else {
		$rank = 0;
	}
	return $rank;
}

function format_url($url) {
	if ($url != "") {
		$url_parts = parse_url($url);
		$port = !empty($url_parts['port']) ? ':'.$url_parts['port'] : '';
		$url = (!empty($url_parts['scheme']) ? $url_parts['scheme'].'://'.$url_parts['host'] : (!empty($url_parts['host']) ? 'http://'.$url_parts['host'] : 'http://'.$url_parts['path'])).$port;
		return $url;
	}
}

/** 获取指定URL内容 */
function get_url_content($url) {
	require_once(ROOT_PATH.'include/snoopy.php');
	
	$snoopy = new Snoopy();
	$snoopy->agent = $_SERVER['HTTP_USER_AGENT'];
	$snoopy->referer = $_SERVER['HTTP_REFERER'];
	$snoopy->fetch($url);
	if (!$snoopy->timed_out) {
		$data = $snoopy->results;
		$encode = mb_detect_encoding($data, array('ascii', 'gb2312', 'utf-8', 'gbk'));
		if ($encode == 'EUC-CN' || $encode == 'CP936') {
			$data = @mb_convert_encoding($data, 'utf-8', 'gb2312');
		}
		return $data;
	}
}

function rewrite_output($url) {
	return 'href="'.SITE_DIR.'pagerank/'.$url.'"';
}

function redirect($url) {
    header('location:'.$url, false, 301);
	exit;
}
?>