<?
set_time_limit(600);
class admin_dialog_backup extends admin_dialog {


    var $fp = null;
    var $bkpDir = "var/backup/";

    function getDumpTime($fname) {
        return date("Y.m.d - G:i:s", filemtime($this->bkpDir.$fname));
    }

    function makeData() {
        parent::makeData();


        $this->files = null;
        $dh = opendir($this->bkpDir);
        while (($dir = readdir($dh)) !== false) {
            if(($dir != ".") && ($dir != "..") && ($dir != ".htaccess")) {
                $this->files[] = array("file" => $dir,
                                       "time" => $this->getDumpTime($dir) );
            }
        }
    }



    function _mysqldump() {
        $tables = array(
            "custompages",
            "feedback",
            "feeds",
            "feeds_categories",
            "flash",
            "flash_categories",
            "messages",
            "profiles",
            "sendmail",
            "users",
            "websearch",
            "html_widgets");
        for($i=0; $i<count($tables); $i++) {
            $tn = _DB_TABLE_PREFIX.$tables[$i];
            $this->_mysqldump_table_structure($tn);
            $this->_mysqldump_table_data($tn);
        }
    }


    function _mysqldump_table_structure($table) {
        $out = "\nDROP TABLE IF EXISTS `$table`;\n\n";
        $sql = "show create table `$table`; ";
        $result = mysql_query($sql, $this->db->_db_link);
        if($result) {
            if($row = mysql_fetch_assoc($result)) {
                $out .= $row['Create Table'].";\n\n";
            }
        }
        fwrite($this->fp, $out);
        mysql_free_result($result);
    }


    function _mysqldump_table_data($table) {
        $sql = "select * from `$table`;";
        $result = mysql_query($sql, $this->db->_db_link);
        if($result) {
            $num_rows = mysql_num_rows($result);
            $num_fields = mysql_num_fields($result);

            if($num_rows > 0) {
                $field_type = array();
                $i = 0;
                while($i < $num_fields) {
                    $meta = mysql_fetch_field($result, $i);
                    array_push($field_type, $meta->type);
                    $i++;
                }

                fwrite($this->fp, "\ninsert into `$table` values\n");
                $index=0;
                while($row = mysql_fetch_row($result)) {
                    $out = "(";
                    for($i=0; $i < $num_fields; $i++) {
                        if(is_null($row[$i])) {
                            $out .= "null";
                        } else {
                            switch( $field_type[$i]) {
                                case 'int':
                                    $out .= $row[$i];
                                    break;
                                case 'string':
                                case 'blob' :
                                default:
                                    $out .= "'".mysql_real_escape_string($row[$i])."'";
     
                            }
                        }
                        if($i < $num_fields-1) {
                            $out .= ",";
                        }
                    }
                    $out .= ")";

                    if($index < $num_rows-1) {
                        $out .= ",";
                    } else {
                        $out .= ";";
                    }
                    fwrite($this->fp, $out."\n");
                    $index++;
                }
            }
        }
        mysql_free_result($result);
    }




    function action_dump() {
//        $fname = date("Y-m-d_G-i-s").".sql";
        $fname = time().".sql";
        $this->fp = fopen($this->bkpDir.$fname, "w+");
        if($this->fp) {
            $this->_mysqldump();
            fclose($this->fp);
            $this->dump_file = $this->getDumpTime($fname);
        } else {
            $this->write_error = true;
        }
    }


    function action_delete() {
        $this->delete_file = $this->getDumpTime($_REQUEST["file"]);
        if(@unlink($this->bkpDir.$_REQUEST["file"])) {
        } else {
            $this->delete_file = false;
        }
    }


    function action_restore() {
        $fname = $this->bkpDir.$_REQUEST["file"];
        if(file_exists($fname)) {
            $this->db->sdImportFromFile($fname);
            $this->restore_file = $this->getDumpTime($_REQUEST["file"]);
        }
    }

}
?>