<?
class db_object extends object {



var $table_name = null;
var $row = array();
var $null_result = false;


    function constructor($id = null) {
        parent::constructor();
        $this->table_name = _DB_TABLE_PREFIX.$this->table_name;
        $this->db =& func_new_once("mysql"); 
        if(!is_null($id)) {
            $this->row = $this->db->get_first("SELECT * FROM ".$this->table_name." WHERE id = %id%", $id);
        }
        if(!$this->isEmpty()) {
            $this->fillObject();
        } else {
            $this->id = 0;
        }
    }



    function create() {
        $this->db->insert($this->table_name, $this->row);
        $this->id = $this->row["id"] = $this->db->insert_id();
    }


    function update() {
        $this->db->update($this->table_name, $this->row, "id = %id%", $this->row);
        return $this->db->affected_rows() > 0;
    }


    function updateFields($fields) {
        $this->db->update($this->table_name, $fields, "id = %id%", $this->id);
    }


    function delete($id = null) {
        if(is_null($id)) {
            $this->db->query("DELETE FROM ".$this->table_name." WHERE id = %id%", $this->row);
        } else {
            $this->db->query("DELETE FROM ".$this->table_name." WHERE id = %id%", $id);
        }
        return $this->db->affected_rows() > 0;
    }





    function fillObject() {
        if(is_array($this->row)) {
            foreach($this->row as $k => $v) {
                $this->$k = $this->row[$k];
            }
        }
    }


    function isEmpty() {
        return empty($this->row["id"]);
    }



    function findAll($what, $fields = null, $start = null, $order = null) {
        $sql = $this->buildSelect($what).
               $this->buildFrom().
               $this->buildWhere($fields).
               $this->buildTail($start, $order);
        if($this->null_result) {
            return null;
        } else {
            $result = $this->db->get_list($sql, $fields);
        }
    
        $i = 1;
        foreach ($result as $idx => $value) {
            $result[$idx]['i'] = $i;
            $i++;
        }
        return $result;
    }



    function find($what, $fields = null, $start = null, $order = null) {
        $sql = $this->buildSelect($what).
               $this->buildFrom().
               $this->buildWhere($fields).
               $this->buildTail($start, $order);
//echo($sql);
        if($this->null_result) {
            return null;
        } else {
            return $this->db->get_one($sql, is_array($fields) ? $fields : null);
        }
    }



    function buildSelect($what) {
        $res = "SELECT ";
        if(is_array($what)) {
            $res .= implode(", ",$what);
        } else {
            switch($what) {
                case "*":
                    $res.= " * ";
                    break;
                case "list":
                    $res .= implode(", ", $this->list_fields);
                    break;
                case "count":
                    $res .= " count(*) as cnt ";
                    break;
                default:
                    $res .= $what;
            }
        }
        return $res;
    }



    function buildFrom() {
        return " FROM ".$this->table_name;
    }



    function buildWhere($where) {
        if(is_array($where)) {
            foreach($where as $k => $v) {
                if(is_array($v)) {
                    $w[] = $k." IN (".implode(", ",$v).")";
                } else {
                    $w[] = $k." = %".$k."%";
                }
            }
            return " WHERE ".implode(" AND ", $w);
        } elseif($where) {
            return " WHERE ".$where;
        } else {
            return "";
        }
    }



    function buildTail($start = null, $order = null) {
        $sql = "";
        if(!empty($order)) {
            $sql .= " ORDER BY ".$order;
        }

        if(!is_null($start)) {

            $start = (int) $start;
            if(!is_numeric($start) || $start<0) {
                $start = 0;
            }
            $sql .= " LIMIT ".$start.", "._ITEMS_PER_PAGE;
        }
        
        return $sql;
    }

}
?>