<?
class flash_category extends db_object {


var $table_name = "flash_categories";


    //   id,      . 
    function constructor($id = null) {
        parent::constructor($id);
        if($this->isEmpty()) {
            $this->row["level"] = 0;
            $this->row["left_key"] = 0;
            $this->row["right_key"] = 999999; // ;)
            $this->row["name"] = "";
        }
    }

    //      
    function getTree() {
        return $this->db->get_list("SELECT 
                                        * 
                                    FROM ".$this->table_name." 
                                    ORDER BY 
                                        left_key");
    }



    //    
    function getSubCategories() {
        return $this->db->get_list("SELECT 
                                        * 
                                    FROM ".$this->table_name." 
                                    WHERE
                                        left_key >= %left_key% AND
                                        right_key < %right_key% AND
                                        level = %level% + 1
                                    ORDER BY
                                        left_key",
                                   $this->row);
    }



    //       ..  
    function getAllSubCategories() {
        return $this->db->get_list("SELECT 
                                        * 
                                    FROM ".$this->table_name." 
                                    WHERE
                                        left_key > %left_key% AND
                                        right_key < %right_key%
                                    ORDER BY
                                        left_key",
                                   $this->row);
    }



    //    ,      
    function getPath() {
        return $this->db->get_list("SELECT 
                                        * 
                                    FROM ".$this->table_name." 
                                    WHERE
                                        left_key < %left_key% AND
                                        right_key > %right_key%
                                    ORDER BY
                                        left_key",
                                   $this->row);
    }




    //    
    function createSubCategory($name) {
        $category = func_new("flash_category");
        if($this->row["level"] == 0) {
            $category->row["right_key"] = $this->db->get_one("SELECT
                                                                  MAX(right_key)
                                                              FROM ".$this->table_name);
            if(empty($category->row["right_key"])) {
                $category->row["right_key"] = 0;
            }
            $category->row["right_key"]++;
        } else {
            $category->row["left_key"] = $this->row["left_key"];
            $category->row["right_key"] = $this->row["right_key"];
            $category->row["level"] = $this->row["level"];

        }

        $this->db->query("UPDATE ".$this->table_name."
                          SET 
                              right_key = right_key + 2, 
                              left_key = IF(left_key > %right_key%, left_key + 2, left_key) 
                          WHERE 
                              right_key >= %right_key%",
                         $category->row);

        $category->row["left_key"] = $category->row["right_key"];
        $category->row["right_key"]++;
        $category->row["level"]++;
        $category->row["name"] = $name;
        $category->create();
        return $category;
    }



    function delete() {
        $this->db->query("DELETE FROM ".$this->table_name."
                          WHERE 
                              left_key >= %left_key% AND 
                              right_key <= %right_key% ",
                         $this->row);
                          
        $this->db->query("UPDATE ".$this->table_name."
                          SET 
                              left_key = IF(left_key > %left_key%, 
                                            left_key - (%right_key% - %left_key% + 1), 
                                            left_key), 
                              right_key = right_key - (%right_key% - %left_key% + 1) 
                          WHERE right_key > %right_key% ",
                         $this->row);
    }

}
?>