function Desktop() {

    this.init();

    this.cfg = {
        hasSizeBtn: false,
        hasCloseBtn: false,
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        hasDrag: false,
        hasOnCloseConfirm: false,
        isSystem: true,
        title: "",
        module: "desktop",
        uniqueId: SYS_WIDGETS_ID + 1,
        saveMethod: "POST"
    }


    this.defaultProfile["title"] = "";
    this.defaultProfile["theme"] = "default";
    
    this.defaultProfile["tabs"] = []; // [ {t: title, c: columner_id, i }, ...]
    this.defaultProfile["order"] = []; // array of tab indexes


    this.domModel = [
        { tag: "div", display: false, id: "tmp" },

        { tag: "div", id: "content", display: false,
          childs: [

            { tag: "div", className: "destop_header",
              childs: [
                { tag: "div", id: "top_line", className: "desktop_title",
                  childs:[
                    { tag: "span", id: "title_box", className: "desktop_title_box"},
                    { tag: "input", id: "title_input", className: "desktop_title_input", display: false}
                  ]},
                { tag: "div", className: "section", style: {height: "1px", overflow: "hidden"},
                  childs:[
                    { tag: "span", id: "title_box_tmp", className: "desktop_title_box"}
                  ]},

                { tag: "div", className: "float_panel", id: "tray", 
                  childs: [
                    { tag: "div", className: "float_left",
                      childs: [
                        createButtonDom(loc.text("menu_title"), "switchMenu()", "widgets/menu/ico.gif")
                      ]},
                    { tag: "div", className: "float_right",
                      childs: [
                        createButtonDom(loc.text("desktop_show_all"), "showAll()"), 
                        { tag: "span", innerHTML: "&nbsp;&nbsp;|&nbsp;&nbsp;" },
                        createButtonDom(loc.text("desktop_hide_all"), "hideAll()"),
                        { tag: "span", innerHTML: "&nbsp;&nbsp;|&nbsp;&nbsp;" },
                        createButtonDom(loc.text("desktop_lnk_settings"), "showPage(\"settings\")", "static/client/settings.gif"), 
                        { tag: "span", innerHTML: "&nbsp;&nbsp;|&nbsp;&nbsp;" },
                        { tag: "span", id: "authButton" }
                      ]}
                  ]}
              ]},

             { tag: "div", id: "pager",
               childs: [
                 { tag: "div", id: "page_panels" }
               ]},

             { tag: "div", id: "pages", style: { width: "auto", margin: "0 14% 0 16%" } },

             { tag: "div", align: "center", 
               style: { marginTop: "22px"},
               childs: [
                 { tag: "span", className: "footer", align: "center", innerHTML: desktopLangsHTML},
                 { tag: "br"},{ tag: "br"},
                 { tag: "span", id: "bottom_links_0", align: "center",
                   childs: [
                    { tag: "span", html: "<a target=_blank href=http://www.yagbu.net/>YAGBU</a>" },
                     { tag: "span", html: "&nbsp;&nbsp;|&nbsp;&nbsp;" },
					                      { tag: "a", href: "showPage('feedback')",
                       html: loc.text('desktop_lnk_user_feedback') },
                     { tag: "span", html: "&nbsp;&nbsp;|&nbsp;&nbsp;" },
                     { tag: "a", href: "showPage('sendtofriend')",
                       html: loc.text('desktop_lnk_sendtofriend') },
                     { tag: "span", html: "&nbsp;&nbsp;|&nbsp;&nbsp;",
                       display: (mozilla_nav || ie_nav)
                        },
                     { tag: "a", href: "addToFavorites('feedback')",
                       display: (mozilla_nav || ie_nav) ,
                       html: loc.text('desktop_lnk_favorites') }
                   ]},
                 { tag: "span", id: "custom_pages_links", align: "center" },
                 { tag: "span", innerHTML: "&nbsp;<br>"}
               ]}

        ]},


        { tag: "div", id: "area", className: "area", name: "area", display: false},
        { tag: "div", id: "tab_area", className: "tab_area", name: "area", display: false},
    ]


    this.newFeedUrl = null;


    this.onOpen = function() {
        this.buildDomModel(document.body, { tag: "link", id: "themes_loader", rel: "stylesheet", media: "screen"});
        this.applyTheme();

        this.buildDomModel(this.elements["page_panels"],
            createPanelDom("tab", loc.text("desktop_tab_options"), [
              [ { tag: "span", innerHTML: "Title: "},
                { tag: "input", type: "text", id: "input_tab_title" },
                { tag: "input", type: "button", value: loc.text("btn_set"),
                  events: { onclick: "renameTab()" }} ],

              [ { tag: "div", innerHTML: loc.text("desktop_select_tab_icon")},
                { tag: "div", id: "tab_icons_box" },
                { tag: "div", 
                  childs: [
                    { tag: "a", href: "void",
                      innerHTML: loc.text("desktop_delete_tab_icon"),
                      events: { onclick: "deleteTabIcon()"}}
                  ]}],

              [ { tag: "span", innerHTML: loc.text("desktop_panels_count") },
                { tag: "input", type: "button", value: " 1 ",
                  events: { onclick: "setPanelsCount(1)" }},
                { tag: "input", type: "button", value: " 2 ",
                  events: { onclick: "setPanelsCount(2)" }},
                { tag: "input", type: "button", value: " 3 ",
                  events: { onclick: "setPanelsCount(3)" }},
                { tag: "input", type: "button", value: " 4 ",
                  events: { onclick: "setPanelsCount(4)" }} ]

            ]))

        this.elements["panel_tab"].style.position = "absolute";
        this.elements["panel_tab"].style.width = "250px";

        if (customPagesHTML != '') {
            this.elements["custom_pages_links"].innerHTML += "&nbsp;|&nbsp;"+customPagesHTML;
        }
    }




    ////////////////////////////
    // Main menu


    this.isMenuShow = false;

    this.switchMenu = function() {
        if(this.isMenuShow) {
            menu.hide();
        } else {
            menu.show();
        } 
    }


    // Pages
    this.activePage = "panels";

    this.addPage = function(name) {
//        this.buildDomModel(document.body,
        this.buildDomModel(this.elements["pages"],
            { tag: "div", id: "page_" + name, display: false });
        return this.elements["page_" + name];
    }

    this.showPage = function(name) {
        this.hideElement("page_" + this.activePage);
        this.showElement("page_" + name);
        this.activePage = name;
    }

    this.closeCurrentPage = function() {
        this.hideElement("page_" + this.activePage);
        this.showElement("page_panels"); 
        this.activePage = "panels";
    }



    ///////////////////////////
    // System
    this.buildWindow = function(parent) {
        this.buildDomModel(parent, this.domModel);
    }


    this.buildInterface = function() {
        //title
        if(this.profile["title"] == "") {
            this.profile["title"] = loc.text("desktop_title_prompt");
        }

        with(this.elements) {
            var t = this.profile["title"].jsUnescape();
            if(t == "") {
                t = this.defaultProfile.title;
            }
            document.title = t;
            title_box.innerHTML = text2html(t);

            title_box.onclick = function() { desktop.editTitle(); };
            title_box_tmp.innerHTML = text2html(t);
            title_input.value = t;
        }


        this.buildDomModel(this.elements["page_panels"],
            { tag: "div", className: "tab_panel",
              id: "tabs",
              childs: [
                { tag: "div", id: "add_page_button",
                  className: "tab_box",
                  events: {onclick: "addNewTab()"}, 
                  childs: [
                    { tag: "div", className: "tab_left" },
                    { tag: "div", className: "tab_middle",
                      childs: [
                        { tag: "div", className: "tab_add_icon" }
                      ]},
                    { tag: "div", className: "tab_right" }
                  ]}
              ]});
        this.showPage('panels');
    }






    // TITLE EDITING

    this.editTitle = function() {
        with(this.elements) {
            var w = title_box_tmp.offsetWidth;
            title_box.style.display = 'none';
            title_input.style.display = 'inline';
            title_input.style.width = (w+4)+"px";
            title_input.focus();
            title_input.select();

            title_input.onkeyup = function(e) {
                e = fix_event(e);
                if(e.keyCode == 13) {
                    this.onblur();
                } else {
                    document.title = this.value;
                    desktop.elements.title_box_tmp.innerHTML = this.value;
                    this.style.width = (desktop.elements.title_box_tmp.offsetWidth+4) + "px";
                }
     		}

            title_input.onblur = function() {
                text = trim(this.value.replace(/\\/g, ""));
                if(text == "") {
                    text = desktop.defaultProfile["title"];
                }
                this.onblur = null;
                this.style.display = 'none';
                with(desktop.elements) {
                    title_box.innerHTML = text2html(text);
                    title_box.style.display = 'inline';
                    title_box.onclick =  function() { desktop.editTitle(); };
                }
				
				document.title = text;
//                var t = escape(text);
                if(text != desktop.profile["title"]) {
                    desktop.profile["title"] = text.jsEscape();
                    desktop.save();
                }
    		}
        }
    }



  

    // TABS
    this.columners = [];

    this.tabOptionsShown = false;



    this.getNewTabNumber = function() {
        return this.profile["order"].length + 1;
    }


    this.addNewTab = function() {
        var title = loc.text("desktop_tab_title") + this.getNewTabNumber();
        var idx = arrayFirstFree(this.profile.tabs);

        this.columners[idx] = kernel.runWidget("Columner", document.body);
        this.columners[idx].profile["pcount"] = this.defaultPanelsCount;
        this.columners[idx].save();


        this.profile.tabs[idx] = {
            t: title,
            i: "",
            cid: this.columners[idx].id
        }
        this.profile["order"][idx] = idx;
        this.save();

        this.buildDomModel(this.elements["page_panels"],
            this.getPanelsDom(idx, this.defaultPanelsCount));

        this.renderTab(idx, title);
        this.showTab(idx);

//        this.showDebug();
    }

 


    this.getTabIconSrc = function(icon) {
        return "static/tab_icons/" + icon + ".gif";
    }


    this.renderTab = function(n, title, icon) {
        var icon_src = icon ? this.getTabIconSrc(icon) : "";

        this.buildDomModel(this.elements.tmp, 
            { tag: "div", id: "tab_"+n, 
              className: "tab_box",
                  entityInfo: { type: "tab", idx: n},
              events: {onclick: "showTab('"+n+"')"}, 
              childs: [
                { tag: "div", className: "tab_left" },
                { tag: "div", className: "tab_middle",
                  childs: [
                    { tag: "div", className: "tab_icon",
                      childs: [
                        { tag: "img", id: "tab_icon_" + n, 
                          src: icon_src, 
                          display: (icon_src != "") }
                      ]},

                    { tag: "div", className: "tab_title",
                      id: "tab_title_" + n,
                      innerHTML: title },
                    { tag: "div", className: "tab_controls",
                      childs: [
                        { tag: "div", className: "tab_close_btn",
                          events: { onclick: "closeTab('" + n + "')" }},
                        { tag: "div", className: "tab_options_btn",
                          events: { onclick: "showTabOptions('" + n + "')" }}
                      ]}
                  ]},
                { tag: "div", className: "tab_right" }
              ]});

        this.elements["tabs"].insertBefore(this.elements["tab_"+n], this.elements["add_page_button"]);
        var eh = new EntityHandler(this.elements["tab_"+n], "tabs_drag", 
                                   { onDragStart: desktop.onTabDragStart, 
                                     onElementOver: desktop.onTabDragOver,
                                     onDragStop: desktop.onTabDragStop});
    }




    // Drag&drop tabs
    this.belongTabInfo = null;

    this.onTabDragStart = function(info) {
    }

    this.onTabDragOver = function(info) {
        if(info.type == "tab") {
            desktop.belongTabInfo = info;
            desktop.showElement("tab_area");
            //dimk
            desktop.elements["tab_" + info.idx].parentNode.insertBefore(desktop.elements["tab_area"], desktop.elements["tab_" + info.idx]);
        }
    }

    this.onTabDragStop = function(info) {
        if((desktop.belongTabInfo != null) && 
           (desktop.belongTabInfo.type == "tab") && 
           (desktop.belongTabInfo.idx != info.idx)) {

            desktop.elements["tab_" + info.idx].parentNode.insertBefore(
                desktop.elements["tab_" + info.idx],
                desktop.elements["tab_area"]);

            for(var i=0; i< desktop.profile["order"].length; i++) {
                if(desktop.profile["order"][i] == desktop.belongTabInfo.idx) {
                    var belongIdx = i;
                }

                if(desktop.profile["order"][i] == info.idx) {
                    var dragIdx = i;
                }
            }


            desktop.profile["order"].splice(
                belongIdx - (belongIdx > dragIdx ? 1 : 0), 
                0, 
                desktop.profile["order"].splice(dragIdx, 1)[0]);

            desktop.save();
        }
        this.belongTabInfo = null;
        desktop.hideElement("tab_area");
    }




    // show/hide tabs 
    this.activeTab = null;


    this.hideTab = function(idx) {
        this.hideTabOptions();
        this.elements["tab_" + idx].className = "tab_box";
    }


    this.showTab = function(idx) {
        if(this.activeTab != null && this.activeTab != idx) {
            this.hideTab(this.activeTab);
            this.hideElement("tab_container_" + this.activeTab);
        }
        this.activeTab = idx;
        this.elements["tab_" + idx].className = "tab_box_selected";        
        this.showElement("tab_container_" + idx);
    }



    // tab options


    this.showTabOptions = function(idx) {
        this.elements["input_tab_title"].value = this.profile.tabs[idx].t;
        var pos = getElPos(this.elements["tab_" + idx]);
        this.showElement("panel_tab");
        this.elements["panel_tab"].style.left = Math.min(pos.left, (document.body.clientWidth - 255)) + "px";
        this.elements["panel_tab"].style.top = (pos.top + this.elements["tab_" + idx].offsetHeight + 4) + "px";
        this.elements["panel_tab"].style.zIndex = 1000000;

        if(!this.tabOptionsShown) {
            this.tabOptionsShown = true;
            for(var i=0; i< this.tabIcons.length; i++) {
                this.buildDomModel(this.elements["tab_icons_box"],
                   { tag: "a", href: "void",
                     events: { onclick: "setTabIcon('" + this.tabIcons[i] + "')"},
                     innerHTML: "<img src='" + this.getTabIconSrc(this.tabIcons[i]) + "' style='margin: 1px;'>"});
            }
        }
    }


    this.hideTabOptions = function() {
        this.hideElement("panel_tab");
    }



    // tab managment

    this.renameTab = function() {
        var t = trim(this.elements["input_tab_title"].value);
        this.profile.tabs[this.activeTab].t = t;
        this.elements["tab_title_" + this.activeTab].innerHTML = t;

//        this.showDebug();
        this.save(); 
    }

    this.setTabIcon = function(icon) {
        this.showElement("tab_icon_" + this.activeTab);
        this.elements["tab_icon_" + this.activeTab].src = this.getTabIconSrc(icon);
        this.profile.tabs[this.activeTab].i = icon;

//        this.showDebug();
        this.save(); 
    }


    this.deleteTabIcon = function() {
        this.hideElement("tab_icon_" + this.activeTab);
        this.profile.tabs[this.activeTab].i = "";

//        this.showDebug();
        this.save(); 
    }




    this.closeTab = function() {
        if(confirm(loc.text("desktop_close_page_prompt"))) {
            this.hideTabOptions();

            var widgets = this.columners[this.activeTab].profile["widgets"];
            for(var i in widgets) {
                var w = kernel.getWidget(widgets[i].id);
                if(w) {
                    w.forceClose();
                }
            }
            this.columners[this.activeTab].close();
            deleteEl(this.elements["tab_" + this.activeTab]);
            deleteEl(this.elements["tab_container_" + this.activeTab]);
            delete this.profile["tabs"][this.activeTab];


            for(var o in this.profile["order"]) {
                if(this.profile["order"][o] > this.activeTab) {
                    this.profile["order"][o] --;
                }
            }

            for(var o in this.profile["order"]) {
                if(this.profile["order"][o] == this.activeTab) {
                    this.profile["order"].splice(o, 1);
                    break;
                }
            }

//            this.showDebug();            
            this.save(); 

            this.activeTab = null;
            for(var i=0; i<this.profile.tabs.length; i++) {
                if(this.profile.tabs[i] != undefined) {
                    this.activeTab = i;
                    continue;
                }
            }
            
            if(this.activeTab != null) {
                this.showTab(this.activeTab);
            }
        }
    }



    /* PANELS */
    this.defaultPanelsCount = 3;

//dimk
    this.setPanelsCount = function(n) {
        if(n == this.columners[this.activeTab].profile["pcount"]) {
            return;
        }

        for(var p=0; p<this.getPanelsCount(); p++) {
            var panel = this.getPanel(p);
            for(; panel.childNodes.length>0; ) {
                var wid = panel.childNodes[0].wid;
                this.elements["tmp"].appendChild(kernel.getWidget(wid).elements.window);
            }
        }

        for(var i=0; i<this.getPanelsCount(); i++) {
            deleteEl(this.elements["panel_" + this.activeTab + "_" + i]);
        }
        deleteEl(this.elements["tab_container_" + this.activeTab]);

        this.buildDomModel(this.elements["page_panels"], this.getPanelsDom(this.activeTab, n));

        this.columners[this.activeTab].profile["pcount"] = n;
        this.columners[this.activeTab].save();

        for(;this.elements["tmp"].childNodes.length > 0;) {
            this.getTinyPanel().appendChild(this.elements["tmp"].childNodes[0]);
        }
        this.savePanels();
    }




    this.getPanelsDom = function(tab_idx, count) {
        var p = [];
        var pwidth = Math.round(100 / count) + "%";

        for(var i=0; i<count; i++) {
            p.push(
                { tag: "td", 
                  width: pwidth, 
                  style: { paddingBottom: "50px", width: pwidth, verticalAlign: "top"},
                  id: "panel_" + tab_idx + "_" + i });
        }

        var m =         
            { tag: "div", id: "tab_container_" + tab_idx,
              childs: [
                { tag: "table", 
                  className: "panels_table",
                  width: "100%",
                  childs: [
                    { tag: "tr", childs: p }
                  ]}
              ]}

        return m;
    }




    // Panels managment
    this.getPanel = function(n) {
        if(n > this.getPanelsCount()-1) {
            n = this.getPanelsCount()-1;
        }
        return this.elements["panel_" + this.activeTab + "_" + n];
    }

    this.getPanelsCount = function() {
        return this.columners[this.activeTab] ? this.columners[this.activeTab].profile["pcount"] : -1;
    }


    this.getTinyPanel = function() {
        if(this.activeTab == null) {
            this.addNewTab();
        }

        var p = 0;
        var minh = 100000;
        for(var i = this.getPanelsCount()-1; i>=0; i--) {
            var h = 0;
            panel = this.getPanel(i);
            for(var j=0; j<panel.childNodes.length; j++) {
                h += panel.childNodes[j].offsetHeight;
            }

            if(h <= minh) {
                minh = h;
                p = i;
            }
        }
        return this.getPanel(p);
    }


    ////////////////////////////////
    // Drag and drop
    this.getBelongPanel = function(pos) {
        for(var i=0; i<this.getPanelsCount(); i++) {
            if(isPosInObj(pos, this.getPanel(i))) {
                return this.getPanel(i);
            }
        }
        return null;
    }


    this.getWindowAtPos = function(panel, pos) {
        for(var i=0; i<panel.childNodes.length; i++) {
            if(isPosInObj(pos, panel.childNodes[i])) {
                return panel.childNodes[i];
            }
        }
        return null;
    }


    this.startArea = function(el) {
        with(this.elements) {
            area.style.position = 'relative';
            el.parentNode.insertBefore(area, el);
            area.style.height = el.offsetHeight + "px";
            area.style.display = 'block';
        }
    }


    this.stopArea = function() {
        with(this.elements) {
            area.style.height = 0;
            area.style.display = 'none';
            area.parentNode.removeChild(area);
        }
    }


    this.processArea = function(pos) {
        p = this.getBelongPanel(pos);
        if(p) { 
            if(p.hasChildNodes()) {
                w = this.getWindowAtPos(p, pos);
                if(w) {
                    if(w.name != 'area') {
                        w = this.getWindowAtPos(p, pos);
                        p.insertBefore(this.elements.area, w);
                    }
                } else {
                    this.elements.area.parentNode.removeChild(this.elements.area);
                    p.appendChild(this.elements.area);
                }
            } else {
                this.elements.area.parentNode.removeChild(this.elements.area);
                p.appendChild(this.elements.area);
            }
        }
    }


    this.putWindow = function(pos) {
        if(this.activeTab == null) {
            this.addNewTab();
        }
        panel = this.getBelongPanel(mpos);        

        if(panel) {
            drag.el.parentNode.removeChild(drag.el); 
            panel.insertBefore(drag.el, this.elements.area);
        }
    }



    this.showAll = function() {
        for(var p=0; p<this.getPanelsCount(); p++) {
            for(var i=0; i<this.getPanel(p).childNodes.length; i++) {
                var wid = this.getPanel(p).childNodes[i].wid;
                if(wid) {
                    kernel.getWidget(wid).show();
                }
            }
        }
    }



    this.hideAll = function() {
        for(var p=0; p<this.getPanelsCount(); p++) {
            for(var i=0; i<this.getPanel(p).childNodes.length; i++) {
                var wid = this.getPanel(p).childNodes[i].wid;
                if(wid) {
                    kernel.getWidget(wid).hide();
                }
            }
        }
    }









    // SAVE/LOAD DESKTOP
    this.savePanels = function() {
        var n = 0;
        var panelsCount = this.getPanelsCount();

        if(this.columners[this.activeTab]) {
            this.columners[this.activeTab].profile["widgets"] = [];

            for(var p=0; p<panelsCount; p++) {
                for(var i=0; i<this.getPanel(p).childNodes.length; i++) {
                    var wid = this.getPanel(p).childNodes[i].wid;
                    if(wid) {
                        this.columners[this.activeTab].profile["widgets"].push(
                            { m: kernel.getWidget(wid).cfg.module, 
                              id:wid, 
                              p: p});
                    }
                }
            }
            this.columners[this.activeTab].save();
        }
    }

 
 

    this.wakeUp = function() {
        for(var o in this.profile["order"]) {
            var i = this.profile["order"][o];
            if(this.profile.tabs[i] == undefined) {
                continue;
            }
            this.renderTab(i, this.profile.tabs[i].t, this.profile.tabs[i].i);

            this.columners[i] = kernel.runWidget("Columner", document.body, this.profile.tabs[i].cid);

            this.buildDomModel(this.elements["page_panels"],
                this.getPanelsDom(i, this.columners[i].profile["pcount"]));
            this.showTab(i);

            var widgets = this.columners[i].profile["widgets"];
            for(var j in widgets) {
                kernel.runWidget(widgets[j].m,
                                 this.getPanel(widgets[j].p),
                                 widgets[j].id);
            }
        }

        for(var o in this.profile["order"]) {
            var i = this.profile["order"][o];
            if(this.profile.tabs[i] != undefined) {
                this.showTab(i);
                break;
            }
        }

        if(_GET["add_url"]) {
            url = _GET["add_url"];
            if(url.indexOf("http://") == -1) {
                url = "http://"+url;
            }

            if(_GET["type"] == "api")  {
                var w = kernel.runWidget("Browser", this.getTinyPanel(), false, {home_page: url});
                w.save();

                this.savePanels();
            } else {
                this.newFeedUrl = url;
                xmlRequest.send(url, this, "addFeedDispatch");
            }
        }

        this.showElement("content");
        hideEl(elById("loading_note"));
        showEl(elById("page_header"));
        showEl(elById("page_footer"));
    }





    this.addFeedDispatch = function(response) {
        if(response.responseXML.documentElement) {
            var channel = XMLParser.xml2hash(response.responseXML.documentElement);
            if(channel) {
                menu.registerFeed(channel.title, this.newFeedUrl);
                var w = kernel.runWidget("Rss", this.getTinyPanel(), false, {url: this.newFeedUrl});
                w.save();
                this.savePanels();
                return;
            }
        }
    }




    this.showDebug = function() {
        elById("DEBUG").innerHTML = "<pre>" + Dump(this.profile.tabs) + "</pre>";
    }





    /* THEMES */
    this.applyTheme = function() {
        this.elements["themes_loader"].href = "themes/" + this.profile["theme"] + "/theme.css?v=" + (Math.random() * 1000000);
    }


    this.addToFavorites = function() {
        var url = "http://" + baseUrl;
        if(mozilla_nav) {  
            window.sidebar.addPanel(this.profile["title"], url, "");
        } else if(ie_nav) {  
            window.external.AddFavorite(url, this.profile["title"]);  
        }
    }


}
Desktop.prototype = new Widget();




/* columner */

function Columner() {

    this.init();

    this.cfg = {
        hasSizeBtn: false,
        hasCloseBtn: false,
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        hasDrag: false,
        hasOnCloseConfirm: false,
        isSystem: true,
        title: "",
        module: "columner"
    }


    this.defaultProfile["widgets"] = [];
    this.defaultProfile["pcount"] = 3;
    this.defaultProfile["config"] = "";


    this.buildWindow = function(parent) {}
    this.buildInterface = function() {}

}
Columner.prototype = new Widget();








Desktop.prototype.tabIcons = [
"anchor",
"attach",
"basket",
"bomb",
"book",
"book_addresses",
"book_open",
"brick",
"briefcase",
"bug",
"cake",
"calendar_view_day",
"calendar_view_month",
"camera",
"car",
"cd",
"chart_bar",
"chart_curve",
"chart_organisation",
"chart_pie",
"clock",
"clock_red",
"cog",
"coins",
"color_swatch",
"comment",
"computer",
"connect",
"creditcards",
"door",
"door_open",
"drink",
"drink_empty",
"email",
"email_open",
"email_open_image",
"emoticon_evilgrin",
"emoticon_grin",
"emoticon_happy",
"emoticon_smile",
"emoticon_surprised",
"emoticon_tongue",
"emoticon_unhappy",
"emoticon_waii",
"emoticon_wink",
"exclamation",
"eye",
"feed",
"flag_blue",
"flag_green",
"flag_orange",
"flag_pink",
"flag_purple",
"flag_red",
"flag_yellow",
"folder",
"heart",
"hideMod",
"house",
"image",
"info",
"information",
"ipod",
"keyboard",
"layout",
"lightbulb",
"lightbulb_off",
"lock",
"lock_open",
"lorry",
"lorry_flatbed",
"magnifier",
"money",
"money_dollar",
"money_euro",
"money_pound",
"money_yen",
"monitor",
"mouse",
"music",
"new",
"note",
"note_002",
"page",
"page_copy",
"page_white",
"page_white_acrobat",
"page_white_code",
"page_white_compressed",
"page_white_excel",
"page_white_flash",
"page_white_php",
"page_white_picture",
"page_white_powerpoint",
"page_white_text",
"page_white_word",
"page_white_world",
"palette",
"paste_plain",
"pencil",
"phone",
"photo",
"picture",
"printer",
"printer_empty",
"rainbow",
"rosette",
"server",
"shield",
"sport_8ball",
"sport_basketball",
"sport_football",
"sport_golf",
"sport_raquet",
"sport_shuttlecock",
"sport_soccer",
"sport_tennis",
"star",
"stop",
"tag_blue",
"tag_green",
"tag_orange",
"tag_pink",
"tag_purple",
"tag_red",
"tag_yellow",
"telephone",
"television",
"thumb_down",
"thumb_up",
"trash",
"tux",
"user",
"user_female",
"user_gray",
"user_green",
"user_orange",
"user_red",
"user_suit",
"vcard",
"weather_clouds",
"weather_cloudy",
"weather_lightning",
"weather_rain",
"weather_snow",
"weather_sun",
"world",
"zoom"
]