DRAG_NONE = 0;
DRAG_MOVE = 1;
DRAG_ANIM = 1;

Drag = function(win, caption) {

    var div = win;
    var action = DRAG_NONE;
    var dragging = false;
    var targetPos = {left: 0, top: 0};
    var animSteps = 5;
    var animFrame = 0;
    
    var offset = {left: 0, top: 0};
    var tid = null;


    function calcOffset(event) {
        event = fix_event(event);

        var pos = getElPos(div);
        offset.left = event.clientX - pos.left;
        offset.top = event.clientY - pos.top;
    }

    function drag(event) {
        event = fix_event(event);
    	
        if(action == DRAG_MOVE) {
            var l = event.clientX - offset.left;
            var h = event.clientY - offset.top;

            div.style.left = l + "px";
            div.style.top = h + "px";

            desktop.processArea({left: l + Math.ceil(div.offsetWidth / 2), 
                                 top: h + 16});
        }
    }


    function processAnimation() {
        var f = function() {
            clearTimeout(tid);
            animFrame ++;

            if(animFrame < animSteps) {
                var dPos = { 
                    left: div.offsetLeft, 
                    top: div.offsetTop 
                }

                var newPos = {
                    left: Math.floor(dPos.left + (targetPos.left - dPos.left) / animSteps),
                    top: Math.floor(dPos.top + (targetPos.top - dPos.top) / animSteps)
                }

                div.style.left = newPos.left + "px";
                div.style.top = newPos.top + "px";
                tid = setTimeout(f, 50); 
            } else {
                placeWindow();
            }
        }
        tid = setTimeout(f, 50); 
    }


    function stopDrag(event) {
        event = fix_event(event);

        document.onmousemove = null;
        document.onmouseup = null;
        document.ondrag = null;
        document.body.onselectstart = null;
        document.onselectstart = null;

        targetPos = getElPos(desktop.elements.area);
        targetPos.top -= 14;
        animFrame = 0;

        action = DRAG_ANIM;
        processAnimation();
    }


    function placeWindow() {
        clearTimeout(tid);
        
        div.style.position = 'static';
        desktop.elements.area.parentNode.insertBefore(div, desktop.elements.area);

        div.style.width = 'auto';
        desktop.stopArea();
        desktop.savePanels();
        action = DRAG_NONE;
    }



    function startDrag(event) {
        event = fix_event(event);
        if(action != DRAG_NONE) {
            return false;
        }

        document.ondrag = function () { return false; }
        document.body.ondrag = function () { return false; }
        document.onselectstart = function () { return false; }
        document.body.onselectstart = function () { return false; }   
        
        action = DRAG_MOVE;

        calcOffset(event);
        
        document.onmousemove = function(event) { drag(event) }
        document.onmouseup = function(event) { stopDrag(event) }

        putEl(div);
    }


    function putEl(el) {
        var left = getLeft(el);
        var top = getTop(el);
        var width = el.offsetWidth;

        desktop.startArea(el);

        el.parentNode.removeChild(el); 
        document.body.appendChild(el);

        el.style.position = 'absolute';
        el.style.left = left + "px";
        el.style.top = top + "px";
        el.style.width = width + "px";
    } 


    caption.onmousedown = function(event) { 
        event = fix_event(event);
        if(action == DRAG_MOVE) {
            stopDrag(event);
        } else {
            var e = event.target;
            
            while(e.onclick == null && e != this) {
                e = e.parentNode;
            }
            if(e == this) startDrag(event); 
        }
    }

    function fix_event(event) {
        if (!event) {
            event = window.event;
        }
        if (event.target) {
    	    if (event.target.nodeType == 3) event.target = event.target.parentNode
        } else if (event.srcElement) {
    	    event.target = event.srcElement
        }
        return event
    }

}







// events: onstart, onover, onstop
// mode: drag, menu, all
EntityHandler = function(el, mode, events) {
    var div = el;
    var divClone = null;
    var dragging = false;

    var offset = {left: 0, top: 0};
    var startPos = {left: 0, top: 0};
    var events = events ? events : {};
    var belongElement = null;

    function waitForDrag(event) {
        event = fix_event(event);
        if( (Math.abs(event.clientX - startPos.left) > 4) || (Math.abs(event.clientY - startPos.top) > 4)) {
//            desktop.isFileDrag = true;
            
            dragging = true;

            offset = {left: div.offsetWidth + 2,
                      top: div.offsetHeight + 2};

            document.onmousemove = function(e) { drag(e) }
            document.onmouseup = function(e) { stopDrag(e) }

            divClone = div.cloneNode(true);
            divClone.style.cssText = divClone.style.cssText + ";opacity: 0.75; -moz-opacity: 0.75; -khtml-opacity: 0.75; filter: alpha(opacity=75);";
            document.body.appendChild(divClone);
            divClone.style.position = 'absolute';
            divClone.style.width = div.offsetWidth + "px";
            divClone.style.height = div.offsetHeight + "px";

            if(events.onDragStart) {
                events.onDragStart(div.entityInfo);
            }
            if(event.target.entityInfo && events.onElementOver) {
                events.onElementOver(event.target.entityInfo);
            }
        }
    }


    function drag(event) {
        if(dragging) {
            event = fix_event(event);

            divClone.style.left = event.clientX + 2 + "px";
            divClone.style.top = event.clientY + 2 + "px";

            if(event.target.entityInfo && events.onElementOver) {
                events.onElementOver(event.target.entityInfo);
            }
 
        }
    }



    function startDrag(event) {
        event = fix_event(event);
        document.ondrag = function () { return false; }
        document.body.ondrag = function () { return false; }
        document.onselectstart = function () { return false; }
        document.body.onselectstart = function () { return false; }   
        
        document.onmousemove = function(e) { waitForDrag(event) }
        document.onmouseup = function(e) { stopDrag(event) }

        startPos = {left: event.clientX, top: event.clientY};
        return false;
    }


    function stopDrag(event) {
        event = fix_event(event);

        document.onmousemove = null;
        document.onmouseup = null;
        document.ondrag = null;
        document.body.onselectstart = null;
        document.onselectstart = null;

        desktop.isFileDrag = false;

        if(div.onmouseout) {
            div.onmouseout();
        }

        if(divClone) {
            deleteEl(divClone);
        }

        if(events.onDragStop && dragging) {
            events.onDragStop(div.entityInfo);
        }

        dragging = false;
    }

 


    switch(mode) {
        case "tabs_drag":
            div.onmousedown = function(event) { 
                desktop.hideTabOptions();
                event = fix_event(event);
                if(dragging) {
                    stopDrag(event);
                } else {
                    startDrag(event);
                }
                    if (event.stopPropagation) {
                        event.stopPropagation();
                        event.preventDefault();
                    } else if(window.event) {
                        window.event.cancelBubble = true;
                        window.event.returnValue = false;			
                    }
                return false;
            }
    }


}