function startPage() {
    request = new Request();
    xmlRequest = new XMLRequest();
    kernel = new Kernel();
    loc = new Loc();

    loc.onLoad = function() {
        auth = new Auth();
        auth.id = kernel.getUniqueId(auth);
        kernel.addWidget(auth);

        auth.onLoad = function() {
            profiler = new Profiler();
            profiler.id = kernel.getUniqueId(profiler);
            kernel.addWidget(profiler);

            profiler.onLoad = function() {
                desktop = kernel.runWidget("Desktop", elById("desktop_body"));

                auth.open(desktop.addPage("auth"));

                settings = kernel.runWidget("Settings", desktop.addPage("settings"));
                menu = kernel.runWidget("Menu", document.body);
                feedback = kernel.runWidget("Feedback", desktop.addPage("feedback"));
                custompage = kernel.runWidget("Custompage", desktop.addPage("custompage"));
                sendtofriend = kernel.runWidget("SendToFriend", desktop.addPage("sendtofriend"));
                rssreader = kernel.runWidget("RssReader", desktop.addPage("rssreader"));
                flashPlayer = kernel.runWidget("FlashPlayer", desktop.addPage("flashplayer"));

                desktop.wakeUp();
            }
            profiler.loadProfile();
        }
        auth.start();
    }
    loc.start();
}


SYS_WIDGETS_ID = 1;
USER_WIDGETS_ID = 100;


cfgWidget = {
    hasIcon: true,
    hasSizeBtn: true,
    hasCloseBtn: true,
    hasRefreshBtn: true,
    hasSettingsBtn: true,
    hasDrag: true,
    hasOnCloseConfirm: true,
    hasProfile: true,
    isOpenHidden: false,
    isSystem: false,
    title: "",
    module: "base",
    uniqueId: false,
    saveMethod: "GET"
}

function Kernel() {

    this.widgets = [];        

    this.getUniqueId = function(w) {
        if(w.cfg.uniqueId) {
            return w.cfg.uniqueId;
        } else {
            var newId = USER_WIDGETS_ID;
            while(this.widgets[newId]) newId++;
            return newId;
        }
    }


    this.getWidget = function(id) {
        return this.widgets[id];
    }

    this.addWidget = function(widget) {
        this.widgets[widget.id] = widget;
    }
    
    
    this.freeWidget = function(id) {
        this.widgets[id] = null;
    }


    this.runWidget = function(className, parent, id, profile, objvars) {
        var code = 'var w = new ' + className + '();';
        try {
            eval(code);
        } catch(e) { 
            // Debug info
            // alert("Can't run '" + className + "' widget.\n" + e.message); 
        }
        if(w) {
            profile = profile || false;

            w.id = id ? id : this.getUniqueId(w);

            if(typeof(objvars) == "object") {
                for(var i in objvars) {
                    w[i] = objvars[i];
                }
            }

            kernel.addWidget(w);
            for(var c in cfgWidget) {
                if(typeof(w.cfg[c]) == "undefined") {
                    w.cfg[c] = cfgWidget[c];
                }
            }

            if(w.cfg.hasProfile) {
                profiler.registerWidget(w);
                if(profile) {
                    for(var p in profile) {
                        w.profile[p] = profile[p];
                    }
                }
            }
            
            w.open(parent, false, profile);
            return w;
        }
    }


 
    this.timers = [];
    this.processTimer = function(widgetId, period, noAction) {
        if(kernel.widgets[widgetId]) {
            if(noAction != true) {
                kernel.getWidget(widgetId).timerHandler();
            }
            kernel.timers[widgetId] = setTimeout("kernel.processTimer("+widgetId+","+period+")", period);
        }
    }

    this.stopTimer = function(widgetId) {
        if(this.timers[widgetId] != undefined) {
            clearTimeout(this.timers[widgetId]);
            this.timers[widgetId] = undefined;
        }
    }

}




/*******************************************
 *
 *   Languages data
 *
 *******************************************/

function Loc() {


    this.data = {};


    this.start = function() {
        this.lang = getCookie("lng");
        if(this.lang == "") {
            this.lang = "EN";
        }
        request.getXML("lang/" + this.lang.toLowerCase() + ".xml", this, "parseLangXML");
    }


    this.swapLang = function(lang) {
        setCookie('lng', lang);
        window.location.reload(true);
    }

    this.parseLangXML = function(xml) {
        this.data = this.getHashList(xml, "string", "id");
        this.onLoad();
    }


    this.text = function(id, param) {
        var text = this.data[id] ? this.data[id] : "loc:" + id;

        if(param && text != '') {
            if(typeof(param) == "object") {
                for(var i in param) {    
                    var mask = new RegExp("%"+i+"%", "ig");
                    text = text.replace(mask, param[i]);
                }
                return text;
            } else {
                return text.replace(/(%\w*%)/ig, param);
            }
        }
        return text;
    }


    this.getHashList = function(node, tagName, key) {
        var hash = {};
        if(node) {
            var nodes = node.getElementsByTagName(tagName);
            for(var i=0; i<nodes.length; i++) {
                hash[nodes[i].getAttribute(key)] = nodes[i].firstChild ? nodes[i].firstChild.nodeValue : "";
            }
        }
        return hash;
    }


    this.onLoad = function() {}
}