requests_counter = 0;


function updateLoadingIcon(ofs) {
    requests_counter += ofs;
    if(requests_counter <= 0) {
        hideEl(elById("loading_spinner"));
    } else {
        showEl(elById("loading_spinner"));
    }
//    elById("dbg").innerHTML = requests_counter;
}



function Request() {

    this.controllerURL = "controller.php";

    this.convertParams = function(hash) {
        var res = [];
        for(k in hash) {
            res.push(k + "=" + encodeURIComponent(hash[k]));
        }
        return res.join("&");
    }


    this.getNoCache = function() {
        return ("" + Math.random()).slice(2, 8);
    }



    this.getTransportObj = function() {
        var req;	
        if (window.XMLHttpRequest) {
            try { req = new XMLHttpRequest() } catch(e) {}
        } else if (window.ActiveXObject) {
            try { req = new ActiveXObject("Microsoft.XMLHTTP") } catch(e) {}
            if (!req) {
                try { req = new ActiveXObject("Msxml2.XMLHTTP") } catch (e) {}
            }
        }
        return req;
    }


    this.send = function(params, widget, method) {
        var req = this.getTransportObj();

        if(!req) {
            return false;
        }

        var widgetId = widget.id;
        params.module = widget.cfg.module;

//        if(!mozilla_nav) {
            var date = new Date();
            params["_nc"] = this.getNoCache();
//        }

        req.onreadystatechange = function() {
            if (req.readyState == 4) {
                if ((req.status < 400) && req.responseText) {
                    updateLoadingIcon(-1);
                    try {
                        eval("if(kernel.getWidget(widgetId)) { kernel.getWidget(widgetId).dispatchMsg("+req.responseText+")}");
                    } catch(e) {
//                        alert("Error in \n"+e.fileName+"\nat line: "+e.lineNumber+"\n"+e.message);
                    }
        		} else {
//    				alert(req.statusText);
    			}
            }
        }

        if (method == "POST") {
            req.open("POST", this.controllerURL, false);
            req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8;');
            req.send(this.convertParams(params));
        } else {
            req.open("GET", this.controllerURL + "?" + this.convertParams(params), true);
            req.send(null);
        }
        
        updateLoadingIcon(1);
        return req;
    }




    this.getXML = function(url, obj, callback) {
        var req = this.getTransportObj();
        var o = obj
        var cb = callback;

        req.onreadystatechange = function() {
            if (req.readyState == 4) {
                if (req.status < 400) {
                    updateLoadingIcon(-1);
                    if(req.responseXML) {
                        o[cb](req.responseXML.documentElement);
                    }
        		} else {
                    o[cb](null);
    			}
            }
        }

          
        if(url.indexOf("http:") != -1) {
            req.open("GET", "xmlproxy.php?url=" + escape(url) + "&_nc=" + this.getNoCache(), true);
        } else {
            req.open("GET", url + "?_nc=" + this.getNoCache(), true);
        }
        updateLoadingIcon(1);
        req.send(null);
        return req;
    }


}








function XMLRequest() {

    this.send = function(url, widget, callback, params, noProxy) {
        var req;	
        if (window.XMLHttpRequest) {
            try { req = new XMLHttpRequest() } catch(e) {}
        } else if (window.ActiveXObject) {
            try { req = new ActiveXObject("MSXML2.XMLHttp") } catch (e) {}
            if (!req) {
                try { req = new ActiveXObject("Microsoft.XMLHTTP") } catch(e) {}
            }
        }

        if(!req) {
            return false;
        }

//        if(!mozilla_nav) {
            var date = new Date();
            noCache = '&_nc='+ request.getNoCache();
//        } else {
//            noCache = '';
//        }

        var paramStr = "";
        if(params) {
            for(var i in params) {
                paramStr += "&"+i+"="+escape(params[i]);
            }
        }

        var widgetId = widget.id;
        var cf = callback;
        req.onreadystatechange = function() {
            updateLoadingIcon(-1);
            if (req.readyState == 4) {
                if (req.status == 200) {
                    updateLoadingIcon(-1);
                    try {
                        if(kernel.getWidget(widgetId)) {
                            kernel.getWidget(widgetId)[cf](req);
                        }
                    } catch(e) {
//                        alert("Error in \n"+e.fileName+"\nat line: "+e.lineNumber+"\n"+e.message);
                    }
        		} else {
//    				alert(req.statusText);
    			}
            }
        }
        
        if(noProxy == true) {
            req.open("GET", url+"?"+noCache, true);
        } else {
            req.open("GET", "xmlproxy.php?url="+escape(url)+paramStr+noCache, true);
        }
        req.send(null);

        updateLoadingIcon(1);
        return req;
    }


}