opera_nav = (navigator.userAgent.indexOf('Opera') != -1) ? true : false;
ie_nav = (navigator.userAgent.indexOf('MSIE') != -1 && !opera_nav) ? true : false;
mozilla_nav = (navigator.userAgent.indexOf('Gecko') != -1) ? true : false;


function preloadImg(imgEl, src) {
    var img = document.createElement("img");
    img.setAttribute("src", src);
//    img.src = src;
    img.onload = function() {
        imgEl.setAttribute("src", img.src);
        imgEl.onload = null;
    };
    imgEl.style.display = 'inline';
}

function loadImg(src) {
    var img = new Image();
    img.src = src;
}


function deleteEl(el) {
    if(el && el.parentNode) {
        el.parentNode.removeChild(el);
    }
}

function clone(obj) {
    if((typeof(obj) != 'object') || (obj == null)) {
        return obj;
    }

    if(obj.length == undefined) {
        var newObj = {}
        for(var i in obj) {
            newObj[i] = clone(obj[i]);
        }
    } else {
        var newObj = []
        for(var i=0; i<obj.length; i++) {
            newObj[i] = clone(obj[i]);
        }
    }
    return newObj;
}

function swap(a, b) {
    var tmp = a;
    a = b;
    b = tmp;
}


 
function elById(id) {
    return document.getElementById(id);
}

function showEl(el) {
    el.style.display = 'block';
}

function hideEl(el) {
    el.style.display = 'none';
}

function clearEl(el) {
    el.innerHTML = '';
}

function info(txt) {
    document.getElementById("info").innerHTML = txt;
}



function px2int(px) {
    return parseInt(px.substring(0,px.length-2));
}

function getMousePos(e) {
    var px; 
    var py; 
    if (mozilla_nav) {
        px = e.pageX;
        py = e.pageY;
    } else {
        px = event.clientX + document.body.scrollLeft;
        py = event.clientY + document.body.scrollTop;
    }    
    return {left:px, top:py};
}


function isPosInObj(pos, obj) {

    var left = getLeft(obj);
    var top = getTop(obj);

    if((pos.left > left) &&
       (pos.left < obj.offsetWidth + left) &&
       (pos.top > top) &&
       (pos.top < obj.offsetHeight + top)) {
        return true;
        }    
       
    return false;
}


function getLeft(obj) {
    var curleft = 0;
    if (obj.offsetParent) {
        while (obj.offsetParent) {
            curleft += obj.offsetLeft;
            obj = obj.offsetParent;
        }
    } else if (obj.x) curleft += obj.x;
    return curleft;
}

function getTop(obj) {
    var curtop = 0;
    if (obj.offsetParent) {
        while (obj.offsetParent) {
            curtop += obj.offsetTop;
            obj = obj.offsetParent;
        }
    } else if (obj.y) curtop += obj.y;
    return curtop;
}


function getElPos(el) {
    var left = 0;
    var top = 0;
    if (el.offsetParent) {
        while (el.offsetParent) {
            left += el.offsetLeft;
            top += el.offsetTop;
            el = el.offsetParent;
        }
    } else 
        if (el.y) {
            left += el.x;
            top += el.y;
        }
    return {left:left, top:top};
}


function setElPos(el, pos) {
    el.style.left = pos.left + "px";
    el.style.top = pos.top + "px";
}







function trim(s) {
    if(s && s.replace) {
        return s.replace(/^\s*(.+?)\s*$/, "$1").replace(/'/g, "").replace(/"/g, "");
    } else {
        return "";
    }
}


function arraySearch(needle, data) {
    for(var i = 0; i<data.length; i++) {
        if(data[i] == needle) {
            return i;
        }
    }
    return undefined;
}

function arrayFirstFree(data) {
    var id = arraySearch(undefined, data);
    if(id != undefined) {
        return id;
    } else {
        return data.length;
    }
}



function getDir(url) {
    if(url) {
        return url.substring(0, url.lastIndexOf("/"));
    } else {
        return "";
    }
}

function getDomain(url) {
    if(url) {
        var tmp = url.split("//");
        return (tmp[1] != undefined) ? tmp[1].split("/")[0] : tmp[0].split("/")[0];
    } else {
        return "";
    }
}

function wordWrap(txt) {
    var w = txt.split(" ");
    var r = [];
    for(var i=0; i<w.length; i++) {
        if(w[i].length>40) {
            var stops = Math.ceil(w[i].length / 40) + 1;
            for(var j=0; j<stops; j++) {
                r[i] += w[i].substr(stops, 40) + "&shy;";
            }
        } else {
            r[i] = w[i];
        }
    }
    return r.join(" ");
}





function loadIcon(v_img, v_urls) {
    var el = new Image();
    var img = v_img;
    var urls = v_urls;
    var f = function() {
        if(urls.length > 0) {
            el.urls = urls;
            el.onload = function() {
                this.onerror = null;
                img.setAttribute("src", this.src);
    //            el = null;
            }
            el.onerror = function() {
                if(this.urls.length > 0) {

                    var url = "";
                    while(!url && (this.urls.length > 0) && (trim(url) == "")) {
                        url = urls.shift();
                    }

                    if(url) {
                        if(url.indexOf("http://") == -1) {
                            url = "http://" + url;
                        }
                        this.setAttribute("src", url);
                    }
                } else {
                    this.onerror = null;
                }
            }
            el.onerror();
        }
    }

    setTimeout(f, 100);
}


function fix_event(event) {
    if (!event) {
        event = window.event;
    }
    if (event.target) {
	    if (event.target.nodeType == 3) event.target = event.target.parentNode;
    } else if (event.srcElement) {
	    event.target = event.srcElement;
    }
    var tg = event.target;
    while((tg.entityInfo == undefined) && (tg != document.body)) {
        tg = tg.parentNode;
    }
    event.target.entityInfo = tg.entityInfo;
    return event;
}








/*********************************************
 *    
 *   DEBUG
 *
 ********************************************/

function varp(v) {
    alert(Dump(v));
}


function varpw(v) {
    win = open("", "varp", "width=900,toolbar=no,status=no,titlebar=no,scroollbars=yes");
    win.document.write("<html><body><pre style='font-family: Tahoma, Verdana, Arial; font-size: 11px;'>"+Dump(v)+"</pre></body></html>");
}


function info(v) {
    var s ='';
    for(var i in v) {
        s+=i + '; ';
    } 
    alert(s);
}


function Dump(d,l) {
    if (l == null) l = 1;
    var s = '';
    if (typeof(d) == "object") {
        s += " {\n";
        for (var k in d) {
            for (var i=0; i<l; i++) s += "  ";
            s += k+": " + Dump(d[k],l+1);
        }
        for (var i=0; i<l-1; i++) s += "  ";
        s += "}\n"
    } else {
        s += "" + d + "\n";
    }
    return s;
}


function toCode(d,l) {
    if (l == null) l = 1;
    var s = '';
    if (typeof(d) == "object") {
        var items = [];
        var i = 0;
        if(d) {
            var isList = d.length != undefined;
        } else {
            var isList = false;
        }
        for (var k in d) {
            switch(typeof(d[k])) {
            case "integet":
                var v = parseInt(d[k]);
                break;
            case "string":
                var v = "'" + d[k] + "'";
                break;
            default:
                var v = toCode(d[k],l+1);
                break;
            } 
            items[i] = isList ? v : (k + ":" + v);
            i++;
        }
        if(isList) {
            s += "[" + items.join(",") + "]";
        } else {
            s += "{" + items.join(",") + "}";
        }

    } else {
        s += "" + d;
    }
    return s;
}


function toValue(str) {
    if(str) {
        eval("var r = "+str);
        return r;
    } else {
        return {}
    }
}





/*********************************************
 *    
 *   COOKIES
 *
 ********************************************/


function getCookie(name) {
    var cookie = " " + document.cookie;
    var search = " " + name + "=";
    var setStr = "";
    var offset = 0;
    var end = 0;
    if (cookie.length > 0) {
        offset = cookie.indexOf(search);
        if (offset != -1) {
            offset += search.length;
            end = cookie.indexOf(";", offset)
            if (end == -1) {
                end = cookie.length;
            }
        setStr = unescape(cookie.substring(offset, end));
        }
    }

    return(setStr);
}


function setCookie(name, value) {
    var today = new Date(); 
    today.setTime(today.getTime()); 
    var expires_date = new Date(today.getTime() + 31536000000); 
    document.cookie = name + "=" + escape(value) + ";expires=" + expires_date.toGMTString(); 
}


function delCookie(name) {
    if(getCookie(name)) {
        document.cookie = name + "=;expires=Thu, 01-Jan-1970 00:00:01 GMT"; 
    }
}









/*********************************************
 *    
 *   STRINGS
 *
 ********************************************/

function text2html(txt) {
    txt = txt.replace(/\&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/\n/g, "<br>");
    return txt;
}


function html2text(html) {
    html = html.replace(/<br>/g,"\n").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">");
    return html;
}


String.prototype.addSlashes = function() {
    return this.replace(/\\/g,'\\\\').replace(/\"/g,"\\\"").replace(/\'/g,"\\\'");
}

String.prototype.stripSlashes = function() {
    return this.replace(/\\'/g,'\'').replace(/\\"/g,'"').replace(/\\\\/g,'\\');
}


String.prototype.wordWrap = function(w) {
    var i, j, s, r = this.split("\n");
    if(w > 0) for(i in r){
        for(s = r[i], r[i] = ""; s.length > w;
                r[i] += s.substr(0, w) + ((s = s.substr(w)).length ? "&shy;" : "")
            );
        r[i] += s;
    }
    return r.join("\n");
}

String.prototype.jsEscape = function() {
    return this.replace(/\%/g, "%jcp").replace(/\n/g, "%jcn").replace(/\r/g, "%jcr").replace(/"/g, "%jcqq").replace(/'/g, "%jcq").replace(/\\/g, "%jcbs");
}

String.prototype.jsUnescape = function() {
    return this.replace(/\%jcr/g, " ").replace(/\%jcn/g, "\n").replace(/\%jcqq/g, "\"").replace(/\%jcq/g, "'").replace(/\%jcbs/g, "\\").replace(/\%jcp/g, "%");
}

String.prototype.parseUrl = function(){
	var lines = this.split("<br>");
	for(var z=0; z<lines.length; z++){
		var tmp = lines[z].split(" ");
		for(var i=0; i<tmp.length; i++){
			if(tmp[i].indexOf("www.")!=-1 && tmp[i].indexOf("http://")==-1){
				tmp[i] = "<a href='http://"+tmp[i]+"' target='_blank'>"+tmp[i]+"</a>";
			} else if(tmp[i].indexOf("http://")!=-1 || tmp[i].indexOf("ftp://")!=-1 || tmp[i].indexOf("https://")!=-1){
				tmp[i] = "<a href='"+tmp[i]+"' target='_blank'>"+tmp[i]+"</a>";
			} else if (tmp[i].indexOf("@") != -1 && tmp[i].charAt(0) != "@" && tmp[i].charAt(tmp[i].length-1) != "@") {
				tmp[i] = "<a href='mailto:"+tmp[i]+"'>"+tmp[i]+"</a>";
			}
		}
		lines[z] = tmp.join(" ");
	}
	return lines.join("<br>");
}
