function plog(info) {
    if(DEBUG) {
        desktop.elements.debug_info.innerHTML = info + "<br>" + desktop.elements.debug_info.innerHTML;
    }
}



colorsChart = [
    ["#FFEEEE", "#FFCCCC", "#FFAAAA", "#FF8888", "#FF6666", "#FF4444", "#FF2222", "#FF0000", "#EE0000", "#CC0000", "#AA0000", "#880000", "#770000", "#660000", "#550000", "#440000", "#330000"],
    ["#EEFFEE", "#CCFFCC", "#AAFFAA", "#88FF88", "#66FF66", "#44FF44", "#22FF22", "#00FF00", "#00EE00", "#00CC00", "#00AA00", "#008800", "#007700", "#006600", "#005500", "#004400", "#003300"],
    ["#EEEEFF", "#CCCCFF", "#AAAAFF", "#8888FF", "#6666FF", "#4444FF", "#2222FF", "#0000FF", "#0000EE", "#0000CC", "#0000AA", "#000088", "#000077", "#000066", "#000055", "#000044", "#000033"],
    ["#FFFFEE", "#FFFFCC", "#FFFFAA", "#FFFF88", "#FFFF66", "#FFFF44", "#FFFF22", "#FFFF00", "#EEEE00", "#CCCC00", "#AAAA00", "#888800", "#777700", "#666600", "#555500", "#444400", "#333300"],
    ["#FFEEFF", "#FFCCFF", "#FFAAFF", "#FF88FF", "#FF66FF", "#FF44FF", "#FF22FF", "#FF00FF", "#EE00EE", "#CC00CC", "#AA00AA", "#880088", "#770077", "#660066", "#550055", "#440044", "#330033"],
    ["#FFF0D0", "#FFEECC", "#FFEEBB", "#FFDDAA", "#FFCC99", "#FFC090", "#EEBB88", "#DDAA77", "#CC9966", "#BB8855", "#AA7744", "#886633", "#775522", "#664411", "#553300", "#442200", "#331100"],
    ["#EEFFFF", "#CCFFFF", "#AAFFFF", "#88FFFF", "#66FFFF", "#44FFFF", "#22FFFF", "#00FFFF", "#00EEEE", "#00CCCC", "#00AAAA", "#008888", "#007777", "#006666", "#005555", "#004444", "#003333"],
    ["#FFFFFF", "#EEEEEE", "#DDDDDD", "#CCCCCC", "#BBBBBB", "#AAAAAA", "#A0A0A0", "#999999", "#888888", "#777777", "#666666", "#555555", "#444444", "#333333", "#222222", "#111111", "#000000"]
];




function createColorSelectDom(title, target, id) {
    var colorsTable = { tag: "table", cellSpacing: "0", cellPadding: "0", 
                        style: {borderLeft: "1px solid gray", borderTop: "1px solid gray"}, 
                        childs: [] }

    for(var i=0; i<colorsChart.length; i++) {
        var tds = [];
        for(var j=0; j<colorsChart[i].length; j++) {
            tds.push({ tag: "td",
                       childs: [
                         { tag: "div", 
                           style: {borderRight: "1px solid gray", borderBottom: "1px solid gray", background: colorsChart[i][j], width: "16px", height: "16px", cursor: "pointer"},
                           events: {onclick: "selectColor(\""+id+"_popup\",\"" + target + "\", \"" + colorsChart[i][j] + "\")"}
                         }
                       ]
                     });            
        }
        colorsTable.childs.push({tag: "tr", childs: tds});
    }




    return [ 
      createButtonDom(title, "showPopup(\""+id+"\",\""+id+"_popup\")", "static/client/select_color.gif", id),
      { tag: "div", className: "panel", id: id+"_popup", display: false, 
        style: {position: "absolute", width: "298px"},
        childs: [
          { tag: "div", className: "caption",
            childs: [
              createTableDom([{content: "<b>Select color</b>", width: "100%"},
                              {content: createButtonDom(false, "closePopup(\""+id+"_popup\")", "static/client/close.gif"), width: "1%"}
                             ])
            ]
          },
          { tag: "div", className: "content",
            childs: [ colorsTable ]
          }
        ]
      }
    ]
}


 
// make interface
function createButtonDom(title, action, icon, id, img_id) {
    if((icon != false) && (icon != null) && (icon != undefined)) {
        if(title) {
        
            var button = 
                { tag: "span", 
                  childs: [
                    { tag: "img", id: img_id, src: icon, 
                      style: { margin: "0px 4px 0px 0px", verticalAlign: "middle"}},
                    { tag: "a", href: "void", events: {onclick: action}, innerHTML: title }
                  ]}
            
            if(id) button.childs[1].id = id;
        } else {
            var button = { tag: "a", href: "void", events: {onclick: action}, 
                           childs: [
                             { tag: "img", id: img_id, src: icon}
                           ]};
            if(id) button.id = id;
        }
    } else {
        var button = { tag: "a", href: "void", events: {onclick: action}, innerHTML: title};
        if(id) button.id = id;
    }

    return button;
}



// tds: [{content:dom, width: ""}]
function createTableDom(tds, width) {
    var table = { tag: "table", width: (width ? width : "95%"), 
                  childs: {
                    tr: { tag: "tr",
                          childs: {} }
                  }
                };
    for(var i=0; i<tds.length; i++) {
        if(typeof(tds[i].content) == "string") {
            table.childs.tr.childs[i] = { tag: "td", width: tds[i].width, innerHTML: tds[i].content };
        } else {
            table.childs.tr.childs[i] = { tag: "td", width: tds[i].width, 
                                          childs: [tds[i].content] };
        }
    }
    return table;
}


//content: array of doms. will be closed with panel sections
function createPanelDom(name, title, content) {
    var m = 
        { tag: "div", className: "panel",
          display: false,
          id: "panel_" + name,
          childs: [
            { tag: "div", className: "panel_header",
              childs: [
                { tag: "div", className: "panel_title",
                  innerHTML: title },
                { tag: "div", className: "panel_close_icon",
                  events: { onclick: "hideElement('panel_" + name + "')"} }
              ]}
          ]}

    for(var i in content) {
        m.childs.push({ tag: "div", className: "panel_section", childs: content[i] });
    }

    return m;
}








// CRC32
(function() { 
    var table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
 
    /* Number */ 
    crc32 = function( /* String */ str, /* Number */ crc ) { 
        if( crc == window.undefined ) crc = 0; 
        var n = 0; //a number between 0 and 255 
        var x = 0; //an hex number 
        crc = crc ^ (-1); 
        for( var i = 0, iTop = str.length; i < iTop; i++ ) { 
            n = ( crc ^ str.charCodeAt( i ) ) & 0xFF; 
            x = "0x" + table.substr( n * 9, 8 ); 
            crc = ( crc >>> 8 ) ^ x; 
        } 
        return crc ^ (-1); 
    }; 
})();