function AolVideo() {
    this.init();

    this.cfg = {
        title: "",
        module: "AolVideo"
    };


    this.channel = "http://spinner.aol.com/musicsessions/sessions_archive.adp";

    this.defaultProfile["title"] = "";
    this.defaultProfile["count"] = "6";

    var loading = false;
    var req = null;
    var content = null;
    var itemsCount = 25;

    var sel_count_options = [];
    for(var i=1; i<=itemsCount; i++) {
        sel_count_options.push({value: i, text: " " + i + " "});
    }

    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("aolvideo_inp_count"), className: "settings_label"},
            { tag: "select", id: "inp_count", events: {onchange: "setCount()"}, className: "settings_control",
              options: sel_count_options }
          ]}
    ]



    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.elements["inp_count"].value = this.profile.count;
    }


    this.setCount = function() {
        var c = this.elements["inp_count"].value;
        if(c != this.profile.count) {
            this.profile.count = c;
            this.save();
            this.renderContent();
        }
    }


    this.onOpen = function() {
        this.refresh();
    }



    this.refresh = function() {
        if(!loading) {
            this.setTitle(loc.text("msg_loading"));
            req = xmlRequest.send(this.channel, this, "parseContent");
            loading = true;
        }
    }


    this.parseContent = function(response) {
        loading = false;
        if(response.responseXML && response.responseXML.documentElement) {
            try {
                var doc = response.responseXML.documentElement;
                var items = doc.getElementsByTagName("session");
                content = [];

                var last = items.length - Math.min(itemsCount, items.length);
                if(last <0) { 
                    last = 0;
                }

                for(var i=items.length-1; i>last; i--) {
                    if(!items[i].getElementsByTagName("artistThumb")[0].firstChild) {
                        if(last > 0) last--;
                    } else {
                        content.push({
                            id: items[i].getAttribute("id"),
                            name: items[i].getElementsByTagName("artistName")[0].firstChild.nodeValue,
                            thumb: items[i].getElementsByTagName("artistThumb")[0].firstChild.nodeValue
                        });
                    }
                }
            } catch(e) { 
                content = null; 
            }
        } else {
            content = null;
        }
        this.renderContent();
    }

    

    this.renderContent = function() {
        if(content) {
            if(this.profile.title != "") {
                this.setTitle(this.profile.title);
            } else {
                this.setTitle(loc.text("aolvideo_title"));
            }
            var l = Math.min(content.length, this.profile.count);
            var c = "";
            var st = "";

            for(var i=0; i<l; i++) {
                st = i % 2 ? "background: #F0F0F0;" : "";
                var lnk = "http://music.aol.com/videos/sessions/sessions_flash.adp?ncid=AOLMUS00050000000052&defaultShow=" + content[i].id;
                c += "<tr style='"+st+"'>"+
                     "<td valign=top style='padding: 4px;' width=10%><a href='"+lnk+"' target=_blank><img style='border: 0' src='"+ content[i].thumb +"'/></a></td>"+
                     "<td style='padding: 4px;' valign=top>" + content[i].name + "<br>" + loc.text("aolvideo_session") + content[i].id + "<br>" +
                     "<a href='"+lnk+"' target=_blank>"+
                     "<img src='widgets/aolvideo/cam.gif' style='margin-right: 4px; height: 8px; border: 0; vertical-align: middle;'>"+
                     "<b>"+loc.text("aolvideo_lnk_watch")+"</b></a>"+"</td>" +
                     "</tr>";
            }
            this.elements["content"].innerHTML = "<table class='plan_table' width=99%>" + c + "</table>";
        } else {
            this.setTitle(loc.text("msg_error"));
        }
    }
 
}
AolVideo.prototype = new Widget();