function Auth() {

    this.init();

    this.cfg = {
        hasIcon: true,
        hasSizeBtn: false,
        hasCloseBtn: true,
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        hasDrag: false,
        hasOnCloseConfirm: false,
        isOpenHidden: false,
        isSystem: true,
        title: loc.text("auth_title"),
        module: "Auth",
        uniqueId: SYS_WIDGETS_ID + 2
    }

    this.user = { id: null,
                  email: null,
                  password: null}        




    this.domContent = [
        { tag: "div", className: "float_panel",
          id: "login_form",
          childs: [
            { tag: "div", className: "float_left",
              style: { width: "45%", padding: "8px" },
              childs: [
                // login exist user
                { tag: "h1", html: loc.text("auth_exist_user") },
                { tag: "div", html: loc.text("inp_email") },
                { tag: "div", 
                  childs: [
                    { tag: "input", id: "login_email", size: "30",
                      type: "text" }
                  ]},
                { tag: "div", html: loc.text("inp_pwd") },
                { tag: "div", 
                  childs: [
                    { tag: "input", id: "login_pwd", size: "30",
                      type: "password" }
                  ]},
                { tag: "div", style: { textAlign: "center", marginTop: "12px"},
                  childs: [
                    { tag: "input", id: "login_btn",
                      events: { onclick: "tryLogin()"},
                      type: "button", value: loc.text("auth_load_my_page") }
                  ]},
                { tag: "div", id: "login_msg",
                  style: { marginTop: "12px", textAlign: "justify"}},

                // pwd remind
                { tag: "div",
                  style: { marginTop: "12px"},
                  childs: [
                    { tag: "div",
                      id: "pwd_remind_link",
                      childs: [
                        { tag: "a", href: "showRemindForm()",
                          html: loc.text("auth_lnk_forget_pwd") }
                      ]},
                    { tag: "div",
                      display: false,
                      id: "pwd_remind_form",
                      childs: [
                        { tag: "h1", html: loc.text("auth_remind_title")},

                        { tag: "div", html: loc.text("inp_email") },
                        { tag: "div", 
                          childs: [
                            { tag: "input", size: "30",
                              id: "inp_reminder_email",
                              type: "text" },
                            { tag: "input", type: "button", 
                              value: loc.text("btn_send"),
                              events: { onclick: "remindPwd()"} }
                          ]}
                      ]},
                    { tag: "div", id: "pwd_remind_msg",
                      html: loc.text("msg_sending"),
                      display: false }
                  ]}
              ]},

            // new user explanation
            { tag: "div", className: "float_right",
              style: { width: "45%", padding: "8px" },
              childs: [
                { tag: "h1", html: loc.text("auth_new_user") },
                { tag: "div", style: { textAlign: "justify"},
                  html: loc.text("auth_reg_msg") },  
                { tag: "div", style: { textAlign: "center", marginTop: "12px"},
                  childs: [
                    { tag: "input", id: "goreg_btn",
                      events: { onclick: "showRegform()"},
                      type: "button", value: loc.text("auth_registration") }
                  ]}
              ]}
          ]},

        { tag: "div", id: "reg_form", className: "float_panel",
          display: false,
          childs: [
            { tag: "div", className: "float_left",
              style: { width: "45%", padding: "8px" },
              childs: [
                { tag: "h1", html: loc.text("auth_new_user") },
                { tag: "div", style: { textAlign: "justify"},
                  html: loc.text("auth_reg_msg") }
              ]},

            { tag: "div", className: "float_right",
              style: { width: "45%", padding: "8px" },
              childs: [
                { tag: "h1", html: "&nbsp;" },
                { tag: "div", html: loc.text("inp_email") },
                { tag: "div", 
                  childs: [
                    { tag: "input", id: "reg_email", size: "30",
                      type: "text" }
                  ]},
                { tag: "div", html: loc.text("inp_email2") },
                { tag: "div", 
                  childs: [
                    { tag: "input", id: "reg_email2", size: "30",
                      type: "text" }
                  ]},

                { tag: "div", html: loc.text("inp_pwd") },
                { tag: "div", 
                  childs: [
                    { tag: "input", id: "reg_pwd", size: "30",
                      type: "password" }
                  ]},
                { tag: "div", html: loc.text("inp_pwd2") },
                { tag: "div", 
                  childs: [
                    { tag: "input", id: "reg_pwd2", size: "30",
                      type: "password" }
                  ]},

                { tag: "div", style: { textAlign: "center", marginTop: "12px"},
                  childs: [
                    { tag: "input", id: "reg_btn",
                      events: { onclick: "tryRegister()"},
                      type: "button", value: loc.text("auth_process_reg_btn") }
                  ]},
                { tag: "div", id: "reg_msg",
                  style: { marginTop: "12px", textAlign: "justify"}}
              ]}
          ]},


        { tag: "div", id: "reg_ok", className: "float_panel",
          display: false,
          childs: [
            { tag: "div", className: "float_left",
              style: { width: "45%", padding: "8px" },
              childs: [
                { tag: "h1", html: loc.text("auth_new_user") },
                { tag: "div", style: { textAlign: "justify"},
                  html: loc.text("auth_registration_ok") },
                { tag: "div", style: { textAlign: "center", marginTop: "12px"},
                  childs: [
                    { tag: "input", type: "button",
                      events: { onclick: "regFinish()"},
                      value: loc.text("btn_ok")}
                  ]}
              ]}
          ]}
    ]



    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.content, this.domContent);

        this.buildDomModel(desktop.elements.authButton, 
                           [{ tag: "span", id:"signinBtn",
                              childs: [createButtonDom(loc.text("auth_lnk_sign_in"), "signIn()", "widgets/auth/img/sign_in.gif")]  },
                            { tag: "span", id:"signoutBtn",
                              childs: [createButtonDom(loc.text("auth_lnk_sign_out"), "logout()", "widgets/auth/img/sign_out.gif")]  }]);

        if(this.isLogged()) {
            hideEl(this.elements.signinBtn);
        } else {
            hideEl(this.elements.signoutBtn);
        }
        this.setTitle(loc.text("auth_title"));
    }



    this.showRemindForm = function() {
        this.showElement("pwd_remind_form");
        this.hideElement("pwd_remind_link");
        this.hideElement("pwd_remind_msg");
        this.elements["inp_reminder_email"].value = "";
        this.elements["inp_reminder_email"].focus();
    }


    this.regFinish = function() {
        this.close();
    }


    this.remindPwd = function() {
        var email = trim(this.elements["inp_reminder_email"].value);
        if(this.checkEmail(email)) {
            request.send( { act: "remind_pwd", email: email }, this);
            this.hideElement("pwd_remind_form");
            this.showElement("pwd_remind_msg");
        }
    }


    this.showRegform = function() {
        this.showElement("reg_form");
        this.hideElement("login_form");
    }


    this.hideRegform = function() {
        this.hideElement("reg_form");
        this.showElement("login_form");
    }




    this.tryLogin = function() {
        var e = trim(this.elements["login_email"].value);
        var pwd = trim(this.elements["login_pwd"].value);
        if(e != "" && pwd != "") {
            request.send({ act: "login_user",
                           email: e,
                           password: pwd }, this);
            this.hideElement("login_btn");
            this.hideElement("goreg_btn");
            this.elements["login_msg"].innerHTML = loc.text("msg_processing");
        }
    }



    this.tryRegister = function() {
        var e = trim(this.elements["reg_email"].value);
        var e2 = trim(this.elements["reg_email2"].value);
        var pwd = trim(this.elements["reg_pwd"].value);        
        var pwd2 = trim(this.elements["reg_pwd2"].value);

        if(e != e2 || !this.checkEmail(e)) {
            this.elements["reg_msg"].innerHTML = loc.text("auth_email_error"); 
        } else if(pwd != pwd2 || !this.checkPassword(pwd)) {
            this.elements["reg_msg"].innerHTML = loc.text("auth_pwd_error"); 
        } else if(e != "" && pwd !="") {
            request.send({ act: "register_user",
                           email: e,
                           password: pwd }, this);
            this.hideElement("reg_btn");
            this.elements["reg_msg"].innerHTML = loc.text("msg_processing");
        }
    }




    this.close = function() {
        this.hideRegform();
        desktop.closeCurrentPage();
    }


    this.signIn = function() {
        desktop.showPage('auth');
    }



    this.isLogged = function() {
        return this.user.email != '';
    }


    this.logout = function() {
        request.send({act: "logout"}, this);
    }



    this.loadUser = function() {
        this.anonymusId = getCookie("anonymusid");
        this.user.id = getCookie("userid");
        this.user.email = getCookie("useremail");
        this.user.password = getCookie("userpassword");
    }


    this.saveUser = function() {
        setCookie("userid", this.user.id);
        setCookie("useremail", this.user.email);
        setCookie("userpassword", this.user.password);
    }








    this.start = function() {
        if(session_user) {
            this.user = session_user;
//            this.saveUser();
            this.onLoad();
        } else {
            this.loadUser();
            if(this.user.email && this.user.password) {
                request.send({act: "start_user", user_id: this.user.id, email: this.user.email, password: this.user.password}, this);
            } else {
                request.send({act: "start_anonymus", user_id: this.user.id}, this);
            }
        }
    }



    this.dispatchMsg = function(msg) {
        switch(msg.status) {
            case "":
                break;

            case "start_result": 
                this.user = msg.user;
                this.saveUser();
                this.onLoad();
                break;


            case "register_ok":
                this.showElement("reg_ok");
                this.hideElement("reg_form");
                this.elements["signinBtn"].style.display = "none";
                this.elements["signoutBtn"].style.display = "inline";
                this.user = msg.user;
                this.saveUser();
                //dimk
                break;

            case "register_error":
                this.elements["reg_msg"].innerHTML = loc.text("auth_msg_reg_error");
                this.elements["reg_email"].value = "";
                this.elements["reg_email2"].value = "";
                this.showElement("reg_btn");
                break;

            case "login_ok":
                setCookie("anonymusid", this.user.id);
                this.user = msg.user;
                this.saveUser();
                location.reload();
                break;

            case "login_error":
                this.elements["login_msg"].innerHTML = loc.text("auth_login_error");
                this.showElement("login_btn");
                this.showElement("goreg_btn");
                break;


            case "logout_ok":
                var anonymusId = getCookie("anonymusid");
                if(anonymusId) {
                    this.user = {id: anonymusId, email: "", password: ""};
                    this.saveUser();
                    delCookie("anonymusid");
                } else {
                    delCookie("userid");
                    delCookie("useremail");
                    delCookie("userpassword");
                }
                location.reload();
                break;


            case 'user_ok':
                if(!this.user.email) {
                    setCookie("anonymusid", this.user.id);
                }
                this.user = msg.user;
                this.saveUser();
                location.reload();
                break;


            case "pwd_sent":
                this.elements["inp_reminder_email"].value = "";
                this.hideElement("pwd_remind_form");
                this.showElement("pwd_remind_link");
                this.hideElement("pwd_remind_msg");
                break;

            }
        }


 
    this.onLoad = function() {}



    this.registerUser = function() {
        var errors = [];
        email = trim(this.elements.selectEmail.value);
        password = trim(this.elements.selectPassword.value);
        if(!this.checkEmail(email)) {
            errors[errors.length] = "<b>" + loc.text("auth_msg_email_invalid") + "</b>";
        }
        if(!this.checkPassword(password)) {
            errors[errors.length]= "<b>" + loc.text("auth_msg_pwd_invalid") + "</b>";
        }
        if(errors.length > 0) {
            this.elements.messages.innerHTML = errors.join("<BR>");
        } else {
            hideEl(this.elements.submitButton);
            this.elements.messages.innerHTML = loc.text("msg_processing");
            request.send({act: "register_user", email: email, password: password}, this);
        }
    }



    this.checkEmail = function(str) {
        return /^[a-zA-Z][a-z0-9\-\_]{1,20}@[a-z0-9\-\_\.]{5,30}$/.test(str);
    }

    this.checkPassword = function(str) {
        return (str.length > 5);
    }

}
Auth.prototype = new Widget();