function Browser() {
    this.init();

    this.cfg = {
        hasRefreshBtn: false,
        hasProfile: true,
        title: loc.text("browser_title"),
        module: "Browser"
    };

    this.defaultProfile["home_page"] = "";


    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("browser_inp_url"), className: "settings_label"},
            { tag: "input", type: "text", size: 15, id: "inp_home_page", className: "settings_control"},
            { tag: "input", type: "button", events: {onclick: "setHomePage()"}, value: loc.text("btn_go"), className: "settings_control"}
          ]} 
    ]



    this.domContent = [
        { tag: "iframe",
          id: "browser",
          vspace: "0",
          hspace: "0",
          marginwidth: "0",
          marginheight: "0",
          frameBorder: "0",
          style: { width: "100%", height: "340px", border: "0" }}
    ]


    this.onBuildInterface = function() {
        this.setTitle(loc.text("browser_title"));
        this.elements.settings.innerHTML = "";
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.buildDomModel(this.elements.content, this.domContent);
        this.elements["inp_home_page"].value = this.profile["home_page"];
    }


    this.onOpen = function() {
        this.navHome();
    }


    this.setHomePage = function() {
        this.profile["home_page"] = this.formatUrl(this.elements["inp_home_page"].value);
        this.elements["inp_home_page"].value = this.profile["home_page"];
        this.navHome();
        this.save();
        this.switchSettings();
    }


    this.navHome = function() {
        this.elements["browser"].src = this.profile["home_page"];
    }

  
    this.formatUrl = function(str) {
        var url = trim(str);
        if(url.indexOf("http://") == -1) {
            url = "http://"+url;
        }
        return url;
    } 
 
 
}
Browser.prototype = new Widget();