//
// Widget class definition. Class name must be unique for each widget.
//
function Demo() {



    //
    // Calling of init() function must be placed at begining of widget.
    //
    this.init();




    //
    // Widget config - definition of widget parametrs.
    // 
    // Note: you does't need to overload default values,
    // for example:      
    //
    //    this.cfg = {
    //        module: "Demo"
    //    }
    //  

    this.cfg = {
        // Caption icon image. 
        // Default value: true
        hasIcon: true, 

        // Caption size button (show/hide widget content). 
        // Default value: true
        hasSizeBtn: true,

        // Caption close button (close widget and remove it from page). 
        // Default value: true
        hasCloseBtn: true,

        // Caption refresh button (this.refresh() method will be called on click). 
        // Default value: true
        hasRefreshBtn: true,

        // Caption settings button (show/hide widget settings panel). 
        // Default value: true
        hasSettingsBtn: true,

        // Drag&drop (widget window will be dragable). 
        // Default value: true
        hasDrag: true,

        // Show confirmation prompt to user before closing widget. 
        // Default value: true
        hasOnCloseConfirm: true,

        // Widget will has profile or not. 
        // Default value: true
        hasProfile: true,

        // Widget name (name of widget class)
        // Important: always must be filled and be unique for each widget
        module: "Demo",

        // Method of sending widget profile to server. Must be "GET" or "POST"
        // Default value: "GET"
        saveMethod: "GET"
    };




    //
    // Widget profile default values. 
    // That values will stored to profile on first start(when user add widget to page)
    //
    this.defaultProfile["title"] = loc.text("demo_title");
    this.defaultProfile["text"] = "abc";




    //
    // Hash HTML model for Demo widget settings panel
    //
    // About multylanguage support:
    // loc.text(label) is system function that return text string for label corresponding current user language,
    // all text strings must be added to language .xml files in format:
    // <string id="label">string</string>
    //
    this.modelSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", className: "settings_label",
              innerHTML: loc.text("demo_inp_combobox") },

            { tag: "select", className: "settings_control",
              id: "inp_combobox", 
              events: {onchange: "onComboboxChange()"}, 

              //
              // options for combobox element must be in array with element: 
              // { value: "..", text: ".." || , isBold}
              // value - option value,
              // text - option text that visible for user
              // isBold - option will be bolded
              //
              options: [
                { value: "1", text: "1" },
                { value: "2", text: "2" },
                { value: "3", text: "3" }
              ]}
          ]},

        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", className: "settings_label",
              innerHTML: loc.text("demo_inp_text")},

            { tag: "input", type: "text", calssName: "settings_control",
              id: "inp_text" },
            { tag: "input", type: "button",
              events: { onClick: "onButtonClick()" },

              //
              // You can user loc labels for default strings:
              // btn_set - "Set"
              // btn_ok - "Ok"
              // btn_cancel - "Cancel"
              // btn_yes - "Yes"
              // btn_no - "No"
              // btn_go - "Go"
              // btn_save - "Save"
              // btn_delete - "Delete"
              // btn_add - "Add"
              // btn_send - "Send"
              //
              value: loc.text("btn_ok") }
          ]}
    ]



    //
    // Callback for settings panel combobox onChange event
    //
    this.onComboboxChange = function() {
        //
        // this.elements contain pointes to all elements that builded 
        //   with "id" property by this.buildDomModel() function.
        // Be sure that you has't duplicate id's.
        //
        alert(this.elements["inp_combobox"].value);
    }




    //
    // Callback for settings panel Ok button onClick event
    //
    this.onButtonClick = function() {
        var t = this.elements["inp_text"].value;
        if(t != this.profile["text"]) {
            this.profile["text"] = t;
            this.elements["text"].innerHTML = t;

            //
            // this.save() method saving all data from widget profile to server.
            // All saved data will be restored on next site reload.
            //
            this.save();
        }
    }



    //
    // Hash HTML model for Demo widget content area
    //
    this.modelContent = [
        { tag: "div", id: "text" }
    ]



    //
    // Build all static interface elements for widget here
    //
    this.onBuildInterface = function() {
        //
        // Building HTML from models,
        // to get more information have a look to document.createElement() function specification for browsers 
        // and DOM specifications.
        //
        // properties that extended:
        //
        // id - will add pointer to elements in this.elements hash
        // events - hash with events and callbacks that will be attached to element
        // html - alias to innerHTML
        // 
        // Default elements in this.elements hash:
        // "settings" - settings panel
        // "content" - content element inside widget window
        // "title" - title element in widget window caption
        //
        this.buildDomModel(this.elements["settings"], this.modelSettings);
        this.buildDomModel(this.elements["content"], this.modelContent);

        // call function this.setTitle() to set title in widget caption
        this.setTitle(this.profile["title"]);

        // title control present in settings panle by default.
        // use this.elements["settings"].innerHTML = "" to delete it
        this.elements["input_title"].value = this.profile["title"];


        this.elements["inp_text"].value = this.profile["text"];
        this.elements["text"].innerHTML = this.profile["text"];
    }



    //
    // this.onOpen() function will called when widget added to page.
    //
    this.onOpen = function() {
        // Any code
    }


    
    //
    // Caption refresh button call back
    //
    this.refresh = function() {
        alert("Refresh button pressed.");
    }

 
}

//
// Definition of class prototype. Prototype always must be Widget object.
//
Demo.prototype = new Widget();