function Feedback() {
    this.init();

    this.cfg = {
        hasSizeBtn: false,
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        hasDrag: false,
        hasProfile: false,
        title: loc.text('feedback_user_feedback'),
        module: "Feedback",
        uniqueId: SYS_WIDGETS_ID + 7
    }


    this.onBuildInterface = function() {
        this.setTitle(this.cfg.title);

        this.buildDomModel(this.elements.content, [
           { tag: "div", align: "center", id: "feedback_status",
             html: "<B>" + loc.text("feedback_status") + "</B>"},
           { tag: "hr"},
           { tag: "div", className: "menu_panel", 
             id: "feedback_sending", 
             display: false, 
             innerHTML: "<p><b>"+loc.text('feedback_sending')+"</b></p>" },
           { tag: "table", width: "95%",
             id: "feedback_input",
             childs: [
               { tag: "tr",
                 childs: [
                   { tag: "td", width: "30%", align: "right",
                     childs: [{ tag: "div", innerHTML: loc.text('sendtofriend_your_email')}]},
                   { tag: "td",
                     childs: [{ tag: "input", type: "text", id: "inp_email", size: "30"}]}
                 ]
               },
               { tag: "tr",
                 childs: [
                   { tag: "td", width: "30%", align: "right", valign: "top",
                     childs: [{ tag: "div", innerHTML: loc.text('feedback_feedback_text')}]},
                   { tag: "td",
                     childs: [{ tag: "textarea", id: "inp_message", rows: 16, cols: 50, style: {width: "90%"} }]}
                 ]},
               { tag: "tr",
                 childs: [
                   { tag: "td"},
                   { tag: "td",
                     childs: [
                       { tag: "input", type: "button", align: "center", 
                         value: loc.text('btn_send'), 
                         events: {onclick: "sendFeedback()"}}
                     ]}
                 ]}
             ]}      
        ]);
        this.elements["content"].style.height = "300px";
        this.elements["inp_email"].value = auth.user.email;
    }



    this.close = function() {
        desktop.closeCurrentPage();
    }


    this.showText = function() {}
    this.applyText = function() {}


    //-------------------------------------
    // SEND
    //-------------------------------------
    this.sendFeedback = function() {
        var str = this.elements["inp_message"].value;
        if(str!="") {
            hideEl(this.elements.feedback_input);
            showEl(this.elements.feedback_sending);
            request.send({ act: "feedback", 
                           text: str, 
                           email: this.elements["inp_email"].value}, 
                         this, "POST");
        }
        else {
            alert(loc.text('feedback_text_empty'));
        }
    }


    this.dispatchMsg = function(msg) {
        switch (msg.status) {
            case "feedback_saved":
            	this.elements.feedback_status.innerHTML = "<b>"+loc.text('feedback_msg_saved')+"</b>";
            	this.elements["inp_message"].value = "";
            	showEl(this.elements.feedback_input);
            	hideEl(this.elements.feedback_sending);
                break;
            case "empty_text":
            	this.elements.feedback_status.innerHTML = loc.text('feedback_msg_empty');
            	showEl(this.elements.feedback_input);
            	hideEl(this.elements.feedback_sending);
                break;
        }
    }



}
Feedback.prototype = new Widget();
