function Flash() {
    this.init();


    this.cfg = {
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        itemsDir: 'var/flash/',
        title: loc.text("flash_title"),
        module: "Flash"
    }

    this.flash_catalog = [];    


    this.domContent = [
        { tag: "div", className: "menu_panel", id: "controls", display: false,
          childs: [
            createTableDom([{content: createButtonDom(loc.text("flash_open"), "openPlayer()", "widgets/flash/img/full_screen.gif"), width: "70%"},
                            {content: createButtonDom(loc.text("flash_stop"), "stopFlash()", "widgets/flash/img/stop.gif"), width: "30%"}]),
          ]
        },

        { tag: "div", style: {padding: "0px", margin: "0px"}, id: "flash_content", 
          childs: [
            { tag: "div", id: "flash_container", style: {width: "100%", height: "100%"} }
          ]
        },
        { tag: "div", className: "menu_panel", id: "flash_cat_content0", display: false }
    ];


    this.defaultProfile["file"] = "";
    this.defaultProfile["title"] = loc.text("flash_title");


    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.content, this.domContent);
        this.switchFlashCategory(0);
        this.setTitle(this.profile.title);
        if(this.profile.file != "") {
            this.loadFlash();
        }
    }


    this.openPlayer = function() {
        flashPlayer.openFlash(this.id);
    }


    this.stopFlash = function() {
        this.elements.flash_container.innerHTML = '';
        hideEl(this.elements.flash_content);
        hideEl(this.elements.controls);

        this.profile.title = this.cfg.title;
        this.profile.file = "";
        this.setTitle(this.profile.title);
        this.save();
    }



    this.switchFlashCategory = function(catId) {
        var el = this.elements["flash_cat_content"+catId];
        if(el.style.display == 'none') {
            if(this.flash_catalog[catId]) {
                if(this.flash_catalog[catId].rendered) {
                    el.style.display = 'block';
                } else {
                    this.renderFlashCategory(catId);
                }
            } else {
                el.innerHTML = loc.text("msg_loading");
                el.style.display = 'block';
                request.send({act: "get_flash_category", cat_id: catId}, this);
            }
            if(catId != "0") {
                this.elements["fico_" + catId].setAttribute("src", menu.folder_o.src);
            }
        } else {
            if(catId != "0") {
                this.elements["fico_" + catId].setAttribute("src", menu.folder_s.src);
            }
            el.style.display = 'none';
        }
    }


    this.renderFlashCategory = function(catId, silent) {
        el = this.elements["flash_cat_content"+catId];
        el.innerHTML = '';
        with(this.flash_catalog[catId]) {
            if(categories) {
                for(var i in categories) {
                    this.buildDomModel(el, 
                      { tag: "div", className: "menu_panel", id: "flash_cat"+categories[i].id, 
                        childs: [
                          createButtonDom(categories[i].name, 
                                          "switchFlashCategory("+categories[i].id+")", 
                                          menu.folder_s.src,
                                          null,
                                          "fico_" + categories[i].id),
                          { tag: "div", id: "flash_cat_content"+categories[i].id, className: "menu_sub_panel", display: false }
                        ]
                      });
                }
            }

            if(items) {
                for(var i in items) {
                    this.buildDomModel(el, 
                      { tag: "div", className: "menu_panel", id: "flash_cat_item"+items[i].id, 
                        childs: [
                          createButtonDom(items[i].title, 
                                          "openFlash('"+items[i].file+"', '"+items[i].title.addSlashes()+"')", 
                                          "widgets/flash/img/item.gif", 
                                          "flash_cat_item"+items[i].id)
                        ]
                      });
                }
            }  

            if(!items  &&  !categories) {
                el.innerHTML = loc.text("msg_empty");
            }

            rendered = true;
        }

        if(!silent) {
            el.style.display = 'block';
        }
        this.flash_catalog[catId].rendered = true;
    }



    this.openFlash = function(file, title) {
        this.profile.title = title;
        this.profile.file = file;
        this.loadFlash(file, title);
        this.save();
    }

    this.loadFlash = function() {
        if(this.profile.file) {
            showEl(this.elements.controls);
            this.setTitle(this.profile.title);

            showEl(this.elements.flash_content);

            this.elements.flash_content.style.height = "200px";

            this.elements.flash_container.style.height = "100%";
            this.elements.flash_container.align = "center";
            this.elements.flash_container.innerHTML = '';
            var h = (mozilla_nav ? "90%" : "100%");
            this.elements.flash_container.innerHTML = 
                 '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'+
                 '        codebase="http://active.macromedia.com/flash2/cabs/swflash.cab#version=5,0,0,0" '+
                 '        height='+h+' width=100%>'+
                 '<param name=movie '+
                 '       value="'+this.cfg.itemsDir+this.profile.file+'">'+
                 '<param name=quality value=high>'+
                 '<param name=bgcolor value=#ffffff>'+
                 '<embed src="'+this.cfg.itemsDir+this.profile.file+'" '+
                 '       quality=high bgcolor=#FFFFFF '+
                 '       height='+h+' width=100%'+
                 '       type="application/x-shockwave-flash" '+
                 '       pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash"></embed>'+
                 '</object>';
        }
    }


    this.dispatchMsg = function(msg) {
        switch (msg.status) {

            case "flash_category_data":
                this.flash_catalog[msg.cat_id] = { categories: msg.categories, items: msg.items};
                this.renderFlashCategory(msg.cat_id);
                break;
        }
    }
 
}
Flash.prototype = new Widget();