function FlashPlayer() {
    this.init();

    this.cfg = {
        hasSizeBtn: false,
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        hasDrag: false,
        hasProfile: false,
        title: loc.text("flash_title"),
        module: "FlashPlayer",
        uniqueId: SYS_WIDGETS_ID + 6
    }


    this.onBuildInterface = function() {
        this.elements.content.style.height = "400px";
    }


    this.openFlash = function(widgetId) {
        this.widgetId = widgetId;
        var widget = kernel.getWidget(widgetId);
        this.setTitle(this.cfg.title + ": " + widget.profile.title);
        widget.elements.flash_container.parentNode.removeChild(widget.elements.flash_container);
        this.elements.content.appendChild(widget.elements.flash_container);
        desktop.showPage('flashplayer');
    }


    this.close = function() {
        if(this.widgetId) {
            var widget = kernel.getWidget(this.widgetId);
            widget.elements.flash_container.parentNode.removeChild(widget.elements.flash_container);
            widget.elements.flash_content.appendChild(widget.elements.flash_container);
        }
        desktop.closeCurrentPage();
    }
 
}
FlashPlayer.prototype = new Widget();