function Flickr() {
    this.init();

    this.cfg = {
        title: loc.text("flickr_title_postfix"),
        module: "Flickr"
    }


    this.defaultProfile["tags"] = "";
    this.defaultProfile["layout"] = "s"; // s|t
    this.defaultProfile["target"] = "s"; // s|f



    this.tagUrl = "http://www.flickr.com/services/feeds/photos_public.gne?format=rss_200";

    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("flickr_inp_tags"), className: "settings_label"},
            { tag: "input", type: "text", size: "15", id: "selectTags", className: "settings_control"},
            { tag: "input", type: "button", events: {onclick: "setTags()"}, value: " Set ", className: "settings_control"},
          ]},

        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("flickr_inp_layout"), className: "settings_label"},
            { tag: "select", id: "selectLayout", events: {onclick: "setLayout()"}, className: "settings_control",
              options: [
                { value:"s", text: loc.text("flickr_slides")},
                { value:"t", text: loc.text("flickr_thumbs")}
              ]
            }
          ]},


        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("flickr_open_to"), className: "settings_label"},
            { tag: "select", id: "selectTarget", events: {onclick: "setTarget()"}, className: "settings_control",
              options: [
                { value:"s", text: loc.text("flickr_to_site")},
                { value:"f", text: loc.text("flickr_to_full")}
              ]
            }
          ]}
    ]


    this.domContent = [ { tag: "div", className: "menu_panel", id: "head", display: false,
                          style: { textAlign: "center"},
                          childs: [
                            createButtonDom(false, "showPrevPhoto()", "widgets/flickr/img/previous.gif"),
                            { tag: "span", innerHTML: "&nbsp;"},
                            createButtonDom(false, "showNextPhoto()", "widgets/flickr/img/next.gif")
                          ]
                        },
                        { tag: "div", className: "menu_panel", id: "view_big", style: {textAlign: "center"}, display: false,
                          childs: [
                            { tag: "a", href: "void", events: {onclick: "openBigPhoto()"},
                              childs: [
                                { tag: "img", id: "big_photo" }
                            ]}
                          ]},
                        { tag: "div", className: "menu_panel", id: "view_thumbs", style: {textAlign: "center"}, display: false }];


    this.onBuildInterface = function() {
        this.elements["settings"].innerHTML = "";
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.buildDomModel(this.elements.content, this.domContent);
        this.elements.selectTags.value = this.profile.tags;
        this.elements.selectLayout.value = this.profile.layout;
        this.elements.selectTarget.value = this.profile.target;
    }


    this.setLayout = function() {
        this.profile.layout = this.elements.selectLayout.value;
        this.save();
        this.renderPhotos();
    }

    this.setTarget = function() {
        this.profile.target = this.elements.selectTarget.value;
        this.save();
    }

    this.setTags = function() {
        var tags = trim(this.elements.selectTags.value);
        if(tags != "") {
            this.profile.tags = tags;
            this.save();
            this.refresh();
        }
    }


    this.onOpen = function() {
        this.refresh();
    }

    this.refresh = function() {
        this.setTitle(loc.text("msg_loading"));
        xmlRequest.send(this.tagUrl + (this.profile.tags=="" ? "" :  "&tags="+escape(this.profile.tags)), this, "showPhotos");
    }


    this.renderPhotos = function() {
        if(this.data) {
            if(this.profile.layout == "s") {
                if(this.data.items.length > 1) {
                    showEl(this.elements.head);
                } else {
                    hideEl(this.elements.head);
                }
                this.curPhoto = 0;
                this.showBigPhoto(this.curPhoto);
            } else {
                this.showAllPhotos();
            }
        }
    }


    /// photo rotate

    this.curPhoto = 0;

    this.showPrevPhoto = function() {
        this.curPhoto--;
        if(this.curPhoto<0) {
            this.curPhoto = this.data.items.length-1;
        }
        this.showBigPhoto(this.curPhoto);
    }

    this.showNextPhoto = function() {
        this.curPhoto++;
        if(this.curPhoto >= this.data.items.length) {
            this.curPhoto = 0;
        }
        this.showBigPhoto(this.curPhoto);
    }


    // show photos

    this.showBigPhoto = function(n) {
        hideEl(this.elements.view_thumbs);
        showEl(this.elements.view_big);
        var src = this.data.items[n]["media:thumbnail"]["url"];

        src = src.substr(0, src.length-5) + 'm.jpg';

        if(ie_nav) {
            preloadImg(this.elements.big_photo, src);
        } else {
            this.elements.big_photo.src = src;
        }
        showEl(this.elements.head);
    }


    this.showAllPhotos = function() {
        showEl(this.elements.view_thumbs);
        hideEl(this.elements.view_big);
        hideEl(this.elements.head);
        var photosDom = [];
        for(var i=0; i<this.data.items.length; i++) {
            photosDom[photosDom.length] = { tag: "a", href: "void", events: {onclick: "openPhoto("+i+")"},
                                            innerHTML: "<img width=75 src='"+this.data.items[i]["media:thumbnail"].url+"'> "}; 
        }
        this.elements.view_thumbs.innerHTML = '';
        this.buildDomModel(this.elements.view_thumbs, photosDom);
    }


    this.openBigPhoto = function() {
        this.openPhoto(this.curPhoto);
    }

    this.openPhoto = function(n) {
        open((this.profile.target == "s") ? this.data.items[n].link : this.data.items[n]["media:content"].url);
    }



    this.showPhotos = function(response) {
        if(response.responseXML.documentElement) {
            this.data = XMLParser.xml2hash(response.responseXML.documentElement);
            if(this.data) {
                this.setTitle(this.data.title);
                this.renderPhotos();
            }
        }
    }


}
Flickr.prototype = new Widget();