function FoxVideo() {
    this.init();

    this.cfg = {
        title: "",
        module: "FoxVideo"
    };


    this.channels = [
    	{text:"Top News", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=Top%20News&title=Fox%20Sports%20video%20-%20Top%20news&p=33"},
		{text:"Most Watched", value:"http://rss.video.msn.com/s/us/rss.aspx?t=hotVideo&c=topsports&title=%20MSN%20Video%20-%20sports&p=05"},		
		{text:"MLB", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=Baseball%20News&title=Fox%20Sports%20video%20-%20Baseball%20News&p=33"},
		{text:"NFL", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=NFL%20News&title=Fox%20Sports%20video%20-%20NFL%20news&p=33"},
		{text:"NCAA FB", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=College%20FB%20News&title=Fox%20Sports%20video%20-%20College%20FB%20News&p=33"},
		{text:"NBA", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=NBA%20News&title=Fox%20Sports%20video%20-%20NBA%20news&p=33"},
		{text:"NHL", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=Hockey%20News&title=Fox%20Sports%20video%20-%20Hockey%20news&p=33"},
		{text:"NCAA BK", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=College%20BK%20News&title=Fox%20Sports%20video%20-%20College%20BK%20News&p=33"},
		{text:"NASCAR", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=More%20Fox%20Sports&title=Fox%20Sports%20video%20-%20More%20Fox%20Sports%25&p=33"},
		{text:"GOLF", value:"http://rss.video.msn.com/s/us/rss.aspx?t=Fox%20Sports&c=More%20Fox%20Sports&title=Fox%20Sports%20video%20-%20More%20Fox%20Sports%25&p=33"}
    ];


    this.defaultProfile["title"] = "";
    this.defaultProfile["channel"] = "0";
    this.defaultProfile["count"] = "6";

    var isLoading = false;
    var req = null;
    var content = null;
    var itemsCount = 25;

    var sel_count_options = [];
    for(var i=1; i<=itemsCount; i++) {
        sel_count_options.push({value: i, text: " " + i + " "});
    }

    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("foxvideo_inp_channel"), className: "settings_label"},
            { tag: "select", id: "inp_channel", events: {onchange: "setChannel()"}, className: "settings_control",
              options: this.channels }
          ]},

        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("foxvideo_inp_count"), className: "settings_label"},
            { tag: "select", id: "inp_count", events: {onchange: "setCount()"}, className: "settings_control",
              options: sel_count_options }
          ]}
    ]



    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.elements["inp_channel"].selectedIndex = this.profile.channel;
        this.elements["inp_count"].value = this.profile.count;
    }


    this.setChannel = function() {
        if(isLoading) {
            this.elements["inp_channel"].selectedIndex = this.profile.channel;
        } else {
            var c = this.elements["inp_channel"].selectedIndex;
            if(c != this.profile.channel) {
                this.profile.channel = this.elements["inp_channel"].selectedIndex;
                this.save();
                req = null;
                isLoading = false;
                this.refresh();
            }
        }
    }


    this.setCount = function() {
        var c = this.elements["inp_count"].value;
        if(c != this.profile.count) {
            this.profile.count = c;
            this.save();
            this.renderContent();
        }
    }


    this.onOpen = function() {
        this.refresh();
    }




    this.refresh = function() {
        if(!isLoading) {
            this.setTitle(loc.text("msg_loading"));
            req = xmlRequest.send(this.channels[this.profile.channel].value, this, "parseContent");
            isLoading = true;
        }
    }


    this.parseContent = function(response) {
        isLoading = false;
        if(response.responseXML && response.responseXML.documentElement) {
            content = XMLParser.xml2hash(response.responseXML.documentElement);
        } else {
            content = null;
        }
        this.renderContent();
    }

    

    this.renderContent = function() {
        if(content) {
            if(this.profile.title != "") {
                this.setTitle(this.profile.title);
            } else {
                this.setTitle(content.title);
            }
            var l = Math.min(content.items.length, this.profile.count);
            var c = "";
            var st = "";

            for(var i=0; i<l; i++) {
                st = i % 2 ? "background: #F0F0F0;" : "";
                var lnk = content.items[i]["link"];
                c += "<tr style='"+st+"'>"+
                     "<td valign=top style='padding: 4px;'><a href='"+lnk+"' target=_blank><img style='border: 0' src='"+ content.items[i].enclosure.url +"'/></a></td>"+
                     "<td style='padding: 4px;'><a href='"+lnk+"' target=_blank><b>"+content.items[i].title+"</b></a>"+
                     "<p>" +content.items[i].description + "</td>" +
                     "</tr>";
            }
            this.elements["content"].innerHTML = "<table class='plan_table'>" + c + "</table>";
        } else {
            this.setTitle(loc.text("msg_error"));
        }
    }
 
}
FoxVideo.prototype = new Widget();