function Gmail() {
    this.init();


    this.cfg = {
        hasSettingsBtn: true,
        title: "",
        module: "Gmail"
    }


    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("gmail_inp_mcount"), className: "settings_label"},
            { tag: "select", id: "news_count", className: "settings_control",
              options: [
                { value:"3", text: "3"},
                { value:"5", text: "5"},
                { value:"8", text: "8"},
                { value:"10", text: "10"},
                { value:"12", text: "12"},
                { value:"15", text: "15"},
                { value:"20", text: "20"}
              ]
            }, 
            { tag: "input", type: "button", value: loc.text("btn_set"), events: {onclick: "setNewsCount()"}, className: "settings_control"}
          ]
        },
 
        { tag: "div", className: "settings_section",
          childs: [ 
            { tag: "span", innerHTML: loc.text("gmail_inp_account"), className: "settings_label"},
            { tag: "input", id: "select_email", type: "text", size: "15", className: "settings_control"} 
          ]},

        { tag: "div", className: "settings_section",
          childs: [ 
            { tag: "span", innerHTML: loc.text("gmail_inp_pwd"), className: "settings_label"},
            { tag: "input", id: "select_password", type: "password", size: "15", className: "settings_control"} 
          ]},

        { tag: "div", className: "settings_section", align: "center",
          childs: [ 
            { tag: "input", type: "button", value: loc.text("btn_save"), events: {onclick: "saveProfile()"}} ]}
    ]

    this.domContent = [
        { tag: "div", id: "messages_area", 
          display: false,
          childs: [
            { tag: "div", 
              style: { padding: "0 0 0 30px", height: "24px", background: "url(widgets/gmail/ico.gif) no-repeat 0 0"},
              childs: [
                { tag: "span", id: "mail_total" },
                { tag: "input", type: "checkbox", 
                  style: { margin: "0 0 0 16px"},
                  events: {onclick: "switchMailsContent()"}, id: "switcher"}
              ]},
            { tag: "div", id: "mail_list"}
          ]
        },
        { tag: "div", id: "config_note", 
          style: { paddingLeft: "30px", background: "url(widgets/gmail/ico.gif) no-repeat 0 0"},
          innerHTML: loc.text("gmail_msg_not_configured")},
        { tag: "div", className: "menu_panel", id: "msg_no_new_mails", innerHTML: loc.text("gmail_msg_no_mails"), display: false}

    ]

    this.defaultProfile["title"] = "";
    this.defaultProfile["email"] = "";
    this.defaultProfile["password"] = "";
    this.defaultProfile["newsCount"] = "8";



    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.buildDomModel(this.elements.content, this.domContent);

        this.elements.news_count.value = this.profile.newsCount;
        this.elements.select_email.value = this.profile.email;
        this.elements.select_password.value = this.profile.password;

        if(this.profile["email"] != "" && this.profile["password"] != "") {
            this.hideElement("config_note");
        }
    }


    this.onOpen = function() {
        if(trim(this.profile.title) == "") {
            this.profile.title = loc.text("gmail_title");
        }
        this.setTitle(this.profile.title);
        kernel.processTimer(this.id, 600*1000);
    }


    this.timerHandler = function() {
        this.refresh();
    }


    this.saveProfile = function() {
        this.profile.email = "" + trim(this.elements.select_email.value).split("@gmail.com")[0];
        this.profile.password = trim(this.elements.select_password.value);
        this.save();
        this.hideElement("messages_area");
        this.refresh();
    }


    this.setNewsCount = function() {
        this.profile.newsCount = this.elements.news_count.value;
        this.save();
        this.renderMessages();
    }


    var isLoading = false;

    this.refresh = function() {
        this.hideElement("msg_no_new_mails");
        if(this.profile["email"] != "" && this.profile["password"] != "") {
            if(!isLoading) {
                isLoading = true;
                this.setTitle(loc.text("msg_loading"));
                this.hideElement("config_note");
                xmlRequest.send("https://mail.google.com/mail/feed/atom/", this, "showMail", {login: this.profile.email, password: this.profile.password});
            }
        } else {
            this.showElement("config_note");
        }
    }

    this.showMail = function(response) {
        isLoading = false;
        if(response.responseXML && response.responseXML.documentElement) {
            var te = response.responseXML.documentElement.getElementsByTagName("TITLE");

            if(!(te[0] && te[0].firstChild.nodeValue == "Unauthorized")) {
                try {
                    this.data = XMLParser.xml2hash(response.responseXML.documentElement, "entry");
                    this.fullCount = response.responseXML.documentElement.getElementsByTagName("fullcount")[0].firstChild.nodeValue;
                    
                    if(this.data) {
                        this.renderMessages();
                        return true;
                    } 
                } catch(e) {}
            } 
            
        } 
        this.setConfigState();
    }


    this.setConfigState = function() {
        this.setTitle(this.profile.title);
        this.showElement("config_note");
        this.hideElement("messages_area");
    }


    this.switchMailsContent = function() {
        if(this.data.items) {
            var count = Math.min(this.data.items.length, this.profile.newsCount);
            for(var i=0; i<count; i++) {
                if(this.elements.switcher.checked) {
                    this.showElement("mail_content" + i);
                } else {
                    this.hideElement("mail_content" + i);
                }
            }
        }
    }


    this.renderMessages = function() {
        this.elements.title.innerHTML = '';
        this.buildDomModel(this.elements.title, 
                           createButtonDom(this.profile.title, "openInbox()"));
        if(this.data && this.data.items.length > 0) {
            this.hideElement("msg_no_new_mails");
            this.hideElement("config_note");
            this.showElement("messages_area");
            this.elements.mail_list.innerHTML = '';

            this.elements.mail_total.innerHTML = '<b>' + loc.text("gmail_msg_total", this.fullCount) + '</b>';
            this.elements.switcher.checked = false;


            var count = Math.min(this.data.items.length, this.profile.newsCount);

            for(var i=0; i<count; i++) {
                try {
                    if(this.data.items[i].author) {
                        var from = this.data.items[i].author["name"] ? this.data.items[i].author["name"] : this.data.items[i].author["email"];
                    } else {
                        var from = "[...]";
                    }
                    var subj = this.data.items[i].title ? this.data.items[i].title : "[...]";
                    var content = this.data.items[i].summary ? this.data.items[i].summary : "[...]";
                    this.buildDomModel(this.elements.mail_list, 
                        { tag: "div", className: "menu_panel",
                          childs: [
                            { tag: "a", sysHref: this.data.items[i].link.href, target: "_blank",
                              innerHTML: "<b>" + from + "</b> - " + subj },
                            { tag: "div", id: "mail_content"+i, className: "note", display: false,
                              innerHTML: content }
                          ]
                        });
                } catch(e) {}
            }
        } else {
            this.showElement("msg_no_new_mails");
        }
    }


    this.openInbox = function() {
        window.open("http://mail.google.com/mail");
    }

}
Gmail.prototype = new Widget();