function GoogleVideo() {
    this.init();

    this.cfg = {
        title: "",
        module: "GoogleVideo"
    };


    this.channels = [
    	{text:"Popular", value:"http://video.google.com/videofeed?type=top100new&num=10"},
		{text:"Featured", value:"http://video.google.com/videofeed?type=search&q=is:forsale&so=1&num=10"},
		{text:"Comedy", value:"http://video.google.com/videofeed?type=search&q=genre:comedy&so=1&num=10"},
		{text:"Music", value:"http://video.google.com/videofeed?type=search&q=type:music_video&so=1&num=10"},
		{text:"TV Shows", value:"http://video.google.com/videofeed?type=search&q=type:tvshow&so=1&num=10"},
		{text:"Sports", value:"http://video.google.com/videofeed?type=search&q=type:sports%20OR%20genre:sports&so=1&num=10"},
		{text:"Education", value:"http://video.google.com/videofeed?type=search&q=genre:educational&so=1&num=10"}
    ];


    this.defaultProfile["title"] = "";
    this.defaultProfile["channel"] = "0";
    this.defaultProfile["count"] = "6";

    var isLoading = false;
    var req = null;
    var content = null;
    var itemsCount = 10;

    var sel_count_options = [];
    for(var i=1; i<=itemsCount; i++) {
        sel_count_options.push({value: i, text: " " + i + " "});
    }

    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("googlevideo_inp_channel"), className: "settings_label"},
            { tag: "select", id: "inp_channel", events: {onchange: "setChannel()"}, className: "settings_control",
              options: this.channels }
          ]},

        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("googlevideo_inp_count"), className: "settings_label"},
            { tag: "select", id: "inp_count", events: {onchange: "setCount()"}, className: "settings_control",
              options: sel_count_options }
          ]}
    ]



    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.elements["inp_channel"].selectedIndex = this.profile.channel;
        this.elements["inp_count"].value = this.profile.count;
    }


    this.setChannel = function() {
        if(isLoading) {
            this.elements["inp_channel"].selectedIndex = this.profile.channel;
        } else {
            var c = this.elements["inp_channel"].selectedIndex;
            if(c != this.profile.channel) {
                this.profile.channel = this.elements["inp_channel"].selectedIndex;
                this.save();
                req = null;
                isLoading = false;
                this.refresh();
            }
        }
    }


    this.setCount = function() {
        var c = this.elements["inp_count"].value;
        if(c != this.profile.count) {
            this.profile.count = c;
            this.save();
            this.renderContent();
        }
    }


    this.onOpen = function() {
        this.refresh();
    }




    this.refresh = function() {
        if(!isLoading) {
            this.setTitle(loc.text("msg_loading"));
            req = xmlRequest.send(this.channels[this.profile.channel].value, this, "parseContent");
            isLoading = true;
        }
    }


    this.parseContent = function(response) {
        isLoading = false;
        if(response.responseXML && response.responseXML.documentElement) {
            content = XMLParser.xml2hash(response.responseXML.documentElement);
//            varpw(content);
        } else {
            content = null;
        }
        this.renderContent();
    }

    

    this.renderContent = function() {
        if(content) {
            if(this.profile.title != "") {
                this.setTitle(this.profile.title);
            } else {
                this.setTitle(content.title);
            }
            var l = Math.min(content.items.length, this.profile.count);
            var c = "";
            var st = "";

            for(var i=0; i<l; i++) {
                st = i % 2 == "1" ? "background: #F0F0F0;" : "";
                var lnk = content.items[i]["link"];

                c += "<tr style='"+st+"'>"+
                     "<td valign=top style='padding: 4px;'><a href='"+lnk+"' target=_blank><img border=0 width=80 src='"+ content.items[i]["media:group"]["media:thumbnail"].url +"'/></a></td>"+
                     "<td valign=top style='padding: 4px;'><a href='"+lnk+"' target=_blank><b>"+content.items[i]["media:group"]["media:title"]+"</b></a>"+
                     "<p>" +content.items[i]["media:group"]["media:description"] + "</td>" +
                     "</tr>";
            }
            this.elements["content"].innerHTML = "<table class='plan_table'>" + c + "</table>";
        } else {
            this.setTitle(loc.text("msg_error"));
        }
    }
 
}
GoogleVideo.prototype = new Widget();