function HTMLBox() {
    this.init();

    this.cfg = {
        hasRefreshBtn: false,
        title: loc.text("htmlbox_title"),
        module: "HTMLBox"
    }

    this.defaultProfile["title"] = loc.text("htmlbox_title");
    this.defaultProfile["html"] = "";


    this.onBuildInterface = function() {
        this.buildDomModel(this.elements["settings"], [
          { tag: "div", className: "settings_section",
            childs: [
              { tag: "span", innerHTML: loc.text("htmlbox_inp_source"), className: "settings_label"},
              { tag: "br"},
              { tag: "textarea", id: "inp_source",
                style: { overflow: "auto", width: "98%", height: "120px"} }
            ]},

          { tag: "div", className: "settings_section",
            childs: [
              { tag: "input", type: "button", value: loc.text("btn_ok"), 
                events: { onclick: "onChangeSource()" }, className: "settings_control"}
            ]}
       ]);
    }



    this.onChangeSource = function() {
        var t = this.elements["inp_source"].value;
        this.renderHTML(t);
        this.profile["html"] = t.jsEscape();
        this.save();
        this.hideSettings();
    }


    this.onOpen = function() {
        this.setTitle(this.profile["title"]);
        this.elements["input_title"].value = this.profile["title"];
        this.elements["content"].style.textAlign = "center";

        var html = this.profile["html"].jsUnescape();
        this.elements["inp_source"].value = html;
        this.elements["inp_source"].onfocus = function() {
            this.select();
        }

        this.renderHTML(html);
    }



    this.setIcon = function(html) {
        var url = html.substring(html.indexOf('http://'));
    	var favIcon = url.substring(0, url.indexOf('/', 8));
        if(favIcon == "") {
            favIcon = "http://" + baseUrl + "widgets/htmlbox/ico.gif";
        } else {
            favIcon += "/favicon.ico";

        }
    	this.elements["icon"].setAttribute("src", favIcon);
    }



    this.renderHTML = function(html) {
        this.setIcon(html);
        if(!(html && html.length)) {
            this.elements["content"].innerHTML = "<div style='text-align: left'>" + loc.text("htmlbox_help") + "</div>";
        } else {
            if(html.indexOf('<script') != -1) {
                this.elements["content"].innerHTML = "";
                this.buildDomModel(this.elements["content"], 
                    { tag: "iframe", 
                      id: "iframe",
                      scrolling: "no",
                      border: "0",
                      frameBorder: "0" });

                this.elements["iframe"].src = "ewloader.php?wid=" + this.id + "&code=" + encodeURIComponent(html);
            } else {
                if (html.match(/^http:\/\/.*\.(jpg|png|gif|bmp)$/)) { 
                    html = '&nbsp;<img src="' + html + '" />';
                }
                this.elements["content"].innerHTML = html;
            }
        }
    }


    this.updateIframeSize = function(w, h) {
        this.elements["iframe"].style.width = w + "px";
        this.elements["iframe"].style.height = w + "px";
    }


}
HTMLBox.prototype = new Widget();