function HTMLWidget() {
    this.init();

    this.cfg = {
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        title: "",
        module: "HTMLWidget"
    }

    this.defaultProfile["id"] = "";


    this.onOpen = function() {
        this.setTitle(loc.text("msg_loading"));
        request.send({ act: "get_data", id: this.profile["id"]}, this);
    }



    this.renderHTML = function(html) {
    	if(html.indexOf('<script') != -1) {
            this.elements["content"].innerHTML = "";
            this.buildDomModel(this.elements["content"], 
                { tag: "iframe", 
                  id: "iframe",
                  scrolling: "no",
                  border: "0",
                  frameBorder: "0" });

            this.elements["iframe"].src = "ewloader.php?wid=" + this.id + "&code=" + encodeURIComponent(html);
        } else {
            this.elements["content"].innerHTML = html;
        }
    }


    this.updateIframeSize = function(w, h) {
        this.elements["iframe"].style.width = w + "px";
        this.elements["iframe"].style.height = w + "px";
    }



    this.dispatchMsg = function(msg) {
        switch(msg.status) {
            case "data":
                this.elements["content"].style.textAlign = "center";
                this.setTitle(msg.data.title);
                this.renderHTML(msg.data.source);
                this.elements["icon"].setAttribute("src", "var/hwicons/" + msg.data.icon);
                break;

            case "error":
                this.elements["content"].innerHTML = loc.text("msg_error");
                this.setTitle(loc.text("msg_error"));
                break;
        }
    }

}
HTMLWidget.prototype = new Widget();