function PopMail() {
    this.init();


    this.cfg = {
        hasSettingsBtn: true,
        title: loc.text("popmail_title"),
        module: "PopMail"
    }


    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_mcount")},
            { tag: "select", id: "inp_count", className: "settings_control",
              options: [
                { value:"3", text: "3"},
                { value:"5", text: "5"},
                { value:"8", text: "8"},
                { value:"10", text: "10"},
                { value:"12", text: "12"},
                { value:"15", text: "15"},
                { value:"20", text: "20"}
              ]
            },
            { tag: "input", type: "button", value: loc.text("btn_set"), events: {onclick: "setItemsCount()"}, className: "settings_control"}
          ]
        },

        { tag: "div", className: "settings_section", align: "center",
          innerHTML: "<b>"+ loc.text("popmail_asettings") + "</b>"},

        { tag: "div", className: "settings_section",
           childs: [ 
             { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_inp_login")},
             { tag: "input", id: "select_login", type: "text", size: "15", className: "settings_control"} 
           ]},

        { tag: "div", className: "settings_section",
           childs: [ 
             { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_inp_pwd")},
             { tag: "input", id: "select_password", type: "password", size: "15", className: "settings_control"} 
           ]},

        { tag: "div", className: "settings_section",
          childs: [
            { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_inp_protocol")},
            { tag: "select", id: "select_protocol", className: "settings_control",
              events: {onchange: "updatePort()"},
              options: [
                { value: "pop3", text: "POP3" },
                { value: "imap", text: "IMAP4" },
              ]
            }
          ]
        },

        { tag: "div", className: "settings_section",
          childs: [ 
            { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_inp_secure")},
            { tag: "input", type: "checkbox", id: "select_secure",  
              events: {onchange: "updatePort()"}, 
              className: "settings_control"} 
          ]},

        { tag: "div", className: "settings_section",
          childs: [ 
            { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_inp_server")},
            { tag: "input", id: "select_server", type: "text", size: "15", className: "settings_control"} 
          ]},

        { tag: "div", className: "settings_section",
          childs: [ 
            { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_inp_port")},
            { tag: "input", id: "select_port", type: "text", size: "5", value: "110"} 
          ]},

        { tag: "div", className: "settings_section", align: "center",
          childs: [ 
            { tag: "input", type: "button", value: loc.text("btn_save"), events: {onclick: "saveProfile()"}} 
          ]}
    ]

    this.domContent = [
        { tag: "div",
          style: { width: "100%", zoom: "1", overflow: "hidden" },
          childs: [
            { tag: "div", className: "menu_panel", id: "messages", display: false,
              childs: [
                { tag: "div", className: "menu_panel", 
                  style: { paddingLeft: "30px", background: "url(widgets/aolmail/ico.gif) no-repeat 0 0"},
                  childs: [
                    { tag: "b", html: loc.text("popmail_total") },
                    { tag: "span", id: "total_messages"}
                  ]},
                { tag: "div", id: "mail_list"}
              ]}
          ]},

        { tag: "div", className: "menu_panel", id: "loading_note", display: false,
          style: { paddingLeft: "30px", background: "url(widgets/popmail/ico.gif) no-repeat 0 0"},
          innerHTML: loc.text("msg_loading")},

        { tag: "div", className: "menu_panel", id: "config_note", display: false,
          style: { paddingLeft: "30px", background: "url(widgets/popmail/ico.gif) no-repeat 0 0"},
          innerHTML: loc.text("popmail_msg_not_configured")},

        { tag: "div", className: "menu_panel", id: "no_messages_note", display: false,
          style: { paddingLeft: "30px", background: "url(widgets/popmail/ico.gif) no-repeat 0 0"},
          innerHTML: loc.text("popmail_msg_no_mails")}
    ]

    this.defaultProfile["login"] = "";
    this.defaultProfile["password"] = "";
    this.defaultProfile["protocol"] = "pop3";
    this.defaultProfile["secure"] = "0";
    this.defaultProfile["server"] = "";
    this.defaultProfile["port"] = "110";

    this.defaultProfile["title"] = loc.text("popmail_title");
    this.defaultProfile["mcount"] = "8";


    this.isLoading = false;

    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.buildDomModel(this.elements.content, this.domContent);

        this.elements.select_login.value = this.profile.login;
        this.elements.select_password.value = this.profile.password;
        this.elements.select_protocol.value = this.profile.protocol;
        this.elements.select_secure.checked = this.profile.secure == 1;
        this.elements.select_server.value = this.profile.server;
        this.elements.select_port.value = this.profile.port;
        this.elements.inp_count.value = this.profile.mcount;

        this.setTitle(this.profile.title);
    }



    this.onOpen = function() {
        if(this.isProfileEmpty()) {
            this.setContent("config_note");
        } else {
            this.refresh();
        }
//        kernel.processTimer(this.id, 30000);
    }


    this.updatePort = function() {
        this.elements["select_port"].value = 
            (this.elements["select_protocol"].value == "pop3") 
            ?
            (this.elements["select_secure"].checked ? "995" : "110")
            :
            (this.elements["select_secure"].checked ? "993" : "143")
    }


    this.isProfileEmpty = function() {
        return this.profile.login == "" || this.profile.password == "" || this.profile.server == "";
    }


    this.setContent = function(section) {
        var sections = ["config_note", "loading_note", "messages", "no_messages_note"];
        for(var i = 0; i<sections.length; i++) {
            if(section == sections[i]) {
                this.showElement(sections[i]);
            } else {
                this.hideElement(sections[i]);
            }
        }
    }


    this.saveProfile = function() {
        this.profile.login = trim(this.elements.select_login.value);
        this.profile.password = trim(this.elements.select_password.value); 
        this.profile.protocol = this.elements.select_protocol.value;
        this.profile.secure = this.elements.select_secure.checked ? 1 : 0;
        this.profile.server = trim(this.elements.select_server.value);
        this.profile.port = trim(this.elements.select_port.value);

        if(this.isProfileEmpty()) {
            this.setContent("config_note");
        } else {
            this.save();
            this.refresh();
        }
    }


    this.setItemsCount = function() {
        var c = this.elements["inp_count"].value;
        if(this.profile.mcount != c) {
            this.profile.mcount = c;
            this.save();
            this.renderMessages();
        }
    }




    this.timerHandler = function() {
        if(this.isProfileEmpty()) {
            this.setContent("config_note");
        } else {
            this.refresh();
        }
    }


    this.req = null;
    this.timerId = null;

    this.refresh = function() {
        if(!this.isProfileEmpty() && !this.isLoading) {
            this.isLoading = true;
            this.setContent("loading_note");
            var protocol = "/" + this.profile.protocol + 
                           ((this.profile.secure == 1) ? "/ssl" : "") +
                           "/novalidate-cert";

            this.req = request.send({ login: this.profile.login,
                                      password: this.profile.password,
                                      protocol: protocol,
                                      server: this.profile.server,
                                      port: this.profile.port }, this);
            var self = this;
            var f = function() {
                updateLoadingIcon(-1);
                self.req.onreadystatechange = function() {};
                self.isLoading = false;
                self.setContent("config_note");
            }
            this.timerId = setTimeout(f, 30000);
        }
    }



    this.renderMessages = function() {
        if(this.data) {
            this.setContent("messages");        
            this.elements.total_messages.innerHTML = "<B>" + this.totalMessages + "<B>";
            this.elements.mail_list.innerHTML = '';
            var cnt = Math.min(this.data.length, this.profile.mcount);
            for(var i=0; i<cnt; i++) {
                try {
                    this.buildDomModel(this.elements.mail_list,
                                       { tag: "div", className: "menu_panel", 
                                         innerHTML: "<B>" + this.data[i].from + "</B>",
                                         childs: [
                                           { tag: "div", className: "note", innerHTML: this.data[i].subj.wordWrap(20) }
                                         ]
                                       });
                } catch(e) {}
            }
        }
    }


    this.dispatchMsg = function(msg) {
        clearTimeout(this.timerId);
        this.isLoading = false;
        switch(msg.status) {
            case "empty":
                this.setContent("no_messages_note");
                break;
            case "data":
                this.data = msg.data;
                this.totalMessages = msg.total;
                this.renderMessages();
                break;
            case "error":
                this.setContent("config_note");
                break;
        }
    }

}
PopMail.prototype = new Widget();