function Profiler() {

    this.data = {};

    this.cfg = {
        module: "Profiler",
        hasProfile: false
    }



    this.registerWidget = function(widget) {
        var profile = clone(widget.defaultProfile);

        if(this.data[widget.id]) {
            for(var i in this.data[widget.id]) {
                if(profile[i] != undefined) {
                    profile[i] = this.data[widget.id][i];
                }
            }
        } 
    
        widget.profile = profile;
    }


    this.saveProfile = function(widget) {
        var wkey = widget.id;//getSignature();
        if(widget.profile) {
            act = this.data[wkey] ? "update" : "create";
            request.send({w: widget.cfg.module, act: act, wkey: wkey, data: escape(toCode(widget.profile))}, this, widget.cfg.saveMethod);
        } else {
            request.send({act: "delete", wkey: wkey}, this);
        }
        this.data[wkey] = widget.profile;
    }


 
    this.loadProfile = function() {
        request.send({act: "load_data"}, this); 
    }

    this.onLoad = function() {}

    this.dispatchMsg = function(msg) {
        if(msg.status == "loaded") {
            profiler.data = {};
            for(var i in msg.data) {
                try {
                    profiler.data[i] = toValue(unescape(msg.data[i]));
                } catch(e) {
                    profiler.data[i] = {}
                }
            }
            profiler.onLoad();
        }
    }
}