function Rss() {
    this.init();

    this.cfg = {
        title: loc.text("rss_title"),
        module: "Rss"
    }

    this.defaultProfile["cnt"] = 10;
    this.defaultProfile["opend"] = 0;
    this.defaultProfile["url"] = "";
    this.defaultProfile["icon"] = "";
    this.defaultProfile["period"] = 600;
    this.defaultProfile["md5"] = [];



    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", className: "settings_label", innerHTML: loc.text("rss_inp_ncount")},
            { tag: "select", id: "news_count", className: "settings_control",
              options: [
                { value:"3", text: "3"},
                { value:"5", text: "5"},
                { value:"8", text: "8"},
                { value:"10", text: "10"},
                { value:"12", text: "12"},
                { value:"15", text: "15"},
                { value:"9999", text: loc.text("rss_all")}
              ]
            },
            { tag: "input", type: "button", value: loc.text("btn_set"), events: {onclick: "setNewsCount()"}}
          ]
        },
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", className: "settings_label", innerHTML: loc.text("rss_inp_refresh")},
            { tag: "select", id: "period", className: "settings_control",
              options: [
                { value:"120", text: loc.text("rss_p120")},
                { value:"300", text: loc.text("rss_p300")},
                { value:"600", text: loc.text("rss_p600")},
                { value:"1200", text: loc.text("rss_p1200")},
                { value:"1800", text: loc.text("rss_p1800")},
                { value:"3600", text: loc.text("rss_p3600")},
                { value:"10800", text: loc.text("rss_p10800")}
              ]
            },
            { tag: "input", type: "button", value: loc.text("btn_set"), events: {onclick: "setPeriod()"}}
          ]},
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", className: "settings_label", innerHTML: loc.text("rss_inp_open_to")},
            { tag: "input", type: "checkbox", id: "opend",
              events: { onclick: "setOpenDirectly()"}
            }
          ]},
        { tag: "div", className: "settings_section",
          childs: [ 
            { tag: "span", innerHTML: loc.text("rss_inp_url"), className: "settings_label"},
            { tag: "input", id: "select_url", type: "text", size: "15", className: "settings_control"},
            { tag: "input", type: "button", value: loc.text("btn_go"), events: {onclick: "setUrl()"}}
          ]}
    ]


    this.lastRefresh = null
    this.isLoading = false;
    this.isInReader = false;


    this.onBuildInterface = function() {
        this.elements["settings"].innerHTML = "";
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.elements.period.value = this.profile.period;
        this.elements.news_count.value = this.profile.cnt;
        this.elements.opend.checked = this.profile.opend == 1;
        this.elements.content.style.padding = "6px";
        this.elements["select_url"].value = this.profile["url"];
    }


    this.setUrl = function() {
        var url = trim(this.elements["select_url"].value);
        if(url != "") {
            if(url.indexOf("http://") == -1) {
                url = "http://" + url;
            }
            if(this.profile["url"] != url) {
                this.profile["url"] = url;
                this.save();
                this.iconLoaded = false;
                kernel.stopTimer(this.id);
                kernel.processTimer(this.id, this.profile.period * 1000, true);
                this.refresh();
            }
        }
        this.hideSettings();
    }

    this.setOpenDirectly = function() {
        this.profile.opend = this.elements.opend.checked ? 1 : 0;
        this.save();
    }


    this.setNewsCount = function() {
        this.profile.cnt = this.elements.news_count.value;
        this.save();
        this.showChannelTitle();
        this.renderChannel();
    }

    this.setPeriod = function() {
        this.profile.period = this.elements.period.value;
        kernel.stopTimer(this.id);
        kernel.processTimer(this.id, this.profile.period * 1000, true);
        this.save();
    }


    this.onOpen = function() {
        kernel.processTimer(this.id, this.profile.period * 1000);
    }


    this.timerHandler = function() {
        if(!this.isInReader) {
            this.refresh();
        }
    }

    this.refresh = function() {
        var date = new Date();
        this.lastRefresh = date.getSeconds();
        this.setTitle(loc.text("msg_loading"));

        var wid = this.id;
        var iconEl = this.elements.icon;
        xmlRequest.send(this.profile.url, this, "showChannel");
        this.isLoading == true;
    }


    this.openChannel = function(wid, feedId) {
        if(this.profile.opend == 1) {
            window.open(this.data.items[feedId]["link"]);
        } else {
            this.isInReader = true;
            rssreader.channelLastRefresh = this.lastRefresh;
            rssreader.elements["icon"].src = this.elements["icon"].src;
            rssreader.openChannel(wid, feedId);
        }
    }


    this.getItemsCount = function() {
        return Math.min(this.data.items.length, this.profile.cnt);
    }


    this.processItemRead = function(itemIdx) {
        this.data.items[itemIdx].isRead = 1;
        this.profile["readed"][itemIdx] = 1;
        this.showChannelTitle();
        this.elements["item_" + itemIdx].className = "rss_box_item_visited";
    }

    this.processItemUnread = function(itemIdx) {
        this.data.items[itemIdx].isRead = 0;
        this.profile["readed"][itemIdx] = 0;
        this.showChannelTitle();
        this.elements["item_" + itemIdx].className = "rss_box_item";
    }


    this.getReadedItemsCount = function() {
        var count = this.getItemsCount();
        var res = 0;
        for(var i=0; i<count; i++) {
            if(this.data.items[i].isRead == 1) {
                res ++;
            }
        }
        return res;
    }


    this.showChannelTitle = function() {
        if(this.data) {
            var count = this.getItemsCount();
            var readed = this.getReadedItemsCount();

            this.elements.title.innerHTML = '';
            this.buildDomModel(this.elements.title, 
                { tag: "a", href: "void",
                  innerHTML: this.data.title.substr(0,25),
                  events: { onclick: "openSite()" } });

            if(count > readed) {
                this.buildDomModel(this.elements.title, 
                    { tag: "span", 
                      innerHTML: " &nbsp;(" + (count - readed) + ")" });
            }
        }
    }


    this.lastFeed = {
        url: null,
        time: null
    }


    this.getItemMd5 = function(idx) {
        var content = this.data.items[idx]["content"] ? this.data.items[idx]["content"] : this.data.items[idx]["description"];
        var str = this.data.items[idx].title + content;
        return crc32(str);
    }


    this.showChannel = function(response) {
        this.isLoading == false;
        if(response.responseXML && response.responseXML.documentElement) {
            this.data = XMLParser.xml2hash(response.responseXML.documentElement);
            var newMd5 = [];
            if(this.data) {
                var count = this.data.items.length;
                var l = this.profile["md5"].length;

                for(var i=0; i<count; i++) {
                    var md5 = this.data.items[i]["md5"] = this.getItemMd5(i);
                    var j = this.isReaded(md5);

                    if(j != null) {
                        this.data.items[i].isRead = 1;
                        newMd5.push(md5);
                        l--;
                    }
                }

                this.profile["md5"] = newMd5;
                if(l != 0) {
                this.save();
            }
            }

            this.renderChannel();
            this.showChannelTitle();
        } else {
            this.showError();
        }
    }




    this.iconLoaded = false;

    this.renderChannel = function() {
        if(this.data) {
            if(!this.iconLoaded) {

                var icons = [
                    this.profile.icon,
                    getDir(this.data.siteUrl) + "/favicon.ico",
                    getDomain(this.data.siteUrl) + "/favicon.ico",
                    getDir(this.profile.url) + "/favicon.ico",
                    getDomain(this.profile.url) + "/favicon.ico"
                ];

                loadIcon(this.elements["icon"], icons);
                this.iconLoaded = true;
            }

            var count = this.getItemsCount();
            this.elements.content.innerHTML = '';
            for(var i=0; i<count; i++) {
                this.buildDomModel(this.elements.content, 
                                   { tag: "div", className: "rss_box_item" + ( (this.data.items[i].isRead == 1) ? "_visited" : ""),
                                     innerHTML: this.data.items[i].title.wordWrap(38),
                                     events: { onclick: "openChannel("+this.id+","+i+")" },
                                     id: "item_" + i });
                                                   
            }
        } else if (!this.isLoading) {
            this.showError();
        }
    }


    this.showError = function() {
        this.elements.title.innerHTML = loc.text("rss_msg_error");
    }

    
    this.openSite = function() {
        if(this.data) {
            window.open(this.data.siteUrl);
        }
    }


    this.onClose = function() {
        if(rssreader.widgetId && rssreader.widgetId == this.id) {
            rssreader.close();
        }
    }


    // Read/unread hash
    this.isReaded = function(md5) {
        for(var i=0; i<this.profile["md5"].length; i++) {
            if(this.profile["md5"][i] == md5) {
                return i;
            }
        }
        return null;
    }


    this.setReaded = function(idx) {
        var md5 = this.data.items[idx].md5;
        var i = this.isReaded(md5);
        if(i == null) {
            this.profile["md5"].push(md5);
        }
    }


    this.unsetReaded = function(idx) {
        var md5 = this.data.items[idx].md5;
        var i = this.isReaded(md5);
        if(i != null) {
            delete(this.profile["md5"][i]);
        }
    }



    this.processItemRead = function(itemIdx) {
        this.data.items[itemIdx].isRead = 1;
        this.setReaded(itemIdx);
        this.showChannelTitle();
        this.elements["item_" + itemIdx].className = "rss_box_item_visited";
    }

    this.processItemUnread = function(itemIdx) {
        this.data.items[itemIdx].isRead = 0;
        this.unsetReaded(itemIdx);
        this.showChannelTitle();
        this.elements["item_" + itemIdx].className = "rss_box_item";
    }


    this.getReadedItemsCount = function() {
        var count = this.getItemsCount();
        var res = 0;
        for(var i=0; i<count; i++) {
            if(this.data.items[i].isRead == 1) {
                res ++;
            }
        }
        
        return res;
    }
 
}
Rss.prototype = new Widget();