function RssReader() {
    this.init();

    this.cfg = {
        hasSizeBtn: false,
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        hasDrag: false,
        hasProfile: false,
        title: loc.text("rssreader_title"),
        module: "RssReader",
        uniqueId: SYS_WIDGETS_ID + 5
    }

    this.domContent = {
        tag: "table", 
        style: { width: "100%" },
        childs: [
          { tag: "tr",
            childs: [
              { tag: "td", width: "35%",
                childs: [
                  createButtonDom(loc.text("rssreader_read_all"), "readAll()", "widgets/rssreader/img/folder_open.gif"),
                  { tag: "span", html: " &nbsp; &nbsp; &nbsp; "},
                  createButtonDom(loc.text("rssreader_unread_all"), "unReadAll()", "widgets/rssreader/img/folder_close.gif")
                ]},
              { tag: "td", 
                childs: [{ tag: "div", id: "channelTitle"}]}
            ]},
          { tag: "tr",
            childs: [
              { tag: "td", width: "35%",
                childs: [
                  { tag: "div", id: "menu", className: "listBox", style: {width: "auto", height: "340px"}}
                ]},
              { tag: "td",
                childs: [
                  { tag: "div", id: "view", className: "listBox", style: {width: "auto", height: "340px"}}
                ]}
            ]}
        ]}


    this.channelLastRefresh = null;

    this.onBuildInterface = function() {
        this.elements["content"].style.height = "390px";
        this.buildDomModel(this.elements.content, this.domContent);
        this.setTitle(this.cfg.title);
    }


    this.buildChannel = function() {
//        this.elements.channelTitle.innerHTML = "<h1><a target=\"_blank\" href=\""+this.data.LINK+"\">"+this.data.title+"</a></h1>";
        this.elements.channelTitle.innerHTML = "<h1>"+this.data.title+"</h1>";
        this.elements.menu.innerHTML = "";
        this.elements.view.innerHTML = "";
        var count = kernel.getWidget(this.widgetId).getItemsCount();
        for(var i=0; i< count; i++) {
            this.buildDomModel(this.elements.menu, 
                               [{ tag: "div", className: "menu_panel",
                                  childs: [
                                    { tag: "a", 
                                      innerHTML: this.data.items[i].title.wordWrap(38),
                                      id: "menuItem"+i,
                                      href: "void", 
                                      events: {onclick: "readFeed("+i+")"}, 
                                      className: "listItem" + (this.data.items[i].isRead == 1 ? "Visited" : "") }
                                  ]
                                },
                                { tag: "hr", width: "100%"}
                               ]);
        }
    }


    
    this.readFeed = function(feedId) {
        this.elements.view.innerHTML = "";
        var content = this.data.items[feedId]["content"] ? this.data.items[feedId]["content"] : this.data.items[feedId]["description"];
        var url = this.data.items[feedId]["link"]["href"] ? this.data.items[feedId]["link"]["href"] : this.data.items[feedId]["link"];
        this.buildDomModel(this.elements.view, [
            { tag: "div", className: "float_panel",
              childs: [
                { tag: "div", className: "float_left",
                  display: (feedId > 0),
                  childs: [
                    createButtonDom(false, "readFeed("+(feedId-1)+")", "widgets/rssreader/img/previous.gif", "readPrev")
                  ]},
                { tag: "div", className: "float_right",
                  display: (feedId < kernel.getWidget(this.widgetId).getItemsCount() - 1),
                  childs: [
                    createButtonDom(false, "readFeed("+(feedId+1)+")", "widgets/rssreader/img/next.gif", "readNext")
                  ]}
              ]},

            { tag: "hr", width: "100%"},

            { tag: "div", className: "menu_panel",
              innerHTML: "<p><a href='" + url + "' class='rssreader_item_title' target=_blank>" + this.data.items[feedId].title + "</a>"+
                         "<p>"+(content ? content : "")
            }
          ]);


        if(kernel.getWidget(this.widgetId)) {
            kernel.getWidget(this.widgetId).processItemRead(feedId);
            kernel.getWidget(this.widgetId).save();
        }
        this.elements['menuItem'+feedId].className = "listItemVisited";

        this.updateTitle();
    }



    this.readAll = function() {
        var count = kernel.getWidget(this.widgetId).getItemsCount();

        for(var i=0; i<count; i++) {
            kernel.getWidget(this.widgetId).processItemRead(i);
        }
        this.buildChannel();

        var w = kernel.getWidget(this.widgetId);
        if(w) {
            w.save();
        }
        this.updateTitle();
    }


    this.unReadAll = function() {
        var count = kernel.getWidget(this.widgetId).getItemsCount();

        for(var i=0; i<count; i++) {
            kernel.getWidget(this.widgetId).processItemUnread(i);
        }
        this.buildChannel();

        var w = kernel.getWidget(this.widgetId);
        if(w) {
            w.save();
        }
        this.updateTitle();
    }



    this.updateTitle = function() {
        if(this.data) {
            var count = kernel.getWidget(this.widgetId).getItemsCount();
            var readed = kernel.getWidget(this.widgetId).getReadedItemsCount()

            this.elements.title.innerHTML = '';

            this.buildDomModel(this.elements.title, 
                { tag: "a", href: "void",
                  innerHTML: this.data.title.substr(0,25),
                  events: { onclick: "openSite()" } });

            if(count > readed) {
                this.buildDomModel(this.elements.title, 
                    { tag: "span", 
                      innerHTML: " &nbsp;(" + (count - readed) + ")" });
            }
        }
    }



    this.openChannel = function(widgetId, feedId) {
        menu.hide();
        this.data = kernel.getWidget(widgetId).data;
        this.widgetId = widgetId;
        this.buildChannel();
        this.elements.icon.src = kernel.getWidget(widgetId).elements.icon.src;
        desktop.showPage('rssreader');
        this.readFeed(feedId);
    }


    this.close = function() {
        if(this.widgetId && kernel.getWidget(this.widgetId)) {
            if(this.channelLastRefresh == kernel.getWidget(this.widgetId).lastRefresh) {
                kernel.getWidget(this.widgetId).isInReader = false;
//                kernel.getWidget(this.widgetId).data = this.data;
            }
        }
        desktop.closeCurrentPage();
    }
 
}
RssReader.prototype = new Widget();