function SendToFriend() {

    this.init();

    this.domSendToFriend = {
        tag: "div", className: "menu_panel",
        childs: [
           { tag: "div", align: "center", id: "send_status",
             style: { fontWeight: "bold" },
             html: loc.text("sendtofriend_status") },
           {tag: "hr"},
           {tag: "table", width: "95%",
             childs: [
               { tag: "tr",
                 childs: [
                   { tag: "td", width: "30%", align: "right",
                     childs: [{ tag: "div", innerHTML: loc.text('sendtofriend_your_name')}]
                   },
                   { tag: "td",
                     childs: [{ tag: "input", type: "text", id: "ed_name", size: "30"}]
                   }
                 ]
               },
               { tag: "tr", childs: [{ tag: "td"},{ tag: "td"}]},
               { tag: "tr",
                 childs: [
                   { tag: "td", width: "30%", align: "right",
                     childs: [{ tag: "div", innerHTML: loc.text('sendtofriend_your_email')}]
                   },
                   { tag: "td",
                     childs: [{ tag: "input", type: "text", id: "ed_email", size: "30" }]
                   }
                 ]
               },
               { tag: "tr", childs: [{ tag: "td"},{ tag: "td"}]},
               { tag: "tr",
                 childs: [
                   { tag: "td", width: "30%", align: "right",
                     childs: [{ tag: "div", innerHTML: loc.text('sendtofriend_friend_email')}]
                   },
                   { tag: "td",
                     childs: [{ tag: "input", type: "text", id: "ed_friend_email", size: "30" }]
                   }
                 ]
               },
               { tag: "tr", childs: [{ tag: "td"},{ tag: "td"}]},
               { tag: "tr",
                 childs: [
                   { tag: "td", width: "30%", align: "right", valign: "top",
                     childs: [{ tag: "div", innerHTML: loc.text('sendtofriend_message')}]
                   },
                   { tag: "td",
                     childs: [{ tag: "textarea", id: "ed_message", rows: "9", cols: "50", style: {width: "90%"} }]
                   }
                 ]
               },
               { tag: "tr", childs: [{ tag: "td", innerHTML: "&nbsp;"},{ tag: "td"}]},

             ]
           },
           { tag: "div", align: "center", id: "btn_send", 
             childs: [
               { tag: "input", 
                 type: "button", value: loc.text('sendtofriend_send'), 
                 events: {onclick: "doSend()"}}
             ]}
        ]}




    this.cfg = {
        hasSizeBtn: false,
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        hasDrag: false,
        hasProfile: false,
        title: "",
        module: "SendToFriend",
        uniqueId: SYS_WIDGETS_ID + 9
    }


    this.onBuildInterface = function() {
        this.setTitle(loc.text('sendtofriend_title'));
        this.elements["content"].style.height = "300px";
        this.buildDomModel(this.elements.content, this.domSendToFriend);
        this.elements["ed_email"].value = auth.user.email;
        this.elements["ed_message"].value = "http://" + baseUrl;
    }


    this.close = function() {
        desktop.closeCurrentPage();
    }

    this.dispatchMsg = function(msg) {
        //alert(msg.status);
        switch(msg.status) {
            case 'ok':
                this.showElement("btn_send");
                this.elements.send_status.innerHTML = '<font color=green>'+loc.text('sendtofriend_send_ok')+'</font>';
                break;
            case 'failed':
                this.elements.send_status.innerHTML = '<font color=red>'+loc.text('sendtofriend_send_failed')+'</font>';
                this.showElement("btn_send");
                break;
        }
    }

    this.doSend = function() {

        var name_val   = this.elements.ed_name.value;
        var email_val  = this.elements.ed_email.value;
        var femail_val = this.elements.ed_friend_email.value;
        var msg_val    = this.elements.ed_message.value;


        //todo: e-mail check
        if (email_val=="") {
           alert(loc.text('sendtofriend_email_empty'));
           this.elements.ed_email.focus();
           return;
        }
        if (checkEmailAddress(email_val)==false) {
           alert(loc.text('sendtofriend_email_invalid'));
           this.elements.ed_email.focus();
           return;
        }

        if (femail_val=="") {
           alert(loc.text('sendtofriend_femail_empty'));
           this.elements.ed_friend_email.focus();
           return;
        }
        if (checkEmailAddress(femail_val)==false) {
           alert(loc.text('sendtofriend_femail_invalid'));
           this.elements.ed_friend_email.focus();
           return;
        }

        this.elements["send_status"].innerHTML = loc.text("msg_processing");
        this.hideElement("btn_send");
        request.send({
                   act    : "send_to_friend",
                   name   : name_val,
                   email  : email_val,
                   femail : femail_val,
                   msg    : msg_val
                   },
                   this);
    }

}
SendToFriend.prototype = new Widget();



// E-MAIL
function checkEmailAddress(value)
{
   //trim(field);
   var goodEmail = value.match(/\b(^(\S+@).+((\.com)|(\.net)|(\.edu)|(\.mil)|(\.gov)|(\.org)|(\..{2,2}))$)\b/gi);

   if (goodEmail)
      return true;
   else
      return false;
}
