function Settings() {
    this.init();

    this.cfg = {
        hasSizeBtn: false,
        hasRefreshBtn: false,
        hasSettingsBtn: false,
        hasDrag: false,
        title: loc.text("settings_title"),
        module: "Settings",
        uniqueId: SYS_WIDGETS_ID + 4
    }


    this.domContent = [
        // select background
        { tag: "div", className: "menu_panel", style: {textAlign: "center"},
          innerHTML: "<h1>"+loc.text("settings_page_bg")+"</h1>",
          childs: [
            createColorSelectDom(loc.text("settings_page_bg_color"), "background", "select_page_color"),

            { tag: "div", className: "menu_panel", innerHTML: loc.text("settings_page_bg_img"), style: {textAlign: "center"}},
            { tag: "div", className: "menu_panel", style: {textAlign: "center"},
              innerHTML: "URL: ",
              childs: [
                { tag: "input", type: "text", size: "60", id: "select_background", value: "http://"},
                { tag: "input", type: "button", value: " Test ",
                  events: { onclick: "testBackgroundImg()" }
                }
              ]},
            { tag: "div", className: "menu_panel", style: {textAlign: "center"},
              childs: [
                { tag: "input", type: "button", value: loc.text("btn_save"),
                  events: { onclick: "saveBackground()" } },
                { tag: "input", type: "button", value: loc.text("btn_delete"),
                  events: { onclick: "delBackground()" } }
              ]}
          ]},
        { tag: "hr" },


        // change password
        { tag: "div", className: "menu_panel", style: {textAlign: "center"},
          innerHTML: "<h1>"+loc.text("settings_change_pwd")+"</h1>",
          childs: [
            { tag: "div", className: "float_panel",
              childs: [
                { tag: "div", className: "float_left",
                  style: { width: "45%", padding: "2px" },
                  childs: [
                    { tag: "div", html: loc.text("settings_inp_old_pwd")},
                    { tag: "div", 
                      childs: [
                        { tag: "input", id: "inp_old_pwd", size: "30",
                          type: "password" }
                      ]},

                    { tag: "div", id: "change_pwd_msg", 
                      style: { marginTop: "12px"}}

                  ]},

                { tag: "div", className: "float_right",
                  style: { width: "45%", padding: "2px" },
                  childs: [
                    { tag: "div", html: loc.text("settings_inp_new_pwd")},
                    { tag: "div", 
                      childs: [
                        { tag: "input", id: "inp_new_pwd", size: "30",
                          type: "password" }
                      ]},

                    { tag: "div", html: loc.text("settings_inp_new_pwd2")},
                    { tag: "div", 
                      childs: [
                        { tag: "input", id: "inp_new_pwd2", size: "30",
                          type: "password" }
                      ]}

                  ]}
              ]},

            { tag: "div", style: { textAlign: "center", marginTop: "6px", height: "25px"},
              childs: [
                { tag: "input", id: "btn_change_pwd",
                  events: { onclick: "changePwd()"},
                  type: "button", value: loc.text("settings_btn_change_pwd") }
              ]}
          ]},
        { tag: "hr" },


        // themes
        { tag: "div", className: "menu_panel", style: { textAlign: "center" },
          innerHTML: "<h1>"+loc.text("settings_themes")+"</h1>",
          childs: [
            { tag: "div", id: "page_themes", className: "section", 
              innerHTML: loc.text("msg_loading"),
              style: { height: "210px", border: "1px solid #999999", overflow: "auto", textAlign: "left", padding: "4px"} }

          ]}
    ]



    this.defaultProfile["background"] = "";



    // Changing password
    this.changePwd = function() {
        if(auth.isLogged()) {
            var p1 = trim(this.elements["inp_new_pwd"].value);
            var p2 = trim(this.elements["inp_new_pwd2"].value);
            var opwd = trim(this.elements["inp_old_pwd"].value);

            if(opwd == auth.user.password) {
                if((p1 == p2) && (p1 != "")) {
                    var opwd = trim(this.elements["inp_old_pwd"].value);
                    request.send({ act: "change_pwd", npwd: p1}, this);
                    this.elements["change_pwd_msg"].innerHTML = loc.text("msg_processing");
                    this.elements["btn_change_pwd"].disabled = true;
                } else {
                    this.elements["change_pwd_msg"].innerHTML = loc.text("settings_new_pwd_wrong");
                }
            } else {
                this.elements["change_pwd_msg"].innerHTML = loc.text("settings_old_pwd_wrong");
            }
        } else {
            alert(loc.text("settings_msg_sign_in"));
        }
    }




    this.onBuildInterface = function() {
        this.elements["content"].style.height = "540px";
        this.setTitle(this.cfg.title);
        this.buildDomModel(this.elements.content, this.domContent);
        this.themeBackground = document.body.style.background;
        this.applyBackgound();
    }


    this.onOpen = function() {
        request.send({ act: "get_themes" }, this);
    }


    this.selectedBackground = false;

    this.testBackgroundImg = function() {
        this.selectedBackground = "url(" + trim(this.elements["select_background"].value) + ") repeat fixed";
        document.body.style.background = this.selectedBackground;
    }

    this.testBackgroundColor = function(color) {
        this.selectedBackground = color;
        document.body.style.background = color;
    }



    this.saveBackground = function() {
        this.profile["background"] = this.selectedBackground;
        this.save();
        desktop.closeCurrentPage();
    }


    this.delBackground = function() {
        document.body.style.background = "";
        this.profile["background"] = "";
        this.save();
    }



    this.close = function() {
        desktop.closeCurrentPage();
    }
 

    this.onSelectColor = function(target, color) {
        switch(target) {
            case "background":
                this.testBackgroundColor(color);
                break;
        }
    }



    this.applyBackgound = function() {
        if(this.profile.background == "") {
            return;
        }
        document.body.style.background = this.profile.background;
    }






    this.currentPopup = false;

    this.showPopup = function(btnEl, popupEl) {
        if(this.currentPopup) {
            if(this.currentPopup == popupEl) return;
            this.closePopup(this.currentPopup);
        }
        this.currentPopup = popupEl;
        var pos = {left: getLeft(this.elements[btnEl]) + 16, 
                   top:  getTop(this.elements[btnEl]) + 16};
        showEl(this.elements[popupEl]);
        setElPos(this.elements[popupEl], pos);        
    }


    this.closePopup = function(popupEl) {
        hideEl(this.elements[popupEl]);
        this.currentPopup = false;
    }


    this.selectColor = function(popupEl, target, color) {
        this.closePopup(popupEl);
        this.onSelectColor(target, color);
    }

    this.selectFont = function(popupEl, target, font) {
        this.closePopup(popupEl);
        this.onSelectFont(target, font);
    }

    this.selectFontSize = function(popupEl, target, fontSize) {
        this.closePopup(popupEl);
        this.onSelectFontSize(target, fontSize);
    }






    /* THEMES */

    this.renderThemes = function(list) {
        if(list == null) {
            this.elements["page_themes"].innerHTML = "No themes found :(";
        } else {
            this.elements["page_themes"].innerHTML = "";
            for(var i=0; i< list.length; i++) {
                var cn = (list[i].name == desktop.profile["theme"]) ? "theme_box_selected" : "theme_box";
                this.buildDomModel(this.elements["page_themes"],
                    { tag: "div", className: cn,
                      id: "theme_box_" + list[i].name,
                      events: { onclick: "setTheme('" + list[i].name + "')" },
                      childs: [
                        { tag: "div", className: "theme_thumbnail_box",
                          childs: [
                            { tag: "img", className: "theme_thumbnail",
                              src: "themes/" + list[i].name + "/thumbnail.jpg" }
                          ]},
                        { tag: "div", className: "theme_description_box",
                          innerHTML: list[i].description }
                      ]}
                );
            }
        }
    }


    this.setCurrentTheme = function(name) {
        if(this.elements["theme_box_" + name]) {
            this.elements["theme_box_" + name].className = "theme_box_selected";
        }
    }


    this.setTheme = function(name) {
        if(desktop.profile["theme"] != name) {
            if(this.elements["theme_box_" + desktop.profile["theme"]]) {
                this.elements["theme_box_" + desktop.profile["theme"]].className = "theme_box";
            }
            this.elements["theme_box_" + name].className = "theme_box_selected";
            desktop.profile["theme"] = name;
            desktop.applyTheme();
            desktop.save();
        }
    }








    this.dispatchMsg = function(msg) {
        switch (msg.status) {
            case "themes_list":
                this.renderThemes(msg.data);
                break;

            case "pwd_changed":
                this.elements["change_pwd_msg"].innerHTML = loc.text("settings_pwd_changed");
                this.elements["btn_change_pwd"].disabled = false;
                this.elements["inp_old_pwd"].value = "";
                this.elements["inp_new_pwd"].value = "";
                this.elements["inp_new_pwd2"].value = "";
                auth.user.password = msg.npwd;
                auth.saveUser();
                break;
        }
    }


}
Settings.prototype = new Widget();