function ToDoList() {
    this.init();

    this.cfg = {
        hasRefreshBtn: false,
        title_prefix: loc.text("todolist_title_prefix"),
        title: "",
        module: "ToDoList"
    }


    this.defaultProfile["items"] = [];
    this.defaultProfile["title"] = "";



    this.domSettings = [
           { tag: "div", className: "settings_section",
              childs: [
                  { tag: "span", innerHTML: loc.text("todolist_inp_todo"), className: "settings_label"},
                  {tag: "input", id: "todo_title", type: "text", size: "15", className: "settings_control"},
                  {tag: "input", type: "button", value: " Add ", events: {onclick: "addItem()"}, className: "settings_control"}
              ]} 
    ]

    this.domContent = { tag: "table", className: "sys_table", id: "items_table",
                        width: "100%",
                        childs: [] }


    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.renderItems();
    }


    this.onOpen = function() {
        this.setTitle(this.profile.title);
    }

    this.setTitle = function(html) {
        this.elements.title.innerHTML = this.cfg.title_prefix + html;
    }


    this.renderItems = function() {
        this.elements.content.innerHTML = "";
        this.buildDomModel(this.elements.content, this.domContent);
        for(var i=0; i<this.profile.items.length; i++) {
            this.renderItem(i);
        }
    }

    this.renderItem = function(n) {
        this.buildDomModel(this.elements.items_table_tbody,
            { tag: "tr", id: "item"+n,
              childs: [
                { tag: "td", width: "1%",
                  childs: [
                    { tag: "input", id: "item_checkbox"+n, type: "checkbox", events: {onclick: "switchItem("+n+")"}, checked: this.profile.items[n].completed}
                  ]},
                { tag: "td", width: "95%",
                  childs: [
                    { tag: "div",
                      style: {textDecoration: this.profile.items[n].completed ? "line-through" : "", overflow: "hidden"},
                      id: "item_title"+n, innerHTML: this.profile.items[n].title.wordWrap(10) }
                  ]},

                { tag: "td", width: "1%",
                  childs: [ createButtonDom(false, "moveItemUp("+n+")", "static/client/move_up.gif") ]},

                { tag: "td", width: "1%",
                  childs: [ createButtonDom(false, "moveItemDown("+n+")", "static/client/move_down.gif") ]},

                { tag: "td", width: "1%",
                  childs: [ createButtonDom(false, "editItem("+n+")", "static/client/edit.gif") ]},

                { tag: "td", width: "1%",
                  childs: [ createButtonDom(false, "deleteItem("+n+")", "static/client/delete_link.gif") ]}
              ]
            });
    }


    this.addItem = function() {
        var title = trim(this.elements.todo_title.value);
        if(!title) {
            return;
        }

        var newId = this.profile.items.length;
        var newItem = {title: title, completed: false};
        this.profile.items[newId] = newItem;
        this.renderItem(newId);
        this.save();

        this.elements.todo_title.value = '';
    }


    this.switchItem = function(id) {
        this.profile.items[id].completed = !this.profile.items[id].completed;
        this.elements['item_title'+id].style.textDecoration = this.profile.items[id].completed ? "line-through" : "" ;
        this.save();
    }


    this.moveItemUp = function(id) {
          if(id > 0) {
            this.swapItems(id, id-1);
            this.renderItems();
            this.save();
        }
    }

    this.moveItemDown = function(id) {
        if(id < this.profile.items.length - 1) {
            this.swapItems(id, id+1);
            this.renderItems();
            this.save();
        }
    }


    this.editItem = function(id) {
        var res = trim(prompt(loc.text("todolist_todo_edit"), this.profile.items[id].title));
        if(res) {
            this.profile.items[id].title = res;
            this.elements['item_title'+id].innerHTML = res.wordWrap(10);
        }
        this.save();
    }



    this.deleteItem = function(id) {
        if(confirm(  loc.text("todolist_delete_confirm", this.profile.items[id].title)  )) {
            var tmp = [];
            for(var i=0; i<this.profile.items.length; i++) {
                if(i != id) {
                    tmp.push(this.profile.items[i]);
                }
            }
            this.profile.items = tmp;
            tmp = null;
            this.renderItems();
            this.save();
        }
    }



    this.swapItems = function(a,b) {
        var tmp = this.profile.items[a];
        this.profile.items[a] = this.profile.items[b];
        this.profile.items[b] = tmp;
    }    
}
ToDoList.prototype = new Widget();