function Weather() {
    this.init();

    this.cfg = {
        title: loc.text("weather_title"),
        module: "Weather"
    };

    this.defaultProfile["city"] = "RSXX0199";
    this.defaultProfile["unit"] = "c";

    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("weather_inp_unit"), className: "settings_label"},
            { tag: "select", id: "setUnit", events: {onclick: "setUnit()"}, className: "settings_control",
              options: [
                { value:"c", text: loc.text("weather_celsius")},
                { value:"f", text: loc.text("weather_fahrenheit")},
              ]
            }
          ]
        },
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("weather_inp_town"), className: "settings_label"},
            { tag: "input", type: "text", size: 15, id: "setCity", className: "settings_control"},
            { tag: "input", type: "button", events: {onclick: "loadCities()"}, value: loc.text("btn_set"), className: "settings_control"},
          ]},
        { tag: "div", className: "settings_section", id: "citiesList", display: false}
    ]


    this.onBuildInterface = function() {
        this.elements["settings"].innerHTML = "";
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.elements.setUnit.value = this.profile.unit;
    }



    this.onOpen = function() {
        this.refresh();
    }

    var loading = false;

    this.refresh = function() {
        if(!loading) {
            loading = true;
            this.setTitle(loc.text("msg_loading"));
            xmlRequest.send("http://xoap.weather.com/weather/local/"+this.profile.city+"?cc=*&unit=d&dayf=4", this, "showWeather");
        }
    }



    this.setUnit = function() {
        this.profile.unit = this.elements.setUnit.value;
        this.renderWeather();
        this.save();
    }


    this.loadCities = function() {
        xmlRequest.send("http://xoap.weather.com/search/search?where="+this.elements.setCity.value, this, "showCities");
    }


    this.showCities = function(response) {
        this.elements.citiesList.innerHTML = '';
        showEl(this.elements.citiesList);
        var doc = response.responseXML.documentElement;
        var r = doc.getElementsByTagName("loc");
        if(r.length == 1) {
            this.setCity(r[0].getAttribute("id"))
        } else if (r.length == 0) {
            this.elements.citiesList.innerHTML = "<b>" + loc.text("weather_no_cities") + "</b>";
        } else {
            var clistDom = [];
            for(var i=0; i<r.length; i++) {
                clistDom[i] = { tag: "li", 
                                childs: [
                                  { tag: "a", href: "void", events: {onclick: "setCity('"+r[i].getAttribute("id")+"')"},
                                    innerHTML: r[i].firstChild.nodeValue}
                                ]
                              }
            }
            this.buildDomModel(this.elements.citiesList, { tag: "ul", childs: clistDom });
        }
    }


    this.setCity = function(id) {
        this.profile.city = id;
        hideEl(this.elements.citiesList);
        this.save();
        this.refresh();
    }



    this.toCelcius = function(n) {
		var calc = Math.round((n-32)*5/9);
		return (isNaN(calc)) ? loc.text("weather_na") : calc + "&#176;";
	}
	
	this.getTemp = function(node) {
		var hi = node.getElementsByTagName("hi")[0].firstChild.nodeValue;
		var low = node.getElementsByTagName("low")[0].firstChild.nodeValue;

        if(this.profile.unit == "c") {
           	hi = this.toCelcius(hi);
            low = this.toCelcius(low);
        }
		
		return low+" / "+hi+"";
	}



    this.renderWeather = function() {
        if(!this.data) {
            return false;
        }
    	var days = this.data.getElementsByTagName("day");
        var mDays = [];
        var pic;

        for(var i=0; i<days.length; i++) {
            pic = parseInt(days[i].getElementsByTagName("icon")[0].firstChild.nodeValue);
            pic = ((pic < 10) ? "0" : "") + pic + ".gif";
            mDays.push({ tag: "td", style: {textAlign: "center"}, 
                         childs: [
                            { tag: "div", innerHTML: days[i].getAttribute("t") },
                            { tag: "img", src: 'static/weather/' + pic },
                            { tag: "div", innerHTML: this.getTemp(days[i]) }
                         ]});
        }



        var m = { tag: "table", className: "sys_table", style: {width: "100%"},
                  childs: [
                    { tag: "tr",
                      childs: mDays }
                  ]};

        this.elements["content"].innerHTML = '';
        this.buildDomModel(this.elements["content"], m);

        if(this.data.getElementsByTagName("dnam").length>0) {
            this.setTitle(this.cfg.title + " : " + this.data.getElementsByTagName("dnam")[0].firstChild.nodeValue);
        }
    }


    this.showWeather = function(response) {
        this.data = response.responseXML.documentElement;
        this.renderWeather();
        loading = false;
    }

 
 
}
Weather.prototype = new Widget();