function Webnote() {
    this.init();

    this.cfg = {
        hasRefreshBtn: false,
        title: loc.text("webnote_title"),
        module: "Webnote"
    }

    this.defaultProfile["title"] = this.cfg.title;
    this.defaultProfile["text"] = loc.text("webnote_text");


    this.contentDomWebnote = [
        { tag: "div", id: "text_show", 
          className: "webnote_text"},
        { tag: "textarea", id: "text_edit", 
          display: false,
          className: "webnote_textarea",
          events: {onclick: "applyText()", onblur: "showText()"}}
    ]


    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.content, this.contentDomWebnote);

        var text_show = this.elements.text_show;
        var text_edit = this.elements.text_edit;
        var widget = this;

        this.elements.text_show["onclick"] = function() { widget.editText(widget, text_show, text_edit); };

        var t = this.profile.text.jsUnescape();
        this.elements.text_show.innerHTML = text2html(t).parseUrl();
        this.elements.text_edit.value = t;
        this.setTitle(this.profile.title);
    }


    this.editText = function(widget, text_show, text_edit) {
        var h = text_show.offsetHeight;
        hideEl(text_show);
        showEl(text_edit);

        text_edit.style.height = (h+16)+"px";
        text_edit.focus();

        text_edit.onkeyup = function() {
 			text_show.innerHTML = text2html(this.value);
 			showEl(text_show);
 			this.style.height = (text_show.offsetHeight+16) + "px";
 			hideEl(text_show);
 		}

        text_edit.onblur = function() {
            text = this.value.replace(/\\/g, "");
            this.onblur = null;
            hideEl(this);
            htmlText = text2html(text);
            text_show.innerHTML = htmlText.jsUnescape().parseUrl();
            text_show.style.display = "block";
            text_show.onclick =  function() { widget.editText(widget, text_show, text_edit); };
            widget.profile.text = text.jsEscape();
            widget.save();
		}
    }

    this.showText = function() {}
    this.applyText = function() {}

}
Webnote.prototype = new Widget();