function Websearch() {
    this.init();

    this.cfg = {
        hasRefreshBtn: false,
        title: loc.text("websearch_title"),
        module: "Websearch"
    }

 
    this.defaultProfile["openHere"] = "0";
    this.defaultProfile["serverId"] = 1;


    this.domSettings = [
        { tag: "div", className: "settings_section",
          childs: [
            { tag: "span", innerHTML: loc.text("websearch_results_target"), className: "settings_label"},
            { tag: "input", id: "set_target", type: "checkbox", events: {onclick: "setTarget()"}, className: "settings_control"}
          ]}
    ]


    this.domContent = [
        { tag: "div", className: "menu_panel", style: {marginTop: "4px", padding: "0px"}, id: "servers_tabs", innerHTML: " "},
        { tag: "div", className: "menu_panel", style: {background: "#EAEAFF", padding: "6px", marginTop: "6px"},
          childs: [
            createTableDom([{content: { tag: "img", id: "server_logo", border: "0", display: false, style: {marginRight: "10px"} }, width: "1%"},
                            {content: { tag: "input", id: "search_text", type: "text", style: {width: "95%", align: "center"}}, width: "98%"},
                            {content: { tag: "input", type: "button", value: loc.text("btn_go"), events: {onclick: "goSearch()"}}, width: "1%"}], "90%")
          ]}
    ]

    this.onBuildInterface = function() {
        this.elements["settings"].innerHTML = "";
        this.buildDomModel(this.elements.settings, this.domSettings);

        this.buildDomModel(this.elements.content, this.domContent);
        for(var i=0; i<websearch_servers.length; i++) {
            this.buildDomModel(this.elements.servers_tabs,
                { tag: "span", className: "bevel_section",
                  style: {cursor: "pointer", fontWeight: "normal"},
                  id: "tab_"+i, align: "center", 
                  innerHTML: websearch_servers[i].title, 
                  events: {onclick: "setServer('"+i+"')"}});
        }

        if(this.profile.serverId > websearch_servers.length - 1) {
            this.profile.serverId = websearch_servers.length - 1;
        } else if (!websearch_servers[this.profile.serverId]) {
            this.profile.serverId = 0;
        }

        this.elements.set_target.checked = (this.profile.openHere == 1);

        this.showServerTab(this.profile.serverId);
//        this.setTitle(this.profile.title);


        var widget = this;
        this.elements["search_text"]["onkeyup"] = function(event) { if (!event) { event = window.event } if(event.keyCode == 13) { widget.goSearch() } };
    }


    this.setTarget = function() {
        this.profile.openHere = (this.elements.set_target.checked ? "1" : "0");
        this.save();
    }


    this.setServer = function(serverId) {
        this.profile.serverId = serverId;
        this.showServerTab(serverId);
        this.save();
    } 


    this.activeTab = null;
    this.showServerTab = function(serverId) {
        if(this.activeTab) {
            this.elements["tab_"+this.activeTab].style.backgroundColor = "#EAEAFF";
            this.elements["tab_"+this.activeTab].style.fontWeight = "normal";
        }
        this.elements["tab_"+serverId].style.backgroundColor = "#FFFFFF";
        this.elements["tab_"+serverId].style.fontWeight = "bold";
        this.activeTab = serverId;

        if(websearch_servers[serverId].logo != "") {
            showEl(this.elements.server_logo);
            this.elements.server_logo.src = 'var/img/'+websearch_servers[serverId].logo;
        } else {
            hideEl(this.elements.server_logo);
        }
        this.setTitle(websearch_servers[serverId].title);
    }


    this.goSearch = function() {
        var str = this.elements.search_text.value;
        if(str == "") {
            return;
        }

        var url = websearch_servers[this.profile.serverId].url+escape(str); 
        if(this.profile.openHere == 1) {
            document.location = url;
        } else {
            window.open(url);
        }
    }
}
Websearch.prototype = new Widget();