function YahooMail() {
    this.init();


    this.cfg = {
        hasSettingsBtn: true,
        title: "",
        module: "YahooMail"
    }


    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_mcount")},
            { tag: "select", id: "inp_count", className: "settings_control",
              options: [
                { value:"3", text: "3"},
                { value:"5", text: "5"},
                { value:"8", text: "8"},
                { value:"10", text: "10"},
                { value:"12", text: "12"},
                { value:"15", text: "15"},
                { value:"20", text: "20"}
              ]
            },
            { tag: "input", type: "button", value: loc.text("btn_set"), events: {onclick: "setItemsCount()"}, className: "settings_control"}
          ]
        },

        { tag: "div", className: "settings_section", align: "center",
          innerHTML: "<b>"+ loc.text("popmail_asettings") + "</b>"},

        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "a", sysHref: "http://help.yahoo.com/help/us/mail/pop/pop-40.html",
              target: "_blank",
              html: loc.text("yahoomail_info") }
          ]},

        { tag: "div", className: "settings_section",
           childs: [ 
             { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_inp_login")},
             { tag: "input", id: "select_login", type: "text", size: "15", className: "settings_control"} 
           ]},

        { tag: "div", className: "settings_section",
           childs: [ 
             { tag: "span", className: "settings_label", innerHTML: loc.text("popmail_inp_pwd")},
             { tag: "input", id: "select_password", type: "password", size: "15", className: "settings_control"} 
           ]},

        { tag: "div", className: "settings_section", align: "center",
          childs: [ 
            { tag: "input", type: "button", value: loc.text("btn_save"), events: {onclick: "saveProfile()"}} 
          ]}
    ]


    this.domContent = [
        { tag: "div", className: "menu_panel", id: "messages", display: false,
          childs: [
            { tag: "div", className: "menu_panel", 
              style: { paddingLeft: "30px", background: "url(widgets/aolmail/ico.gif) no-repeat 0 0"},
              childs: [
                { tag: "b", html: loc.text("popmail_total") },
                { tag: "span", id: "total_messages"}
              ]},
            { tag: "div", id: "mail_list"}
          ]},

        { tag: "div", className: "menu_panel", id: "loading_note", display: false,
          style: { paddingLeft: "30px", background: "url(widgets/yahoomail/ico.gif) no-repeat 0 0"},
          innerHTML: loc.text("msg_loading")},

        { tag: "div", className: "menu_panel", id: "config_note", display: false,
          style: { paddingLeft: "30px", background: "url(widgets/yahoomail/ico.gif) no-repeat 0 0"},
          innerHTML: loc.text("popmail_msg_not_configured")},

        { tag: "div", className: "menu_panel", id: "no_messages_note", display: false,
          style: { paddingLeft: "30px", background: "url(widgets/yahoomail/ico.gif) no-repeat 0 0"},
          innerHTML: loc.text("popmail_msg_no_mails")}
    ]

    this.defaultProfile["login"] = "";
    this.defaultProfile["password"] = "";

    this.defaultProfile["title"] = "";
    this.defaultProfile["mcount"] = "8";


    var isLoading = false;

    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.buildDomModel(this.elements.content, this.domContent);

        this.elements.select_login.value = this.profile.login;
        this.elements.select_password.value = this.profile.password;
        this.elements.inp_count.value = this.profile.mcount;

        var t = this.profile.title != "" ? this.profile.title : loc.text("yahoomail_title");
        this.setTitle(t);
    }



    this.onOpen = function() {
        if(this.isProfileEmpty()) {
            this.setContent("config_note");
        } else {
            this.refresh();
        }
    }



    this.isProfileEmpty = function() {
        return this.profile.login == "" || this.profile.password == "";
    }


    this.setContent = function(section) {
        var sections = ["config_note", "loading_note", "messages", "no_messages_note"];
        for(var i = 0; i<sections.length; i++) {
            if(section == sections[i]) {
                showEl(this.elements[sections[i]]);
            } else {
                hideEl(this.elements[sections[i]]);
            }
        }
    }


    this.saveProfile = function() {
        var l = trim(this.elements.select_login.value);
        if(l.indexOf("@") != -1) {
            l = l.substr(0, l.indexOf("@"));
            this.elements.select_login.value = l;
        }
        var p = trim(this.elements.select_password.value); 

        if(this.profile.login != l || this.profile.password != p) {
            this.profile.login = l;
            this.profile.password = p;
            this.save();
        }

        if(this.isProfileEmpty()) {
            this.setContent("config_note");
        } else {
            this.refresh();
        }
    }


    this.setItemsCount = function() {
        var c = this.elements["inp_count"].value;
        if(this.profile.mcount != c) {
            this.profile.mcount = c;
            this.save();
            this.renderMessages();
        }
    }




    this.timerHandler = function() {
        if(this.isProfileEmpty()) {
            this.setContent("config_note");
        } else {
            this.refresh();
        }
    }


    this.req = null;
    this.timerId = null;

    this.refresh = function() {
        if(!this.isProfileEmpty() && !isLoading) {
            isLoading = true;
            this.setContent("loading_note");
            var protocol = "/pop3/ssl/novalidate-cert";

            this.req = request.send({ login: this.profile.login,
                                      password: this.profile.password,
                                      protocol: protocol,
                                      server: "pop.mail.yahoo.com",
                                      port: 995 }, this);

            var self = this;
            var f = function() {
                updateLoadingIcon(-1);
                self.req.onreadystatechange = function() {};
                self.isLoading = false;
                self.setContent("config_note");
            }
            this.timerId = setTimeout(f, 30000);
        }
    }



    this.renderMessages = function() {
        if(this.data) {
            this.setContent("messages");        
            this.elements.total_messages.innerHTML = "<B>" + this.totalMessages + "<B>";
            this.elements.mail_list.innerHTML = '';
            var cnt = Math.min(this.data.length, this.profile.mcount);
            for(var i=0; i<cnt; i++) {
                try {
                    this.buildDomModel(this.elements.mail_list,
                                       { tag: "div", className: "menu_panel", 
                                         innerHTML: "<B>" + this.data[i].from + "</B>",
                                         childs: [
                                           { tag: "div", className: "note", innerHTML: this.data[i].subj }
                                         ]
                                       });
                } catch(e) {}
            }
        }
    }


    this.dispatchMsg = function(msg) {
        clearTimeout(this.timerId);
        isLoading = false;
        switch(msg.status) {
            case "empty":
                this.setContent("no_messages_note");
                break;
            case "data":
                this.data = msg.data;
                this.totalMessages = msg.total;
                this.renderMessages();
                break;
            case "error":
                this.setContent("config_note");
                break;
        }
    }

}
YahooMail.prototype = new Widget();