function YoutubeVideo() {
    this.init();

    this.cfg = {
        title: "",
        module: "YoutubeVideo"
    };


    this.channels = [
    	{text:"- Video -", value: "", isBold: true},
    	{text:"Recently Added", value: "http://youtube.com/rss/global/recently_added.rss"},
    	{text:"Recently Featured", value: "http://youtube.com/rss/global/recently_featured.rss"},
    	{text:"Top Favorites", value: "http://youtube.com/rss/global/top_favorites.rss"},
    	{text:"Top Rated", value: "http://youtube.com/rss/global/top_rated.rss"},
    	{text:"- Most Viewed Videos -", value: "", isBold: true},
    	{text:"Today", value: "http://youtube.com/rss/global/top_viewed_today.rss"},
    	{text:"This Week", value: "http://youtube.com/rss/global/top_viewed_week.rss"},
    	{text:"This Month", value: "http://youtube.com/rss/global/top_viewed_month.rss"},
    	{text:"All Time", value: "http://youtube.com/rss/global/top_viewed.rss"},
    	{text:"- Most Discussed Videos -", value: "", isBold: true},
    	{text:"Today", value: "http://youtube.com/rss/global/most_discussed_today.rss"},
    	{text:"This Week", value: "http://youtube.com/rss/global/most_discussed_week.rss"},
    	{text:"This Month", value: "http://youtube.com/rss/global/most_discussed_month.rss"}
    ];


    this.defaultProfile["title"] = "";
    this.defaultProfile["channel"] = "1";
    this.defaultProfile["count"] = "6";

    var isLoading = false;
    var req = null;
    var content = null;
    var itemsCount = 15;

    var sel_count_options = [];
    for(var i=1; i<=itemsCount; i++) {
        sel_count_options.push({value: i, text: " " + i + " "});
    }

    this.domSettings = [
        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("googlevideo_inp_channel"), className: "settings_label"},
            { tag: "select", id: "inp_channel", events: {onchange: "setChannel()"}, className: "settings_control",
              options: this.channels }
          ]},

        { tag: "div", className: "settings_section", 
          childs: [
            { tag: "span", innerHTML: loc.text("googlevideo_inp_count"), className: "settings_label"},
            { tag: "select", id: "inp_count", events: {onchange: "setCount()"}, className: "settings_control",
              options: sel_count_options }
          ]}
    ]



    this.onBuildInterface = function() {
        this.buildDomModel(this.elements.settings, this.domSettings);
        this.elements["inp_channel"].selectedIndex = this.profile.channel;
        this.elements["inp_count"].value = this.profile.count;
    }


    this.setChannel = function() {
        if(isLoading) {
            this.elements["inp_channel"].selectedIndex = this.profile.channel;
        } else {
            var c = this.elements["inp_channel"].selectedIndex;
            if(c != this.profile.channel && this.channels[c].value != "") {
                this.profile.channel = c;
                this.save();
                req = null;
                isLoading = false;
                this.refresh();
            }
        }
    }


    this.setCount = function() {
        var c = this.elements["inp_count"].value;
        if(c != this.profile.count) {
            this.profile.count = c;
            this.save();
            this.renderContent();
        }
    }


    this.onOpen = function() {
        this.refresh();
    }




    this.refresh = function() {
        if(!isLoading) {
            this.setTitle(loc.text("msg_loading"));
            req = xmlRequest.send(this.channels[this.profile.channel].value, this, "parseContent");
            isLoading = true;
        }
    }


    this.parseContent = function(response) {
        isLoading = false;
        if(response.responseXML && response.responseXML.documentElement) {
            content = XMLParser.xml2hash(response.responseXML.documentElement);
//            varpw(content);
        } else {
            content = null;
        }
        this.renderContent();
    }

    

    this.renderContent = function() {
        if(content) {
            if(this.profile.title != "") {
                this.setTitle(this.profile.title);
            } else {
                this.setTitle(content.title);
            }

            var l = Math.min(content.items.length, this.profile.count);
            var c = "";
            var st = "";

            for(var i=0; i<l; i++) {
                st = i % 2 == "1" ? "background: #F0F0F0;" : "";
                var lnk = content.items[i]["link"];
                var lnk2 = content.items[i]["enclosure"].url;
                c += "<tr style='"+st+"'>"+
                     "<td valign=top style='padding: 4px;'>"+
                     "<a href='"+lnk+"' target=_blank><img border=0 width=120 src='"+ content.items[i]["media:thumbnail"].url +"'/></a>"+
                     "</td><td valign=top style='padding: 4px;'>"+
                     "<a href='"+lnk+"' target=_blank><b>"+content.items[i].title+"</b></a>" +

                     "<br><br><a href='"+lnk2+"' target=_blank>"+
                     "<img src='widgets/youtubevideo/cam.gif' style='margin-right: 4px; height: 8px; border: 0; vertical-align: middle;'>"+
                     loc.text("youtubevideo_lnk_watch")+"</a>"
                                         
                     "</td>"+
                     "</tr>";
            }
            this.elements["content"].innerHTML = "<table class='plan_table' width=100%>" + c + "</table>";
        } else {
            this.setTitle(loc.text("msg_error"));
        }
    }
 
}
YoutubeVideo.prototype = new Widget();