$(document).ready(function() {
	$("body").on("click", "[data-ma-action]",
	function(e) {
		function launchIntoFullscreen(element) {
			element.requestFullscreen ? element.requestFullscreen() : element.mozRequestFullScreen ? element.mozRequestFullScreen() : element.webkitRequestFullscreen ? element.webkitRequestFullscreen() : element.msRequestFullscreen && element.msRequestFullscreen()
		}
		e.preventDefault();
		var $this = $(this),
		action = $(this).data("ma-action");
		switch (action) {
		case "sidebar-open":
			var target = $this.data("ma-target"),
			backdrop = '<div data-ma-action="sidebar-close" class="ma-backdrop" />';
			$("body").addClass("sidebar-toggled"),
			$("#header, #header-alt, #main").append(backdrop),
			$this.addClass("toggled"),
			$(target).addClass("toggled");
			break;
		case "sidebar-close":
			$("body").removeClass("sidebar-toggled"),
			$(".ma-backdrop").remove(),
			$(".sidebar, .ma-trigger").removeClass("toggled");
			break;
		case "profile-menu-toggle":
			$this.parent().toggleClass("toggled"),
			$this.next().slideToggle(200);
			break;
		case "submenu-toggle":
			$this.next().slideToggle(200),
			$this.parent().toggleClass("toggled");
			break;
		case "search-close":
			$("#header").removeClass("search-toggled");
			break;
		case "clear-notification":
			var x = $this.closest(".list-group"),
			y = x.find(".list-group-item"),
			z = y.size();
			$this.parent().fadeOut(),
			x.find(".list-group").prepend('<i class="grid-loading hide-it"></i>'),
			x.find(".grid-loading").fadeIn(1500);
			var w = 0;
			y.each(function() {
				var z = $(this);
				setTimeout(function() {
					z.addClass("animated fadeOutRightBig").delay(1e3).queue(function() {
						z.remove()
					})
				},
				w += 150)
			}),
			setTimeout(function() {
				$(".him-notification").addClass("empty")
			},
			150 * z + 200);
			break;
		case "fullscreen":
			launchIntoFullscreen(document.documentElement);
			break;
		case "clear-localstorage":
			swal({
				title:
				"Are you sure?",
				text: "All your saved localStorage values will be removed",
				type: "warning",
				showCancelButton: !0,
				confirmButtonText: "Yes, delete it!"
			}).then(function() {
				localStorage.clear(),
				swal("Done!", "localStorage is cleared", "success")
			});
			break;
		case "print":
			window.print();
			break;
		case "login-switch":
			var loginblock = $this.data("ma-block"),
			loginParent = $this.closest(".lc-block");
			loginParent.removeClass("toggled"),
			setTimeout(function() {
				$(loginblock).addClass("toggled")
			});
			break;
		case "profile-edit":
			$this.closest(".pmb-block").toggleClass("toggled");
			break;
		case "profile-edit-cancel":
			$(this).closest(".pmb-block").removeClass("toggled");
			break;
		case "action-header-open":
			ahParent = $this.closest(".action-header").find(".ah-search"),
			ahParent.fadeIn(300),
			ahParent.find(".ahs-input").focus();
			break;
		case "action-header-close":
			ahParent.fadeOut(300),
			setTimeout(function() {
				ahParent.find(".ahs-input").val("")
			},
			350);
			break;
		case "wall-comment-open":
			$this.closest(".wic-form").hasClass("toggled") || $this.closest(".wic-form").addClass("toggled");
			break;
		case "wall-comment-close":
			$this.closest(".wic-form").find("textarea").val(""),
			$this.closest(".wic-form").removeClass("toggled");
			break;
		case "todo-form-open":
			$this.closest(".t-add").addClass("toggled");
			break;
		case "todo-form-close":
			$this.closest(".t-add").removeClass("toggled"),
			$this.closest(".t-add").find("textarea").val("");
			break;
		case "change-skin":
			var skin = $this.data("ma-skin");
			$("[data-ma-theme]").attr("data-ma-theme", skin)
		}
	}),
	$('.main-menu li').click(function() {
		$("body").removeClass("sidebar-toggled"),
		$(".ma-backdrop").remove(),
		$(".sidebar, .ma-trigger").removeClass("toggled")
	});
}),
$(document).ready(function() {
	var data1 = [[1, 60], [2, 30], [3, 50], [4, 100], [5, 10], [6, 90], [7, 85]],
	data2 = [[1, 20], [2, 90], [3, 60], [4, 40], [5, 100], [6, 25], [7, 65]],
	data3 = [[1, 100], [2, 20], [3, 60], [4, 90], [5, 80], [6, 10], [7, 5]],
	barData = [{
		label: "Tokyo",
		data: data1,
		color: "#8BC34A"
	},
	{
		label: "Seoul",
		data: data2,
		color: "#00BCD4"
	},
	{
		label: "Beijing",
		data: data3,
		color: "#FF9800"
	}];
	$("#bar-chart")[0] && $.plot($("#bar-chart"), barData, {
		series: {
			bars: {
				show: !0,
				barWidth: .05,
				order: 1,
				fill: 1
			}
		},
		grid: {
			borderWidth: 1,
			borderColor: "#eee",
			show: !0,
			hoverable: !0,
			clickable: !0
		},
		yaxis: {
			tickColor: "#eee",
			tickDecimals: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			},
			shadowSize: 0
		},
		xaxis: {
			tickColor: "#fff",
			tickDecimals: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			},
			shadowSize: 0
		},
		legend: {
			container: ".flc-bar",
			backgroundOpacity: .5,
			noColumns: 0,
			backgroundColor: "white",
			lineWidth: 0
		}
	}),
	$(".flot-chart")[0] && ($(".flot-chart").bind("plothover",
	function(event, pos, item) {
		if (item) {
			var x = item.datapoint[0].toFixed(2),
			y = item.datapoint[1].toFixed(2);
			$(".flot-tooltip").html(item.series.label + " of " + x + " = " + y).css({
				top: item.pageY + 5,
				left: item.pageX + 5
			}).show()
		} else $(".flot-tooltip").hide()
	}), $("<div class='flot-tooltip' class='chart-tooltip'></div>").appendTo("body"))
}),
$(document).ready(function() {
	for (var d1 = [], i = 0; 10 >= i; i += 1) d1.push([i, parseInt(30 * Math.random())]);
	for (var d2 = [], i = 0; 20 >= i; i += 1) d2.push([i, parseInt(30 * Math.random())]);
	for (var d3 = [], i = 0; 10 >= i; i += 1) d3.push([i, parseInt(30 * Math.random())]);
	var options = {
		series: {
			shadowSize: 0,
			curvedLines: {
				apply: !0,
				active: !0,
				monotonicFit: !0
			},
			lines: {
				show: !1,
				lineWidth: 0,
				fill: 1
			}
		},
		grid: {
			borderWidth: 0,
			labelMargin: 10,
			hoverable: !0,
			clickable: !0,
			mouseActiveRadius: 6
		},
		xaxis: {
			tickDecimals: 0,
			ticks: !1
		},
		yaxis: {
			tickDecimals: 0,
			ticks: !1
		},
		legend: {
			show: !1
		}
	};
	$("#curved-line-chart")[0] && $.plot($("#curved-line-chart"), [{
		data: d1,
		lines: {
			show: !0,
			fill: .98
		},
		label: "Product 1",
		stack: !0,
		color: "#e3e3e3"
	},
	{
		data: d3,
		lines: {
			show: !0,
			fill: .98
		},
		label: "Product 2",
		stack: !0,
		color: "#f1dd2c"
	}], options),
	$(".flot-chart")[0] && ($(".flot-chart").bind("plothover",
	function(event, pos, item) {
		if (item) {
			var x = item.datapoint[0].toFixed(2),
			y = item.datapoint[1].toFixed(2);
			$(".flot-tooltip").html(item.series.label + " of " + x + " = " + y).css({
				top: item.pageY + 5,
				left: item.pageX + 5
			}).show()
		} else $(".flot-tooltip").hide()
	}), $("<div class='flot-tooltip' class='chart-tooltip'></div>").appendTo("body"))
}),
$(document).ready(function() {
	function gd(year, month, day) {
		return new Date(year, month - 1, day).getTime()
	}
	var data1 = [[gd(2016, 1, 2), 1800], [gd(2016, 1, 3), 1790], [gd(2016, 1, 4), 1810], [gd(2016, 1, 7), 1750], [gd(2016, 1, 8), 1805], [gd(2016, 1, 9), 1800], [gd(2016, 1, 10), 1794], [gd(2016, 1, 11), 1794], [gd(2016, 1, 14), 1807], [gd(2016, 1, 15), 1788], [gd(2016, 1, 16), 1799], [gd(2016, 1, 17), 1804], [gd(2016, 1, 18), 1811], [gd(2016, 1, 21), 1801], [gd(2016, 1, 22), 1805], [gd(2016, 1, 23), 1770], [gd(2016, 1, 24), 1799], [gd(2016, 1, 25), 1804], [gd(2016, 1, 28), 1810], [gd(2016, 1, 29), 1788], [gd(2016, 1, 30), 1804], [gd(2016, 1, 31), 1775]],
	data2 = [[gd(2016, 1, 2), 1674], [gd(2016, 1, 3), 1680], [gd(2016, 1, 4), 1643], [gd(2016, 1, 7), 1652], [gd(2016, 1, 8), 1640], [gd(2016, 1, 9), 1652], [gd(2016, 1, 10), 1652], [gd(2016, 1, 11), 1664], [gd(2016, 1, 14), 1660], [gd(2016, 1, 15), 1664], [gd(2016, 1, 16), 1673], [gd(2016, 1, 17), 1671], [gd(2016, 1, 18), 1682], [gd(2016, 1, 21), 1680], [gd(2016, 1, 22), 1685], [gd(2016, 1, 23), 1684], [gd(2016, 1, 24), 1670], [gd(2016, 1, 25), 1664], [gd(2016, 1, 28), 1652], [gd(2016, 1, 29), 1655], [gd(2016, 1, 30), 1659], [gd(2016, 1, 31), 1668]],
	dataset = [{
		label: "Students",
		data: data1,
		color: "#26A69A",
		points: {
			fillColor: "#26A69A",
			show: !0,
			radius: 0
		},
		lines: {
			show: !0,
			lineWidth: 2
		}
	},
	{
		label: "Teachers",
		data: data2,
		xaxis: 2,
		color: "#FFC107",
		points: {
			fillColor: "#FFC107",
			show: !0,
			radius: 0
		},
		lines: {
			show: !0,
			lineWidth: 2
		}
	}],
	dayOfWeek = ["Sun", "Mon", "Tue", "Wed", "Thr", "Fri", "Sat"],
	options = {
		series: {
			shadowSize: 0,
			curvedLines: {
				apply: !0,
				active: !0,
				monotonicFit: !0
			}
		},
		grid: {
			borderWidth: 1,
			borderColor: "#f3f3f3",
			show: !0,
			clickable: !0,
			hoverable: !0,
			mouseActiveRadius: 20,
			labelMargin: 10
		},
		xaxes: [{
			color: "#f3f3f3",
			mode: "time",
			tickFormatter: function(val, axis) {
				return dayOfWeek[new Date(val).getDay()]
			},
			position: "top",
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			}
		},
		{
			color: "#f3f3f3",
			mode: "time",
			timeformat: "%m/%d",
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			}
		}],
		yaxis: {
			ticks: 2,
			color: "#f3f3f3",
			tickDecimals: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			}
		},
		legend: {
			container: ".flc-visits",
			backgroundOpacity: .5,
			noColumns: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			}
		}
	};
	$("#attendance")[0] && $.plot($("#attendance"), dataset, options)
}),
$(document).ready(function() {
	var data1 = [[2010, 60], [2011, 50], [2012, 80], [2013, 30], [2014, 70], [2015, 40], [2016, 55]],
	dataset = [{
		label: "Index Value",
		data: data1,
		color: "#00BCD4",
		points: {
			fillColor: "#00BCD4",
			show: !0,
			radius: 0
		},
		lines: {
			show: !0,
			lineWidth: 1,
			fill: 1,
			fillColor: {
				colors: ["rgba(255,255,255,0.0)", "#00BCD4"]
			}
		}
	}],
	options = {
		series: {
			shadowSize: 0,
			curvedLines: {
				apply: !0,
				active: !0,
				monotonicFit: !0
			}
		},
		grid: {
			borderWidth: 1,
			borderColor: "#eee",
			show: !0,
			hoverable: !0,
			clickable: !0
		},
		yaxis: {
			tickColor: "#eee",
			tickDecimals: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			},
			shadowSize: 0
		},
		xaxis: {
			tickColor: "#fff",
			tickDecimals: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			},
			shadowSize: 0
		},
		legend: {
			container: ".flc-sei",
			backgroundOpacity: .5,
			noColumns: 0,
			backgroundColor: "white",
			lineWidth: 0
		}
	};
	$("#effective-index")[0] && $.plot($("#effective-index"), dataset, options)
}),
$(document).ready(function() {
	var feeData = [{
		data: 5,
		color: "#03A9F4",
		label: "Collected"
	},
	{
		data: 2,
		color: "#F44336",
		label: "Not Collected"
	},
	{
		data: 1,
		color: "#8BC34A",
		label: "Pending"
	}];
	$("#fee-collected")[0] && $.plot("#fee-collected", feeData, {
		series: {
			pie: {
				show: !0,
				stroke: {
					width: 2
				}
			}
		},
		legend: {
			container: ".flc-pie",
			backgroundOpacity: .5,
			noColumns: 0,
			backgroundColor: "white",
			lineWidth: 0
		},
		grid: {
			hoverable: !0,
			clickable: !0
		},
		tooltip: !1,
		tooltipOpts: {
			content: "%p.0%, %s",
			defaultTheme: !1,
			cssClass: "flot-tooltip"
		}
	})
}),
$(document).ready(function() {
	var data = [[1, 60], [2, 30], [3, 50], [4, 100], [5, 10], [6, 90], [7, 85], [8, 10], [9, 25], [10, 65], [11, 69], [12, 104], [13, 94], [14, 32], [15, 10], [16, 45], [17, 34], [18, 22], [19, 100], [20, 43], [21, 98], [22, 60], [23, 51], [24, 30]],
	dataset = [{
		data: data,
		label: "Visits",
		bars: {
			show: !0,
			barWidth: .4,
			order: 1,
			lineWidth: 0,
			fillColor: "#ff766c"
		}
	}],
	options = {
		grid: {
			borderWidth: 1,
			borderColor: "#f3f3f3",
			show: !0,
			hoverable: !0,
			clickable: !0,
			labelMargin: 10
		},
		yaxis: {
			tickColor: "#f3f3f3",
			tickDecimals: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			},
			shadowSize: 0
		},
		xaxis: {
			tickFormatter: function(value, axis) {
				return value + "h"
			},
			tickColor: "#fff",
			tickDecimals: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			},
			shadowSize: 0
		},
		legend: {
			show: !1
		}
	};
	$("#visit-server-time")[0] && $.plot($("#visit-server-time"), dataset, options)
}),
$(document).ready(function() {
	function gd(year, month, day) {
		return new Date(year, month - 1, day).getTime()
	}
	var data1 = [[gd(2013, 1, 2), 1690.25], [gd(2013, 1, 3), 1696.3], [gd(2013, 1, 4), 1659.65], [gd(2013, 1, 7), 1668.15], [gd(2013, 1, 8), 1656.1], [gd(2013, 1, 9), 1668.65], [gd(2013, 1, 10), 1668.15], [gd(2013, 1, 11), 1680.2], [gd(2013, 1, 14), 1676.7], [gd(2013, 1, 15), 1680.7], [gd(2013, 1, 16), 1689.75], [gd(2013, 1, 17), 1687.25], [gd(2013, 1, 18), 1698.3], [gd(2013, 1, 21), 1696.8], [gd(2013, 1, 22), 1701.3], [gd(2013, 1, 23), 1700.8], [gd(2013, 1, 24), 1686.75], [gd(2013, 1, 25), 1680], [gd(2013, 1, 28), 1668.65], [gd(2013, 1, 29), 1671.2], [gd(2013, 1, 30), 1675.7], [gd(2013, 1, 31), 1684.25]],
	data2 = [[gd(2013, 1, 2), 1674.15], [gd(2013, 1, 3), 1680.15], [gd(2013, 1, 4), 1643.8], [gd(2013, 1, 7), 1652.25], [gd(2013, 1, 8), 1640.3], [gd(2013, 1, 9), 1652.75], [gd(2013, 1, 10), 1652.25], [gd(2013, 1, 11), 1664.2], [gd(2013, 1, 14), 1660.7], [gd(2013, 1, 15), 1664.7], [gd(2013, 1, 16), 1673.65], [gd(2013, 1, 17), 1671.15], [gd(2013, 1, 18), 1682.1], [gd(2013, 1, 21), 1680.65], [gd(2013, 1, 22), 1685.1], [gd(2013, 1, 23), 1684.6], [gd(2013, 1, 24), 1670.65], [gd(2013, 1, 25), 1664], [gd(2013, 1, 28), 1652.75], [gd(2013, 1, 29), 1655.25], [gd(2013, 1, 30), 1659.7], [gd(2013, 1, 31), 1668.2]],
	dataset = [{
		label: "Visits",
		data: data1,
		color: "#ff766c",
		points: {
			fillColor: "#ff766c",
			show: !0,
			radius: 2
		},
		lines: {
			show: !0,
			lineWidth: 1
		}
	},
	{
		label: "Unique Visitors",
		data: data2,
		xaxis: 2,
		color: "#03A9F4",
		points: {
			fillColor: "#03A9F4",
			show: !0,
			radius: 2
		},
		lines: {
			show: !0,
			lineWidth: 1
		}
	}],
	dayOfWeek = ["Sun", "Mon", "Tue", "Wed", "Thr", "Fri", "Sat"],
	options = {
		series: {
			shadowSize: 0
		},
		grid: {
			borderWidth: 1,
			borderColor: "#f3f3f3",
			show: !0,
			clickable: !0,
			hoverable: !0,
			mouseActiveRadius: 20,
			labelMargin: 10
		},
		xaxes: [{
			color: "#f3f3f3",
			mode: "time",
			tickFormatter: function(val, axis) {
				return dayOfWeek[new Date(val).getDay()]
			},
			position: "top",
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			}
		},
		{
			color: "#f3f3f3",
			mode: "time",
			timeformat: "%m/%d",
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			}
		}],
		yaxis: {
			ticks: 2,
			color: "#f3f3f3",
			tickDecimals: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			}
		},
		legend: {
			container: ".flc-visits",
			backgroundOpacity: .5,
			noColumns: 0,
			font: {
				lineHeight: 13,
				style: "normal",
				color: "#9f9f9f"
			}
		}
	};
	$("#visit-over-time")[0] && $.plot($("#visit-over-time"), dataset, options)
}),
$(document).ready(function() {
	function getRandomData() {
		for (data.length > 0 && (data = data.slice(1)); data.length < totalPoints;) {
			var prev = data.length > 0 ? data[data.length - 1] : 50,
			y = prev + 10 * Math.random() - 5;
			0 > y ? y = 0 : y > 90 && (y = 90),
			data.push(y)
		}
		for (var res = [], i = 0; i < data.length; ++i) res.push([i, data[i]]);
		return res
	}

	function update() {
		plot.setData([getRandomData()]),
		plot.draw(),
		setTimeout(update, updateInterval)
	}
	var data = [],
	totalPoints = 300,
	updateInterval = 30;
	if ($("#dynamic-chart")[0]) {
		var plot = $.plot("#dynamic-chart", [getRandomData()], {
			series: {
				label: "Server Process Data",
				lines: {
					show: !0,
					lineWidth: .2,
					fill: .6
				},
				color: "#00BCD4",
				shadowSize: 0
			},
			yaxis: {
				min: 0,
				max: 100,
				tickColor: "#eee",
				font: {
					lineHeight: 13,
					style: "normal",
					color: "#9f9f9f"
				},
				shadowSize: 0
			},
			xaxis: {
				tickColor: "#eee",
				show: !0,
				font: {
					lineHeight: 13,
					style: "normal",
					color: "#9f9f9f"
				},
				shadowSize: 0,
				min: 0,
				max: 250
			},
			grid: {
				borderWidth: 1,
				borderColor: "#eee",
				labelMargin: 10,
				hoverable: !0,
				clickable: !0,
				mouseActiveRadius: 6
			},
			legend: {
				show: !1
			}
		});
		update()
	}
}),
$(document).ready(function() {
	function getRandomData() {
		for (data.length > 0 && (data = data.slice(1)); data.length < totalPoints;) {
			var prev = data.length > 0 ? data[data.length - 1] : 50,
			y = prev + 10 * Math.random() - 5;
			0 > y ? y = 0 : y > 90 && (y = 90),
			data.push(y)
		}
		for (var res = [], i = 0; i < data.length; ++i) res.push([i, data[i]]);
		return res
	}
	for (var data = [], totalPoints = 100, d1 = [], i = 0; 10 >= i; i += 1) d1.push([i, parseInt(30 * Math.random())]);
	for (var d2 = [], i = 0; 20 >= i; i += 1) d2.push([i, parseInt(30 * Math.random())]);
	for (var d3 = [], i = 0; 10 >= i; i += 1) d3.push([i, parseInt(30 * Math.random())]);
	var options = {
		series: {
			shadowSize: 0,
			lines: {
				show: !1,
				lineWidth: 0
			}
		},
		grid: {
			borderWidth: 0,
			labelMargin: 10,
			hoverable: !0,
			clickable: !0,
			mouseActiveRadius: 6
		},
		xaxis: {
			tickDecimals: 0,
			ticks: !1
		},
		yaxis: {
			tickDecimals: 0,
			ticks: !1
		},
		legend: {
			show: !1
		}
	};
	$("#line-chart")[0] && $.plot($("#line-chart"), [{
		data: d1,
		lines: {
			show: !0,
			fill: .98
		},
		label: "Product 1",
		stack: !0,
		color: "#e3e3e3"
	},
	{
		data: d3,
		lines: {
			show: !0,
			fill: .98
		},
		label: "Product 2",
		stack: !0,
		color: "#FFC107"
	}], options),
	$("#recent-items-chart")[0] && $.plot($("#recent-items-chart"), [{
		data: getRandomData(),
		lines: {
			show: !0,
			fill: .8
		},
		label: "Items",
		stack: !0,
		color: "#00BCD4"
	}], options),
	$(".flot-chart")[0] && ($(".flot-chart").bind("plothover",
	function(event, pos, item) {
		if (item) {
			var x = item.datapoint[0].toFixed(2),
			y = item.datapoint[1].toFixed(2);
			$(".flot-tooltip").html(item.series.label + " of " + x + " = " + y).css({
				top: item.pageY + 5,
				left: item.pageX + 5
			}).show()
		} else $(".flot-tooltip").hide()
	}), $("<div class='flot-tooltip' class='chart-tooltip'></div>").appendTo("body"))
}),
$(document).ready(function() {
	var pieData = [{
		data: 1,
		color: "#F44336",
		label: "Toyota"
	},
	{
		data: 2,
		color: "#03A9F4",
		label: "Nissan"
	},
	{
		data: 3,
		color: "#8BC34A",
		label: "Hyundai"
	},
	{
		data: 4,
		color: "#FFEB3B",
		label: "Scion"
	},
	{
		data: 4,
		color: "#009688",
		label: "Daihatsu"
	}];
	$("#pie-chart")[0] && $.plot("#pie-chart", pieData, {
		series: {
			pie: {
				show: !0,
				stroke: {
					width: 2
				}
			}
		},
		legend: {
			container: ".flc-pie",
			backgroundOpacity: .5,
			noColumns: 0,
			backgroundColor: "white",
			lineWidth: 0
		},
		grid: {
			hoverable: !0,
			clickable: !0
		},
		tooltip: !0,
		tooltipOpts: {
			content: "%p.0%, %s",
			shifts: {
				x: 20,
				y: 0
			},
			defaultTheme: !1,
			cssClass: "flot-tooltip"
		}
	}),
	$("#donut-chart")[0] && $.plot("#donut-chart", pieData, {
		series: {
			pie: {
				innerRadius: .5,
				show: !0,
				stroke: {
					width: 2
				}
			}
		},
		legend: {
			container: ".flc-donut",
			backgroundOpacity: .5,
			noColumns: 0,
			backgroundColor: "white",
			lineWidth: 0
		},
		grid: {
			hoverable: !0,
			clickable: !0
		},
		tooltip: !0,
		tooltipOpts: {
			content: "%p.0%, %s",
			shifts: {
				x: 20,
				y: 0
			},
			defaultTheme: !1,
			cssClass: "flot-tooltip"
		}
	})
}),
/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) && $("html").addClass("ismobile")
/*, $(window).load(function () {
    $(".page-loader").fadeOut()
})*/
,
$(document).ready(function() {
	function scrollBar(selector, theme, mousewheelaxis) {
		$(selector).mCustomScrollbar({
			theme: theme,
			scrollInertia: 100,
			axis: "yx",
			mouseWheel: {
				enable: !0,
				axis: mousewheelaxis,
				preventDefault: !0
			}
		})
	}
	if ($("html").hasClass("ismobile") || $(".c-overflow")[0] && scrollBar(".c-overflow", "minimal-dark", "y"), $(".dropdown")[0] && ($("body").on("click", ".dropdown.open .dropdown-menu",
	function(e) {
		e.stopPropagation()
	}), $(".dropdown").on("shown.bs.dropdown",
	function(e) {
		$(this).attr("data-animation") && ($animArray = [], $animation = $(this).data("animation"), $animArray = $animation.split(","), $animationIn = "animated " + $animArray[0], $animationOut = "animated " + $animArray[1], $animationDuration = "", $animArray[2] ? $animationDuration = $animArray[2] : $animationDuration = 500, $(this).find(".dropdown-menu").removeClass($animationOut), $(this).find(".dropdown-menu").addClass($animationIn))
	}), $(".dropdown").on("hide.bs.dropdown",
	function(e) {
		$(this).attr("data-animation") && (e.preventDefault(), $this = $(this), $dropdownMenu = $this.find(".dropdown-menu"), $dropdownMenu.addClass($animationOut), setTimeout(function() {
			$this.removeClass("open")
		},
		$animationDuration))
	})), $("#calendar-widget")[0]) { !
		function() {
			$("#cw-body").fullCalendar({
				contentHeight: "auto",
				theme: !1,
				buttonIcons: {
					prev: " zmdi zmdi-chevron-left",
					next: " zmdi zmdi-chevron-right"
				},
				header: {
					right: "next",
					center: "title, ",
					left: "prev"
				},
				defaultDate: "2016-08-12",
				editable: !0,
				events: [{
					title: "Dolor Pellentesque",
					start: "2016-08-01",
					className: "bgm-cyan"
				},
				{
					title: "Purus Nibh",
					start: "2016-08-07",
					className: "bgm-amber"
				},
				{
					title: "Amet Condimentum",
					start: "2016-08-09",
					className: "bgm-green"
				},
				{
					title: "Tellus",
					start: "2016-08-12",
					className: "bgm-blue"
				},
				{
					title: "Vestibulum",
					start: "2016-08-18",
					className: "bgm-cyan"
				},
				{
					title: "Ipsum",
					start: "2016-08-24",
					className: "bgm-teal"
				},
				{
					title: "Fringilla Sit",
					start: "2016-08-27",
					className: "bgm-blue"
				},
				{
					title: "Amet Pharetra",
					url: "http://google.com/",
					start: "2016-08-30",
					className: "bgm-amber"
				}]
			})
		} ();
		var mYear = moment().format("YYYY"),
		mDay = moment().format("dddd, MMM D");
		$("#calendar-widget .cwh-year").html(mYear),
		$("#calendar-widget .cwh-day").html(mDay)
	}
	if ($("#input-slider-range")[0]) {
		var sliderRange = document.getElementById("input-slider-range");
		noUiSlider.create(sliderRange, {
			start: [40, 70],
			connect: !0,
			range: {
				min: 0,
				max: 100
			}
		})
	}
	if ($("#input-slider-value")[0]) {
		var sliderRangeValue = document.getElementById("input-slider-value");
		noUiSlider.create(sliderRangeValue, {
			start: [10, 50],
			connect: !0,
			range: {
				min: 0,
				max: 100
			}
		}),
		sliderRangeValue.noUiSlider.on("update",
		function(values, handle) {
			document.getElementById("input-slider-value-output").innerHTML = values[handle]
		})
	}
	if ($(".color-picker")[0] && $(".color-picker").each(function() {
		var colorOutput = $(this).closest(".cp-container").find(".cp-value");
		$(this).farbtastic(colorOutput)
	}), $(".html-editor")[0] && $(".html-editor").summernote({
		height: 150
	}), $(".html-editor-click")[0] && ($("body").on("click", ".hec-button",
	function() {
		$(".html-editor-click").summernote({
			focus: !0
		}),
		$(".hec-save").show()
	}), $("body").on("click", ".hec-save",
	function() {
		$(".html-editor-click").code(),
		$(".html-editor-click").destroy(),
		$(".hec-save").hide(),
		notify("Content Saved Successfully!", "success")
	})), $(".html-editor-airmod")[0] && $(".html-editor-airmod").summernote({
		airMode: !0
	}), $(".date-time-picker")[0] && $(".date-time-picker").datetimepicker(), $(".time-picker")[0] && $(".time-picker").datetimepicker({
		format: "LT"
	}), $(".date-picker")[0] && $(".date-picker").datetimepicker({
		format: "YYYY-M-D"
	}), $(".date-picker").click(function() {
		$(this).removeAttr('readonly');
		$(this).datetimepicker('show');
		$(this).attr('readonly','readonly');
	}
	), $(".date-picker").on("dp.hide",
	function() {
		$(this).closest(".dtp-container").removeClass("fg-toggled"),
		$(this).blur();
		$(this).attr('readonly','readonly');
		
	}), $(".form-wizard-basic")[0] && $(".form-wizard-basic").bootstrapWizard({
		tabClass: "fw-nav",
		nextSelector: ".next",
		previousSelector: ".previous"
	}),
	function() {
		Waves.attach(".btn:not(.btn-icon):not(.btn-float)"),
		Waves.attach(".btn-icon, .btn-float", ["waves-circle", "waves-float"]),
		Waves.init()
	} (), $(".lightbox")[0] && $(".lightbox").lightGallery({
		enableTouch: !0,
		selector: '.lightbox-item'
	}), $("body").on("click", ".a-prevent",
	function(e) {
		e.preventDefault()
	}), $(".collapse")[0] && ($(".collapse").on("show.bs.collapse",
	function(e) {
		$(this).closest(".panel").find(".panel-heading").addClass("active")
	}), $(".collapse").on("hide.bs.collapse",
	function(e) {
		$(this).closest(".panel").find(".panel-heading").removeClass("active")
	}), $(".collapse.in").each(function() {
		$(this).closest(".panel").find(".panel-heading").addClass("active")
	})), $('[data-toggle="tooltip"]')[0] && $('[data-toggle="tooltip"]').tooltip(), $('[data-toggle="popover"]')[0] && $('[data-toggle="popover"]').popover(), $("html").hasClass("ie9") && $("input, textarea").placeholder({
		customClass: "ie9-placeholder"
	}), $(".typeahead")[0]) {
		var statesArray = ["Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Ohio", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas", "Utah", "Vermont", "Virginia", "Washington", "West Virginia", "Wisconsin", "Wyoming"],
		states = new Bloodhound({
			datumTokenizer: Bloodhound.tokenizers.whitespace,
			queryTokenizer: Bloodhound.tokenizers.whitespace,
			local: statesArray
		});
		$(".typeahead").typeahead({
			hint: !0,
			highlight: !0,
			minLength: 1
		},
		{
			name: "states",
			source: states
		})
	}
	$(".dropzone")[0] && (Dropzone.autoDiscover = !1, $("#dropzone-upload").dropzone({
		url: "/file/post",
		addRemoveLinks: !0
	}))
}),
$(document).ready(function() {
	$("#map-world")[0] && $("#map-world").vectorMap({
		map: "world_en",
		backgroundColor: null,
		color: "#eee",
		borderColor: "#eee",
		hoverOpacity: 1,
		selectedColor: "#00BCD4",
		enableZoom: !0,
		showTooltip: !0,
		normalizeFunction: "polynomial",
		selectedRegions: ["US", "EN", "NZ", "CN", "JP", "SL", "BR", "AU"],
		onRegionClick: function(event) {
			event.preventDefault()
		}
	})
}),
$(function() {
	$("#editor")[0] && (function() {
		if($('.SendComment').attr('comment-type')!='2') $('label',$('.SendComment').parent()).hide();
	})();
	$("#editor")[0] && $('#editor').focus(function() {
		if ($(this).html() == '写下你的留言...') {
			$(this).empty();
		}
	});
	$('.SendComment')[0] && $('.SendComment').click(function() {
		if($(this).attr('comment-type') == '1'){ //回复
			var texbox = $('textarea',$(this).parent().parent()),
			tex = texbox.val();
		}else{
			var texbox = $('#editor', $(this).parent().parent()),
			tex = texbox.html();
		}
		isPrivate=$('input[type=checkbox]',$(this).parent()).is(":checked");
		CommentButton = $(this);
		if (tex == '' || tex == '写下你的留言...') {
			notify('留言内容不能为空！', 'warning');
			return;
		}
		$(texbox).attr('disabled', 'disabled');
		$.ajax({
			url: '/?_func=Comment&_do=Send',
			dataType: 'json',
			method: 'post',
			data: {
				Text: tex,
				CommentType: $(CommentButton).attr('comment-type'),
				CommentType: $(CommentButton).attr('comment-type'),
				CommentId: $(CommentButton).attr('comment-to'),
				IsPrivate:isPrivate
			},
			success: function(data) {
				if (data.Code == 1) {
					$(texbox).removeAttr('disabled').val('');
					$.pjax.reload('#main', {
						fragment: '#main'
					});
					notify('发送成功！', 'success');
				} else {
					$(texbox).removeAttr('disabled').val(tex);
					notify(data.Message, 'danger');
				}
			},
			error: function() {
				$(texbox).attr('placeholder', '发送失败,请重试.').removeAttr('disabled').val(tex);
				notify('网络错误！', 'danger');
			}
		});
	});
	$("#editor")[0] && $("#editor").emoji({
		showTab: true,
		animation: 'fade',
		button: "#emojiButton",
		icons: [{
			name: "贴吧表情",
			path: "/assets/img/emoji/tieba/",
			maxNum: 50,
			file: ".jpg",
			placeholder: ":{alias}:",
			alias: {
				1 : "hehe",
				2 : "haha",
				3 : "tushe",
				4 : "a",
				5 : "ku",
				6 : "lu",
				7 : "kaixin",
				8 : "han",
				9 : "lei",
				10 : "heixian",
				11 : "bishi",
				12 : "bugaoxing",
				13 : "zhenbang",
				14 : "qian",
				15 : "yiwen",
				16 : "yinxian",
				17 : "tu",
				18 : "yi",
				19 : "weiqu",
				20 : "huaxin",
				21 : "hu",
				22 : "xiaonian",
				23 : "neng",
				24 : "taikaixin",
				25 : "huaji",
				26 : "mianqiang",
				27 : "kuanghan",
				28 : "guai",
				29 : "shuijiao",
				30 : "jinku",
				31 : "shengqi",
				32 : "jinya",
				33 : "pen",
				34 : "aixin",
				35 : "xinsui",
				36 : "meigui",
				37 : "liwu",
				38 : "caihong",
				39 : "xxyl",
				40 : "taiyang",
				41 : "qianbi",
				42 : "dnegpao",
				43 : "chabei",
				44 : "dangao",
				45 : "yinyue",
				46 : "haha2",
				47 : "shenli",
				48 : "damuzhi",
				49 : "ruo",
				50 : "OK"
			},
			title: {
				1 : "呵呵",
				2 : "哈哈",
				3 : "吐舌",
				4 : "啊",
				5 : "酷",
				6 : "怒",
				7 : "开心",
				8 : "汗",
				9 : "泪",
				10 : "黑线",
				11 : "鄙视",
				12 : "不高兴",
				13 : "真棒",
				14 : "钱",
				15 : "疑问",
				16 : "阴脸",
				17 : "吐",
				18 : "咦",
				19 : "委屈",
				20 : "花心",
				21 : "呼~",
				22 : "笑脸",
				23 : "冷",
				24 : "太开心",
				25 : "滑稽",
				26 : "勉强",
				27 : "狂汗",
				28 : "乖",
				29 : "睡觉",
				30 : "惊哭",
				31 : "生气",
				32 : "惊讶",
				33 : "喷",
				34 : "爱心",
				35 : "心碎",
				36 : "玫瑰",
				37 : "礼物",
				38 : "彩虹",
				39 : "星星月亮",
				40 : "太阳",
				41 : "钱币",
				42 : "灯泡",
				43 : "茶杯",
				44 : "蛋糕",
				45 : "音乐",
				46 : "haha",
				47 : "胜利",
				48 : "大拇指",
				49 : "弱",
				50 : "OK"
			}
		},
		{
			name: "QQ高清",
			path: "/assets/img/emoji/qq/",
			maxNum: 91,
			excludeNums: [41, 45, 54],
			file: ".gif",
			placeholder: "#qq_{alias}#"
		},
		{
			name: "emoji高清",
			path: "/assets/img/emoji/emoji/",
			maxNum: 84,
			file: ".png",
			placeholder: "#emoji_{alias}#"
		}]
	});
});
function notify(msg, type) {
	$.growl({
		message: msg
	},
	{
		element: 'body',
		type: type,
		allow_dismiss: true,
		offset: {
			x: 20,
			y: 85
		},
		spacing: 10,
		z_index: 1031,
		delay: 5000,
		timer: 1000,
		mouse_over: false,
		animate: {
			enter: 'animated fadeInRight',
			exit: 'animated fadeOutRight'
		},
	});
};
function unique4(array) {
	array.sort();
	var re = [array[0]];
	for (var i = 1; i < array.length; i++) {
		if (array[i] !== re[re.length - 1]) {
			re.push(array[i]);
		}
	}
	return re;
}