<?php namespace Phpcmf\Controllers\Admin;

class Player extends \Phpcmf\Common
{

    public function index() {

        $page = intval(\Phpcmf\Service::L('Input')->get('page'));

        if (IS_POST) {
            $post = \Phpcmf\Service::L('Input')->post('data', true);
            \Phpcmf\Service::L('Config')->file(WRITEPATH.'config/player.php', '播放器配置文件', 32)->to_require($post);
            \Phpcmf\Service::L('Input')->system_log('设置播放器配置信息');
            exit($this->_json(1, dr_lang('操作成功')));
        }

        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('auth')->_admin_menu(
                [
                    '播放器设置' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-cog'],
                ]
            ),
            'type' => [
                'front' => '前置广告',
                'pause' => '暂停广告',
                #'insert' => '插入广告',
                'end' => '结束广告',
                #'other' => '其它广告',
            ],
            'page' => $page,
            'value' => $this->player_config,
            'form' => dr_form_hidden(),
        ]);
        \Phpcmf\Service::V()->display('player_ad_config.html');
    }


}
