<?php namespace Phpcmf\Controllers\Admin;

// 视频广告基于 Ftable
class Player_ad extends \Phpcmf\Table
{

    public function __construct(...$params) {
        parent::__construct(...$params);
        // 支持附表存储
        $this->is_data = 0;
        // 模板前缀(避免混淆)
        $this->tpl_prefix = 'player_ad_';
        // 模块显示名称
        $this->name = dr_lang('广告管理');
        $type = '';
        $mtype = [
            'front' => '前置广告',
            'pause' => '暂停广告',
            #'insert' => '插入广告',
            'end' => '结束广告',
            #'other' => '其它广告',
        ];
        foreach ($mtype as $i => $item) {
            $type.= $item.'|'.$i.PHP_EOL;
        }
        $myfield = [
            'name' => [
                'ismain' => 1,
                'name' => dr_lang('名称'),
                'fieldname' => 'name',
                'fieldtype' => 'Text',
                'setting' => array(
                    'option' => array(
                        'width' => 300,
                    ),
                    'validate' => array(
                        'required' => 1,
                    ),
                )
            ],
            'tid' => [
                'ismain' => 1,
                'name' => dr_lang('放置位置'),
                'fieldname' => 'tid',
                'fieldtype' => 'Radio',
                'setting' => array(
                    'option' => array(
                        'options' => $type,
                    ),
                    'validate' => array(
                        'required' => 1,
                    ),
                )
            ],
            'file' => array(
                'ismain' => 1,
                'name' => dr_lang('广告文件'),
                'fieldtype' => 'File',
                'fieldname' => 'file',
                'setting' => array(
                    'option' => array(
                        'ext' => 'jpg,jpeg,png,gif,swf,mp4,flv,f4v',
                        'input' => 1,
                        'size' => 100,
                    ),
                    'validate' => array(
                        'required' => 1,
                    ),
                )
            ),
            'time' => [
                'ismain' => 1,
                'name' => dr_lang('播放时间'),
                'fieldname' => 'time',
                'fieldtype' => 'Text',
                'setting' => array(
                    'option' => array(
                        'width' => 200,
                        'value' => 10
                    ),
                    'validate' => array(
                        'required' => 1,
                        'tips' => dr_lang('单位秒，指广告自动关闭时间'),
                    ),
                )
            ],
            'url' => [
                'ismain' => 1,
                'name' => dr_lang('链接地址'),
                'fieldname' => 'url',
                'fieldtype' => 'Text',
                'setting' => array(
                    'option' => array(
                        'width' => 400,
                    ),
                    'validate' => array(
                        'required' => 1,
                    ),

                )
            ],
            'inputtime' => [
                'ismain' => 1,
                'name' => dr_lang('开始时间'),
                'fieldname' => 'inputtime',
                'fieldtype' => 'Date',
                'setting' => array(
                    'option' => array(
                        'format2' => 1,
                    ),
                    'validate' => array(
                        'required' => 1,
                    ),
                )
            ],
            'endtime' => [
                'ismain' => 1,
                'name' => dr_lang('结束时间'),
                'fieldname' => 'endtime',
                'fieldtype' => 'Date',
                'setting' => array(
                    'option' => array(
                        'format2' => 1,
                    ),
                )
            ],
        ];
        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_video_player_ad',
            'field' => $myfield,
            'show_field' => 'name',
            'order_by' => 'id ASC',
        ]);
        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('auth')->_admin_menu(
                [
                    '广告管理' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-amazon'],
                    '添加' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/add', 'fa fa-plus'],
                    '修改' => ['hide:'.APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/edit', 'fa fa-edit'],
                ]
            ),
            'field' => $this->init['field'],
            'type' => $mtype,
        ]);
    }

    // ========================

    // 后台查看列表
    public function index() {

        list($tpl) = $this->_List();

        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台添加内容
    public function add() {
        list($tpl) = $this->_Post(0);
        \Phpcmf\Service::V()->assign([
            'form' => dr_form_hidden(),
        ]);
        \Phpcmf\Service::V()->display($tpl);exit;
    }

    // 后台修改内容
    public function edit() {
        list($tpl) = $this->_Post(intval(\Phpcmf\Service::L('Input')->get('id')));
        \Phpcmf\Service::V()->assign([
            'form' => dr_form_hidden(),
        ]);
        \Phpcmf\Service::V()->display($tpl);exit;
    }

    // 后台状态
    public function zt_edit() {

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $row = \Phpcmf\Service::M()->table($this->init['table'])->get($id);
        !$row && $this->_json(0, dr_lang('数据#%s不存在', $id));

        $v = $row['status'] ? 0 : 1;
        \Phpcmf\Service::M()->table($this->init['table'])->update($id, ['status' => $v]);

        exit($this->_json(1, dr_lang(!$v ? '广告已被禁用' : '广告已被启用'), ['value' => $v]));
    }

    // 后台删除内容
    public function del() {
        $this->_Del(
            \Phpcmf\Service::L('Input')->get_post_ids(),
            null,
            null,
            \Phpcmf\Service::M()->dbprefix($this->init['table'])
        );
    }

}
