<?php

// 初始化程序执行代码
if (is_file(WRITEPATH.'config/player.php')) {
    $this->player_config = require WRITEPATH.'config/player.php';
} else {
    $this->player_config = [];
}

// 格式化视频数据
function dr_format_son_list($list, $type) {

    if (!$list) {
        return [];
    }

    $type = dr_string2array($type);
    if (!$type) {
        $type = [
            0 => '',
        ];
    }

    $rt = [];
    foreach ($type as $tid => $name) {

        if (!isset($rt[$tid])) {
            $rt[$tid] = [];
        }

        if ($list) {
            foreach ($list as $i => $t) {
                if ($t['tid'] == $tid) {
                    $rt[$tid][] = $t;
                    unset($list[$i]);
                }
            }
        }
    }

    return $rt;
}

function dr_son_type($type) {

    $type = dr_string2array($type);
    if (!$type) {
        $type = [
            0 => dr_lang('默认'),
        ];
    }

    return $type;
}


if (!function_exists('dr_son_url')) {
    function dr_son_url($data)
    {
        return '/index.php?s=video&c=son&m=show&id=' . $data['id'];
    }
}

// 是否存在中 1收藏了 2没有收藏
function dr_is_video_cart($dir, $id, $uid = 0) {

    !$uid && $uid = \Phpcmf\Service::C()->uid;
    if (!$uid) {
        return 0;
    } elseif (!$dir) {
        return 0;
    }

    return \Phpcmf\Service::M()->db->table(SITE_ID.'_'.$dir.'_cart')->where('uid', $uid)->where('cid', $id)->countAllResults();
}

// 是否购买了
function dr_is_video_buy($dir, $id, $uid = 0) {

    !$uid && $uid = \Phpcmf\Service::C()->uid;

    if (!$uid) {
        return 0;
    } elseif (!$dir) {
        return 0;
    } elseif (!$id) {
        return 0;
    }

    $cache = md5($dir.$id.$uid);
    if (isset(\Phpcmf\Service::C()->temp[$cache])) {
        return \Phpcmf\Service::C()->temp[$cache];
    }

    \Phpcmf\Service::C()->temp[$cache] = \Phpcmf\Service::M()->db->table(SITE_ID.'_'.$dir.'_buy')->where('uid', (int)$uid)->where('cid', (int)$id)->countAllResults();

    return \Phpcmf\Service::C()->temp[$cache];
}

// 获取视频数据
function dr_get_video_data($id) {

    list($a, $data) = \Phpcmf\Service::L('cache')->init()->get('module_video_from_son_show_id_'.$id);
    if (!$data) {
        list($data) = \Phpcmf\Service::M('player')->get_video_data($id);
    }

    return $data;
}

// 调用视频播放器
function dr_video_player($id, $width = '100%', $height = '400px', $is_vip = 0, $vip_time = 0) {

    $sn = 'YSCMS'.$id;

    $data = dr_get_video_data($id);
    $thumb = dr_get_file($data['mftp']);
    $prev = $data['prev_page']['url'];
    $next = $data['next_page']['url'];
    $ckplayer_url = 'website:'.SITE_URL.urlencode('index.php?s=video&c=player&id='.$id);

    $tsd_json = '[]';
    if ($data['tsd']) {
        $tsd = dr_string2array($data['tsd']);
        if ($tsd) {
            $tsd_json = [];
            foreach ($tsd as $t) {
                $tsd_json[] = [
                    'time' => $t['name'],
                    'words' => $t['value']
                ];
            }
            $tsd_json = json_encode($tsd_json);
        }
    }

    $prev && $prev = 'window.location.href = "'.$prev.'";';
    $next && $next = 'window.location.href = "'.$next.'";';


    $config = \Phpcmf\Service::C()->player_config;

    $flashplayer = $config['flashplayer'] ? 'true' : 'false';
    $auto_play = $config['auto_play'] ? 'true' : 'false';
    $auto_next = $config['auto_next'] ? $next : '';

    $adurl = $is_vip ? '' : 'website:'.SITE_URL.urlencode('index.php?s=video&c=player&m=ad');

    // 试看
    $vip = '';
    if ($config['viptime'] && $vip_time) {
        $vip = ' if(time >= '.$config['viptime'].' ) {
           player.videoPause();
        }';
    }

    // 记忆播放
    $seek = 0;
    $seek_html = '';
    if ($config['auto_time']) {
        $seek = intval(\Phpcmf\Service::L('Input')->get_cookie('player_time_'.$id));
        $seek_html = 'dr_player_auto_time(time);';
        if (isset($_GET['playtime']) && $_GET['playtime']) {
            $seek = intval($_GET['playtime']);
        }
    }


    $html = '
    <script type="text/javascript" src="/static/assets/ckplayer/ckplayer.js"></script>
                <div id="video_'.$sn.'" style="width: '.$width.'; height: '.$height.';"></div>
                <script type="text/javascript">
                    var videoObject = {
                        container: \'#video_'.$sn.'\',
				        loaded: \'loadedHandler_'.$sn.'\',
                        variable: \'player\',
                        flashplayer:'.$flashplayer.',
                        autoplay:'.$auto_play.',
				        advertisements:\''.$adurl.'\',
				        front:\'frontFun_'.$sn.'\',
				        next:\'nextFun_'.$sn.'\',
                        poster:\''.$thumb.'\',
                        seek: '.$seek.',
                        promptSpot: '.$tsd_json.',
                        video: \''.$ckplayer_url.'\'
                    };
                    var player = new ckplayer(videoObject);
                    function loadedHandler_'.$sn.'() {
                        player.addListener(\'time\', timeHandler_'.$sn.');
                        player.addListener(\'ended\', endedHandler_'.$sn.');
                    }       
                    function timeHandler_'.$sn.'(time) {
                       '.$vip.'
                       '.$seek_html.'
                    }
                    function frontFun_'.$sn.'() {
                        '.$prev.'
                    }
                    function nextFun_'.$sn.'() {
                        '.$next.'
                    }
                    function endedHandler_'.$sn.'() {
                        '.$auto_next.'
                    }
                </script>
                <div id="aa_'.$sn.'"></div>
    ';

    return $html;
}