<?php namespace Phpcmf\Model;

// 播放器
class Player extends \Phpcmf\Model {

    public function cache($site = SITE_ID) {

        $cache = [
            'front' => [],
            'pause' => [],
            'insert' => [],
            'inserttime' => '10,15',
            'end' => [],
            'other' => [],
        ];

        $result = $this->table($site.'_video_player_ad')->where('status', 1)->getAll();
        if ($result) {
            foreach ($result as $t) {
                if ($t['inputtime'] < SYS_TIME) {
                    if ($t['endtime'] && $t['endtime'] < SYS_TIME) {
                        continue; // 过期了
                    }
                    $file = dr_get_file($t['file']);
                    $data = [
                        'file' => $file,
                        'type' => substr(strrchr($file, '.'), 1),
                        'link' => $t['url'],
                        'time' => $t['time'] ? $t['time'] : 10,
                    ];
                    $cache[$t['tid']][] = $data;
                }
            }
        }

        \Phpcmf\Service::L('cache')->set_file('video_player_ad_'.$site, $cache);
    }

    public function get_video_data($data) {

        // 查询表
        if (is_numeric($data)) {
            $data = \Phpcmf\Service::M('content')->_init('video')->get_form_row($data, 'son');
            $data['files'] = dr_get_files($data['files']);
        }

        $_test_0 = 0;
        $_test_1 = [];
        $data['prev_page'] = $data['next_page'] = [];

        $son = \Phpcmf\Service::M()->table(SITE_ID.'_video_form_son')
            ->where('cid', (int)$data['cid'])
            ->where('status=1')
            ->order_by('displayorder asc,id asc')->getAll();
        if ($son) {
            foreach ($son as $i => $t) {
                $son[$i]['url'] = dr_son_url($t);
                if ($t['id'] == $data['id']) {
                    // 找到了
                    $_test_0 = 1;
                    $data['prev_page'] = $_test_1;
                } elseif ($_test_0) {
                    $_test_0 = 0;
                    $data['next_page'] = $son[$i];
                }
                $_test_1 = $son[$i];
            }
        }

        $data['ckplayer_data'] = [];
        if ($data['files']) {
            foreach ($data['files'] as $t) {
                $data['ckplayer_data'][] = [
                    dr_get_file($t['file']),
                    'video/mp4',
                    $t['title'],
                    0
                ];
            }
        }

        return [$data, $son];
    }
}