<?php
namespace Admin\Controller;

/**
 * 后台配置控制器
 */
class ConfigController extends AdminController {
    /**
     * 批量保存配置
     */
    public function save($config){
        if($config && is_array($config)){
            $Config = M('Config');
            foreach ($config as $name => $value) {
                $map = array('name' => $name);
                if(is_array($value)){
                    $value=implode(",", $value);
                }
                $Config->where($map)->setField('value', $value);
            }
        }
        S('DB_CONFIG_DATA',null);
		//记录行为
        action_log('update_config','config','',UID);
        $this->success('保存成功！');
    }

    // 获取某个标签的配置参数
    public function group() {
        $id     =   I('get.id',1);
        $type   =   C('CONFIG_GROUP_LIST');
        $list   =   M("Config")->where(array('group'=>$id,'display'=>array('gt',0)))->field('id,name,title,extra,value,remark,type')->order('sort')->select();
        if($list) {
            $this->assign('list',$list);
        }
        $this->assign('id',$id);
        $this->meta_title = $type[$id].'设置';
        $this->display();
    }
}
