<?php
//安装完请删除这个
if(!file_exists('./install/install.lock')){
header('location:/install/');
}//安装完请删除这个

start(array(
    'index_file' => dirname(__FILE__) . '/yycms.php', //你首页的文件名
    'cache_file' => dirname(__FILE__) . '/cache/index/index.html', //要缓存的文件名
    'expire_seconds' => 8400, //过期的秒数（60秒=1分钟）
));
function start($config) {
    $remain_seconds = $file_timestamp = 0;
    if (hasCached($config, $remain_seconds, $file_timestamp)) {
        $html = '';
        $html .= file_get_contents($config['cache_file']);
        die($html);
    }
    ob_start();
    include($config['index_file']);
    $content = ob_get_contents();
    file_put_contents($config['cache_file'], $content);
}

function hasCached($config, &$remain_seconds, &$file_timestamp) {
    if (!file_exists($config['cache_file'])) {
        return FALSE;
    }
    if (filesize($config['cache_file']) === 0) {
        return FALSE;
    }
    $file_timestamp = filemtime($config['cache_file']);
    $remain_seconds = $config['expire_seconds'] - (time() - $file_timestamp);
    if ($remain_seconds <= 0) {
        return FALSE;
    }
    return TRUE;
}