<?php
/**
 * 加载类
 * PHP version 5.4+
 * 
 * @category Common
 * 
 * @package Loader
 * 
 * @author fy <jhfangying@qq.com>
 * 
 * @license Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * 未经许可，任何单位及个人不得做营利性使用
 * 
 * @link link('演示地址','http://xc.taobaodpm.com');
 * */

/**
 * 加载类
 * PHP version 5.4+
 * 
 * @category Common
 * 
 * @package Loader
 * 
 * @author fy <jhfangying@qq.com>
 * 
 * @license Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * 未经许可，任何单位及个人不得做营利性使用
 * 
 * @link link('演示地址','http://xc.taobaodpm.com');
 * */
class Loader
{
    static private $_instance=null;
    var $_models=[];
    /**
     * 构造函数
     */
    function __construct()
    {

    }
    /**
     * 获取实例
     * 
     * @return 获取已经实例化的实例
     */
    static public function getInstance()
    {
        if (!self::$_instance instanceof self) {
             self::$_instance = new self();
        }
        return self::$_instance;
    }
    /**
     * 获取实例
     * 
     * @param text $modelname model的名称
     * 
     * @return 获取已经实例化的实例
     */
    function model($modelname)
    {
        //已经加载过的
        if (in_array($modelname, $this->_models)) {
            return $this;
        }
        $lowmodelname=strtolower($modelname);
        $filename=$lowmodelname.'.php';
        $path=dirname(__FILE__) .DIRECTORY_SEPARATOR.'..'
            .DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.$filename;
        if (file_exists($path)) {
            include_once $path;
            $this->$lowmodelname=new $modelname();
            array_push($this->_models, $modelname);
        } else {
            throw new RuntimeException("{$modelname}不存在");
        }
        return $this;
    }
}