<?php
/**
 * 手机端摇一摇数据处理
 * PHP version 5.4+
 * 
 * @category Mobile
 * 
 * @package Shake
 * 
 * @author fy <jhfangying@qq.com>
 * 
 * @license Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * Copyright (c) 2017 金华迪加网络科技有限公司 版权所有
 * 未经许可，任何单位及个人不得做营利性使用
 * 
 * @link link('演示地址','http://xc.taobaodpm.com');
 * */
error_reporting(E_ALL);
require_once dirname(__FILE__) . '/../common/db.class.php';
require_once dirname(__FILE__) . '/../common/function.php';
$action = $_GET ['action'];
switch ($action) {
case 'getstatus':
    getstatus();
    break;
case 'run':
    run();
    break;
default:
    // code...
    break;
}
/**
 * 提交摇晃手机的数据
 * 
 * @return text  服务器接收到数据后返回json结构的数据
 */
function run()
{
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $shake_config=$load->shake_model->getCurrentConfig();
    $userid=isset($_POST['userid'])?intval($_POST['userid']):0;
    $updatingscore=rand(3,12);//isset($_POST['updatingscore'])?intval($_POST['updatingscore']):0;
    if ($userid<=0) {
        $returndata=array('code'=>-2,'msg'=>"用户数据错误");
        echo json_encode($returndata);
        return;
    }
    
    if ($shake_config['status']==1) {
        $returndata
            =array('code'=>3,'status'=>$shake_config['status'],'msg'=>"游戏还没有开始");
        echo json_encode($returndata);
        return;
    }

    if ($shake_config['status']==3) {
        $returndata
            =array('code'=>2,'status'=>$shake_config['status'],'msg'=>"游戏已经结束");
        echo json_encode($returndata);
        return;
    }
    $result=$load->shake_model->addScore($userid, $updatingscore);
    $returndata=array();
    $returndata['code']=$result['code'];
    $returndata['status']=$shake_config['status'];
    $returndata['msg']='';
    $returndata['data']=$result['data'];
    echo json_encode($returndata);
    return;
}
/**
 * 获取游戏状态
 * 
 * @return text  服务器接收到请求后返回当前的游戏状态
 */
function getstatus()
{
    $load=Loader::getInstance();
    $load->model('Shake_model');
    $shake_config=$load->shake_model->getCurrentConfig();

    if (!$shake_config) {
        $returndata=array('code'=>-1,'msg'=>"数据错误");
        echo json_encode($returndata);
        return;
    }
    if ($shake_config['currentshow']==1) {
        $returndata=array('code'=>-2,'msg'=>"请刷新页面获取最新的活动");
        echo json_encode($returndata);
        return;
    }
    //正常数据的活动状态
    if ($shake_config['status']==1) {
        $returndata
            =array('code'=>1,'status'=>$shake_config['status'],'msg'=>"活动还未开始请耐心等待");
        echo json_encode($returndata);
        return;
    }

    if ($shake_config['status']==3) {
        $returndata=array(
            'code'=>1,
            'status'=>$shake_config['status'],
            'msg'=>"本轮活动已经结束,你可以刷新页面来获取新一轮活动"
        );
        echo json_encode($returndata);
        return;
    }

    if ($shake_config['status']==2) {
        $returndata
            =array('code'=>1,'status'=>$shake_config['status'],'msg'=>"游戏进行中");
        echo json_encode($returndata);
        return;
    }
}