<?php
//flag model 用户信息
class Flag_model{
	var $_flag_config_m=null;
	var $_flag_reserved_infomation_m=null;
	var $_flag_m=null;
	var $_flag_extention_column_type_m=null;
	var $_flag_extension_data_m=null;
	function __construct(){
		$this->_flag_m=new M('flag');
		$this->_flag_config_m=new M('flag_config');
		$this->_flag_extention_column_type_m=new M('flag_extention_column_type');
		$this->_flag_extension_data_m=new M('flag_extention_data');
		$this->_flag_reserved_infomation_m=new M('flag_reserved_infomation');
	}
	//保存提交的数据
	function saveExtentionData($data){
		if($this->getExtentionDataByUserId($data['userid'])){
			return $this->_flag_extension_data_m->update('userid='.$data['userid'],$data);
		}
		$data['created_at']=time();
		return $this->_flag_extension_data_m->add($data);
	}
	//按照
	function getExtentionDataByUserId($userid){
		return $this->_flag_extension_data_m->find('userid=>'.$userid);
	}
	//删除1个字段
	function deleteExtentionColumnsById($id){
		$data=$this->_flag_extention_column_type_m->delete('id='.$id);
		return $data;
	}
	
	//获取一个自定义扩展字段信息
	function getExtentionColumnsById($id){
		$data=$this->_flag_extention_column_type_m->find('id='.$id);
		return $data;
	}
	//获取自定义扩展字段信息
	function getExtentionColumns(){
		$data=$this->_flag_extention_column_type_m->select('1 order by ordernum asc,created_at asc');
		return $data;
	}
	//保存扩展字段
	function saveExtentionColumn($column){
		$id=isset($column['id'])?intval($column['id']):0;
		if($id>0){
			unset($column['id']);
			$this->_flag_extention_column_type_m->update('id='.$id,$column);
			return $id;
		}else{
			$column['created_at']=time();
			return $this->_flag_extention_column_type_m->add($column);
		}
	}

	//清空用户信息
	function clearUserInfo(){
		$this->_flag_extension_data_m->query('truncate table weixin_flag_extention_data');
		return $this->_flag_m->query('truncate table weixin_flag');
	}
	//获取已经签到的人的数量
	function getSignedCount(){
		return $this->_getUsersCount('flag=2'); 
	}

	//获取通过审核的人数
	function getShenheCount(){
		return $this->_getUsersCount('flag=2 and status=1'); 
	}

	//按照openid获取用户相关的信息
	function getUserinfo($openid,$withextentions=false,$withreservedinfomation=false){
		$where='openid="'.$openid.'"';
		$join='';
		$select='*';
		if($withreservedinfomation){
			$flagconfig=$this->getConfig();
			if($flagconfig['reserved_infomation_match']==1){
				$join='left join weixin_flag_reserved_infomation on (weixin_flag_reserved_infomation.realname=weixin_flag.signname or  weixin_flag_reserved_infomation.phone=weixin_flag.phone) ';
			}else{
				$join='left join weixin_flag_reserved_infomation on (weixin_flag_reserved_infomation.realname=weixin_flag.signname and  weixin_flag_reserved_infomation.phone=weixin_flag.phone) ';
			}
			$select='weixin_flag.*,weixin_flag_reserved_infomation.info,weixin_flag_reserved_infomation.realname as verify_realname,weixin_flag_reserved_infomation.phone as verify_phone';
		}
		return $this->_flag_m->find('openid="'.$openid.'"',$select,'','assoc',$join);
	}
	
	//按照id获取用户相关信息
	function getUserinfoById($id){
		return $this->_flag_m->find('id="'.$id.'"','*');
	}
	//获取当前最大的审核编号
	function getMaxSignorder(){
		$signorder=$this->_flag_m->find('1 limit 0,1','signorder','max');
		$signorder=isset($signorder)?intval($signorder):0;
		return $signorder;
	}

	//保存用户信息，目前用于确认签到
	function saveUserinfo($info){
		$openid=$info['openid'];
		unset($info['openid']);
		$query=$this->_flag_m->update("openid='" . $openid . "'", $info);
		return $query;
	}
	
	//获取查询结果的分页数据
	function getPagedData($where,$page,$pagesize,$joinextention=false){
		$data=$this->_getPagedUsers($where,$page,$pagesize,$joinextention);
		$count=$this->_getUsersCount($where);
		return array('data'=>$data,'count'=>$count);
	}
	//获取审核用户的数据
	function getShenheUsers($lastsignorder=0,$num=50){
		$where='signorder>'.$lastsignorder.' and flag=2 and status=1 order by signorder asc';
		$data=$this->_getPagedUsers($where,1,$num);
		return $data;
	}
	//获取最近签到的人信息
	function getRecentSignedUsers($num=30,$lastsignorder=0){
		$where='flag=2 and status=1 order by signorder desc';
		if($lastsignorder>0){
			$where='signorder > '.$lastsignorder.' and '.$where;
		}
		$returndata=$this->_getPagedUsers($where,1,$num);
		return $returndata;
	}

	//保存扫码后由微信提供的用户信息
	function saveRemoteUserinfo($info){
		//解决转义符
		//json字符串转化成数组
		$infoarr=null;
		if(is_array($info)){
			$infoarr=$info;
		}else{
			$infoarr = json_decode($infoarr, true);
		}

		$flag_info=$this->_flag_m->find("openid='" . $infoarr['openid'] . "'");
		if(intval($flag_info['flag'])>=2){
			return true;
		}
		$flag_info_new = array(
			"openid"=>$infoarr['openid'],
			"rentopenid"=>$infoarr['rentopenid'],
			"nickname" => $infoarr['nickname'],
			"avatar" => $infoarr['headimgurl'],
			"sex" => $infoarr['sex'],
			"fromtype" => 'weixin',
			"datetime" => time(),
			"flag" => "1"
		);
		
		$id=isset($flag_info['id'])?$flag_info['id']:0;
		if ($id>0) {
			unset($flag_info_new['openid']);
			$save = $this->_flag_m->update("openid='" . $infoarr['openid'] . "'", $flag_info_new);
		}else{
			$save = $this->_flag_m->add($flag_info_new);
		}
		if ($save) {
			return true;
		}else{
			return false;
		}
	}
	//添加预留信息
	public function addReservedInfomation($data){
		// echo var_export($data);
		$result=$this->_flag_reserved_infomation_m->add($data);
		return $result;
	}
	public function clearReservedInfomation(){
		$this->_flag_reserved_infomation_m->query('truncate table weixin_flag_reserved_infomation');
	}
	//获取全部的数据
	public function getAllUsers(){
		$where=' 1 order by weixin_flag.id asc';
		$join='left join weixin_flag_extention_data on weixin_flag_extention_data.userid=weixin_flag.id';
		$columns='weixin_flag.nickname,weixin_flag.avatar,weixin_flag.signname,weixin_flag.phone,weixin_flag_extention_data.datastr';
		$data=$this->_flag_m->select($where,$columns,'','assoc',$join);
		foreach($data as $k=>$v){
			$data[$k]['extentions']=unserialize($v['datastr']);
		}
		return $data;
	}
	//按照条件获取用户列表
	private function _getPagedUsers($where,$page,$pagesize,$joinextention=false){
		$page=$page>0?$page:1;
		$wherecondition=$where. ' limit '.(($page-1)*$pagesize).','.$pagesize;
		if($joinextention==true){
			$join='left join weixin_flag_extention_data on weixin_flag_extention_data.userid=weixin_flag.id';
			$data=$this->_flag_m->select($wherecondition,'weixin_flag.*,weixin_flag_extention_data.datastr','','assoc',$join);
			foreach($data as $k=>$v){
				$data[$k]['extentions']=unserialize($v['datastr']);
			}
		}else{
			$data=$this->_flag_m->select($wherecondition,'*');
		}
		
		return $data;
	}

	//保存配置
	public function setConfig($data){
		return $this->_flag_config_m->update('1',$data);
	}

	//读取配置
	public function getConfig(){
		$data=$this->_flag_config_m->find('1');
		return $data;
	}

	//按照条件获取用户的数量
	private function _getUsersCount($where){
		$count=$this->_flag_m->find($where,'*','count');
		return $count;
	}


}